/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.spi;

import io.takari.incrementalbuild.spi.Plexus_MatchPattern;
import java.io.File;
import java.util.ArrayList;

class Plexus_MatchPatterns {
    private final Plexus_MatchPattern[] patterns;

    private Plexus_MatchPatterns(Plexus_MatchPattern[] patterns) {
        this.patterns = patterns;
    }

    public boolean matches(String name, boolean isCaseSensitive) {
        String[] tokenized = Plexus_MatchPattern.tokenizePathToString(name, File.separator);
        return this.matches(name, tokenized, isCaseSensitive);
    }

    public boolean matches(String name, String[] tokenizedName, boolean isCaseSensitive) {
        char[][] tokenizedNameChar = new char[tokenizedName.length][];
        for (int i = 0; i < tokenizedName.length; ++i) {
            tokenizedNameChar[i] = tokenizedName[i].toCharArray();
        }
        for (Plexus_MatchPattern pattern : this.patterns) {
            if (!pattern.matchPath(name, tokenizedNameChar, isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesPatternStart(String name, boolean isCaseSensitive) {
        for (Plexus_MatchPattern includesPattern : this.patterns) {
            if (!includesPattern.matchPatternStart(name, isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    public static Plexus_MatchPatterns from(String ... sources) {
        int length = sources.length;
        Plexus_MatchPattern[] result = new Plexus_MatchPattern[length];
        for (int i = 0; i < length; ++i) {
            result[i] = Plexus_MatchPattern.fromString(sources[i]);
        }
        return new Plexus_MatchPatterns(result);
    }

    public static Plexus_MatchPatterns from(Iterable<String> strings) {
        return new Plexus_MatchPatterns(Plexus_MatchPatterns.getMatchPatterns(strings));
    }

    private static Plexus_MatchPattern[] getMatchPatterns(Iterable<String> items) {
        ArrayList<Plexus_MatchPattern> result = new ArrayList<Plexus_MatchPattern>();
        for (String string : items) {
            result.add(Plexus_MatchPattern.fromString(string));
        }
        return result.toArray(new Plexus_MatchPattern[result.size()]);
    }
}

