/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2;

import io.r2dbc.h2.H2DatabaseExceptionFactory;
import io.r2dbc.h2.codecs.Codecs;
import io.r2dbc.h2.util.Assert;
import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.Nullability;
import java.util.Objects;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.value.TypeInfo;

public final class H2ColumnMetadata
implements ColumnMetadata {
    private final Codecs codecs;
    private final String name;
    private final Integer nativeType;
    private final Nullability nullability;
    private final Long precision;
    private final Integer scale;

    H2ColumnMetadata(Codecs codecs, String name, Integer nativeType, Nullability nullability, Long precision, Integer scale) {
        this.codecs = Assert.requireNonNull(codecs, "codecs must not be null");
        this.name = Assert.requireNonNull(name, "name must not be null");
        this.nativeType = Assert.requireNonNull(nativeType, "nativeType must not be null");
        this.nullability = Assert.requireNonNull(nullability, "nullability must not be null");
        this.precision = Assert.requireNonNull(precision, "precision must not be null");
        this.scale = Assert.requireNonNull(scale, "scale must not be null");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof H2ColumnMetadata)) {
            return false;
        }
        H2ColumnMetadata that = (H2ColumnMetadata)o;
        return Objects.equals(this.codecs, that.codecs) && this.name.equals(that.name) && this.nativeType.equals(that.nativeType) && this.nullability == that.nullability && this.precision.equals(that.precision) && this.scale.equals(that.scale);
    }

    public Class<?> getJavaType() {
        return this.codecs.preferredType(this.nativeType);
    }

    public String getName() {
        return this.name;
    }

    public Object getNativeTypeMetadata() {
        return this.nativeType;
    }

    public Nullability getNullability() {
        return this.nullability;
    }

    public Integer getPrecision() {
        return this.precision.intValue();
    }

    public Integer getScale() {
        return this.scale;
    }

    public int hashCode() {
        return Objects.hash(this.codecs, this.name, this.nativeType, this.nullability, this.precision, this.scale);
    }

    public String toString() {
        return "H2ColumnMetadata{codecs=" + this.codecs + ", name='" + this.name + '\'' + ", nativeType=" + this.nativeType + ", nullability=" + this.nullability + ", precision=" + this.precision + ", scale=" + this.scale + '}';
    }

    static H2ColumnMetadata toColumnMetadata(Codecs codecs, ResultInterface result, int index) {
        Assert.requireNonNull(codecs, "codecs must not be null");
        Assert.requireNonNull(result, "result must not be null");
        try {
            TypeInfo typeInfo = result.getColumnType(index);
            String alias = result.getAlias(index);
            return new H2ColumnMetadata(codecs, alias, typeInfo.getValueType(), H2ColumnMetadata.toNullability(result.getNullable(index)), typeInfo.getPrecision(), typeInfo.getScale());
        }
        catch (DbException e) {
            throw H2DatabaseExceptionFactory.convert(e);
        }
    }

    private static Nullability toNullability(int n) {
        switch (n) {
            case 0: {
                return Nullability.NON_NULL;
            }
            case 1: {
                return Nullability.NULLABLE;
            }
        }
        return Nullability.UNKNOWN;
    }
}

