/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Map;
import reactor.netty.Metrics;
import reactor.netty.channel.MeterKey;
import reactor.netty.http.MicrometerHttpMetricsRecorder;
import reactor.netty.http.client.HttpClientMetricsRecorder;
import reactor.netty.internal.util.MapUtils;

final class MicrometerHttpClientMetricsRecorder
extends MicrometerHttpMetricsRecorder
implements HttpClientMetricsRecorder {
    static final MicrometerHttpClientMetricsRecorder INSTANCE = new MicrometerHttpClientMetricsRecorder();

    private MicrometerHttpClientMetricsRecorder() {
        super("reactor.netty.http.client", "http");
    }

    @Override
    public void recordDataReceivedTime(SocketAddress remoteAddress, String uri, String method, String status, Duration time) {
        String address = Metrics.formatSocketAddress((SocketAddress)remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, method, status);
        Timer dataReceivedTime = (Timer)MapUtils.computeIfAbsent((Map)this.dataReceivedTimeCache, (Object)meterKey, key -> (Timer)MicrometerHttpClientMetricsRecorder.filter((Meter)Timer.builder((String)(this.name() + ".data.received.time")).description("Time spent in consuming incoming data").tags(new String[]{"remote.address", address, "uri", uri, "method", method, "status", status}).register(Metrics.REGISTRY)));
        if (dataReceivedTime != null) {
            dataReceivedTime.record(time);
        }
    }

    @Override
    public void recordDataSentTime(SocketAddress remoteAddress, String uri, String method, Duration time) {
        String address = Metrics.formatSocketAddress((SocketAddress)remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, method, null);
        Timer dataSentTime = (Timer)MapUtils.computeIfAbsent((Map)this.dataSentTimeCache, (Object)meterKey, key -> (Timer)MicrometerHttpClientMetricsRecorder.filter((Meter)Timer.builder((String)(this.name() + ".data.sent.time")).description("Time spent in sending outgoing data").tags(new String[]{"remote.address", address, "uri", uri, "method", method}).register(Metrics.REGISTRY)));
        if (dataSentTime != null) {
            dataSentTime.record(time);
        }
    }

    @Override
    public void recordResponseTime(SocketAddress remoteAddress, String uri, String method, String status, Duration time) {
        String address = Metrics.formatSocketAddress((SocketAddress)remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, method, status);
        Timer responseTime = (Timer)MapUtils.computeIfAbsent((Map)this.responseTimeCache, (Object)meterKey, key -> (Timer)MicrometerHttpClientMetricsRecorder.filter((Meter)Timer.builder((String)(this.name() + ".response.time")).description("Total time for the request/response").tags(new String[]{"remote.address", address, "uri", uri, "method", method, "status", status}).register(Metrics.REGISTRY)));
        if (responseTime != null) {
            responseTime.record(time);
        }
    }
}

