/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.arquillian.managed.exceptions;

import io.openliberty.arquillian.managed.exceptions.DeploymentExceptionLocator;
import io.openliberty.arquillian.managed.exceptions.NestedExceptionBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class SupportFeatureTextExceptionLocator
implements DeploymentExceptionLocator {
    private static final Logger log = Logger.getLogger(SupportFeatureTextExceptionLocator.class.getName());
    private final MBeanServerConnection mbsc;
    private final ObjectName on;
    private static final Pattern CLASS_PATTERN = Pattern.compile("exClass (.*)");
    private static final Pattern SUPERCLASS_PATTERN = Pattern.compile("exSuperclass (.*)");

    public SupportFeatureTextExceptionLocator(MBeanServerConnection mbsc) {
        this.mbsc = mbsc;
        StringBuilder sb = new StringBuilder("LibertyArquillian:");
        sb.append("type=").append("DeploymentExceptionMBean");
        try {
            this.on = new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid ObjectName: " + sb.toString() + " " + e, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Throwable getException(String appName, String logLine, long deploymentTime) {
        try {
            Object[] response = (Object[])this.mbsc.invoke(this.on, "getDeploymentException", new String[]{appName, "text"}, new String[]{String.class.getName(), String.class.getName()});
            int status = (Integer)response[0];
            if (status == 400) {
                log.warning("After " + appName + " failed to start, the server did not report an exception for that app");
                return null;
            }
            if (status != 200) {
                log.info("Unable to receive text format exception from server, is usr:arquillian-support-jakarta-2.1 installed?");
                return null;
            }
            log.finer("Reading exception returned from server");
            try (BufferedReader reader = new BufferedReader(new StringReader((String)response[1]));){
                Throwable throwable = this.readResponse(reader);
                return throwable;
            }
        }
        catch (IOException ex) {
            log.warning("IO Exception trying to get text exception: " + ex);
            return null;
        }
        catch (Exception ex) {
            log.warning("Unexpected exception thrown while trying to get text exception: " + ex);
        }
        return null;
    }

    private Throwable readResponse(BufferedReader reader) throws IOException {
        String line;
        ResponseReader responseReader = new ResponseReader();
        while ((line = reader.readLine()) != null) {
            Matcher classMatcher = CLASS_PATTERN.matcher(line);
            if (classMatcher.matches()) {
                responseReader.readClass(classMatcher.group(1));
                continue;
            }
            Matcher superclassMatcher = SUPERCLASS_PATTERN.matcher(line);
            if (superclassMatcher.matches()) {
                responseReader.readSuperclass(superclassMatcher.group(1));
                continue;
            }
            responseReader.readMessage(line);
        }
        responseReader.finishMsg();
        List msgs = responseReader.finish();
        return NestedExceptionBuilder.buildNestedException(msgs);
    }

    private static class ResponseReader {
        List<NestedExceptionBuilder.ExMsg> msgs = new ArrayList<NestedExceptionBuilder.ExMsg>();
        NestedExceptionBuilder.ExMsg currentMsg = null;
        StringBuilder messageBuilder = null;

        private ResponseReader() {
        }

        private void readClass(String className) {
            log.finer("Read class " + className);
            this.finishMsg();
            this.currentMsg.exName = className;
        }

        private void readSuperclass(String className) {
            log.finer("Read superclass" + className);
            this.currentMsg.superclasses.add(className);
        }

        private void readMessage(String message) {
            log.finer("Read message " + message);
            if (this.messageBuilder == null) {
                this.messageBuilder = new StringBuilder();
            } else {
                this.messageBuilder.append("\n");
            }
            this.messageBuilder.append(message);
        }

        private void finishMsg() {
            if (this.currentMsg != null) {
                this.msgs.add(this.currentMsg);
                if (this.messageBuilder != null) {
                    this.currentMsg.logMsg = this.messageBuilder.toString();
                }
            }
            this.currentMsg = new NestedExceptionBuilder.ExMsg();
            this.messageBuilder = null;
        }

        private List<NestedExceptionBuilder.ExMsg> finish() {
            return this.msgs;
        }
    }
}

