/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.arquillian.managed;

import java.io.File;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;

public class WLPManagedContainerConfiguration
implements ContainerConfiguration {
    private String wlpHome;
    private String usrDir;
    private String serverName = "defaultServer";
    private int httpPort = 0;
    private int serverStartTimeout = 30;
    private int serverStopTimeout = 30;
    private int appDeployTimeout = 20;
    private int appUndeployTimeout = 2;
    private String sharedLib = null;
    private String apiTypeVisibility = null;
    private String deployType = "dropins";
    private String javaVmArguments = "";
    private boolean addLocalConnector;
    private String securityConfiguration;
    private boolean failSafeUndeployment = false;
    private boolean allowConnectingToRunningServer = Boolean.parseBoolean(System.getProperty("io.openliberty.arquillian.managed.allowConnectingToRunningServer", "false"));
    private boolean outputToConsole = true;
    private String verifyApps = null;
    private int verifyAppDeployTimeout = this.appDeployTimeout;
    private int fileDeleteRetries = 30;
    private int standardFileDeleteRetryInterval = 50;
    private String testProtocol = "servlet";

    public void validate() throws ConfigurationException {
        File securityConfigFile;
        File usr;
        if (this.wlpHome != null) {
            File wlpHomeDir = new File(this.wlpHome);
            File bsAgentJar = new File(this.wlpHome + "/lib/bootstrap-agent.jar");
            File wsLaunchJar = new File(this.wlpHome + "/lib/ws-launch.jar");
            if (!(wlpHomeDir.isDirectory() && bsAgentJar.isFile() && wsLaunchJar.isFile())) {
                throw new ConfigurationException("wlpHome provided is not valid: " + this.wlpHome);
            }
        } else {
            throw new ConfigurationException("wlpHome is required for initialization");
        }
        if (!(this.usrDir == null || (usr = new File(this.usrDir)).exists() && usr.isDirectory())) {
            throw new ConfigurationException("usrDir provided is not valid: " + usr);
        }
        if (this.securityConfiguration != null && this.securityConfiguration.trim().length() > 0 && !(securityConfigFile = new File(this.securityConfiguration)).exists()) {
            throw new ConfigurationException("securityConfiguration provided is not valid: " + this.securityConfiguration);
        }
        if (!this.serverName.matches("^[A-Za-z0-9\\+_][A-Za-z0-9\\+_\\.-]*$")) {
            throw new ConfigurationException("serverName provided is not valid: '" + this.serverName + "'");
        }
        if (this.httpPort > 65535 || this.httpPort < 0) {
            throw new ConfigurationException("httpPort provided is not valid: " + this.httpPort);
        }
        if (!this.deployType.equalsIgnoreCase("xml") && !this.deployType.equalsIgnoreCase("dropins")) {
            throw new ConfigurationException("deployType provided is not valid: " + this.deployType + ".  deployType should be xml or dropins.");
        }
        if (this.sharedLib != null && !this.sharedLib.isEmpty() && !this.deployType.equalsIgnoreCase("xml")) {
            throw new ConfigurationException("deployType must be set to xml when sharedLib is not empty");
        }
        if (this.apiTypeVisibility != null && !this.apiTypeVisibility.isEmpty() && !this.deployType.equalsIgnoreCase("xml")) {
            throw new ConfigurationException("deployType must be set to xml when apiTypeVisibility is not empty");
        }
        if (this.fileDeleteRetries < 0) {
            throw new ConfigurationException("fileDeleteRetries cannot be negative");
        }
        if (this.standardFileDeleteRetryInterval < 0) {
            throw new ConfigurationException("standardFileDeleteRetryInterval cannot be negative");
        }
        if (!"rest".equalsIgnoreCase(this.testProtocol) && !"servlet".equalsIgnoreCase(this.testProtocol)) {
            throw new ConfigurationException("testProtocol must be set to rest or servlet");
        }
    }

    public String getWlpHome() {
        return new File(this.wlpHome).getAbsolutePath();
    }

    public void setWlpHome(String wlpHome) {
        this.wlpHome = wlpHome;
    }

    public String getUsrDir() {
        return this.usrDir;
    }

    public void setUsrDir(String usrDir) {
        this.usrDir = usrDir;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public void setSharedLib(String sharedLib) {
        this.sharedLib = sharedLib;
    }

    public String getSharedLib() {
        return this.sharedLib;
    }

    public void setApiTypeVisibility(String apiTypeVisibility) {
        this.apiTypeVisibility = apiTypeVisibility;
    }

    public String getApiTypeVisibility() {
        return this.apiTypeVisibility;
    }

    public void setDeployType(String deployType) {
        this.deployType = deployType;
    }

    public String getDeployType() {
        return this.deployType;
    }

    public boolean isAllowConnectingToRunningServer() {
        return this.allowConnectingToRunningServer;
    }

    public void setAllowConnectingToRunningServer(boolean allowConnectingToRunningServer) {
        this.allowConnectingToRunningServer = allowConnectingToRunningServer;
    }

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    public void setOutputToConsole(boolean outputToConsole) {
        this.outputToConsole = outputToConsole;
    }

    public int getServerStartTimeout() {
        return this.serverStartTimeout;
    }

    public void setServerStartTimeout(int serverStartTimeout) {
        this.serverStartTimeout = serverStartTimeout;
    }

    public int getServerStopTimeout() {
        return this.serverStopTimeout;
    }

    public void setServerStopTimeout(int serverStopTimeout) {
        this.serverStopTimeout = serverStopTimeout;
    }

    public int getAppDeployTimeout() {
        return this.appDeployTimeout;
    }

    public void setAppDeployTimeout(int appDeployTimeout) {
        this.appDeployTimeout = appDeployTimeout;
    }

    public int getAppUndeployTimeout() {
        return this.appUndeployTimeout;
    }

    public void setAppUndeployTimeout(int appUndeployTimeout) {
        this.appUndeployTimeout = appUndeployTimeout;
    }

    public boolean isDeployTypeXML() {
        return this.deployType.equalsIgnoreCase("xml");
    }

    public boolean isDeployTypeDropins() {
        return this.deployType.equalsIgnoreCase("dropins");
    }

    public String getJavaVmArguments() {
        return this.javaVmArguments;
    }

    public void setJavaVmArguments(String javaVmArguments) {
        this.javaVmArguments = javaVmArguments;
    }

    public boolean isAddLocalConnector() {
        return this.addLocalConnector;
    }

    public void setAddLocalConnector(boolean addLocalConnector) {
        this.addLocalConnector = addLocalConnector;
    }

    public String getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public void setSecurityConfiguration(String securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public boolean isFailSafeUndeployment() {
        return this.failSafeUndeployment;
    }

    public void setFailSafeUndeployment(boolean failSafeUndeployment) {
        this.failSafeUndeployment = failSafeUndeployment;
    }

    public String getVerifyApps() {
        return this.verifyApps;
    }

    public void setVerifyApps(String verifyApps) {
        this.verifyApps = verifyApps;
    }

    public int getVerifyAppDeployTimeout() {
        return this.verifyAppDeployTimeout;
    }

    public void setVerifyAppDeployTimeout(int verifyAppDeployTimeout) {
        this.verifyAppDeployTimeout = verifyAppDeployTimeout;
    }

    public int getFileDeleteRetries() {
        return this.fileDeleteRetries;
    }

    public void setFileDeleteRetries(int fileDeleteRetries) {
        this.fileDeleteRetries = fileDeleteRetries;
    }

    public int getStandardFileDeleteRetryInterval() {
        return this.standardFileDeleteRetryInterval;
    }

    public void setStandardFileDeleteRetryInterval(int standardFileDeleteRetryInterval) {
        this.standardFileDeleteRetryInterval = standardFileDeleteRetryInterval;
    }

    public String getTestProtocol() {
        return this.testProtocol;
    }

    public void setTestProtocol(String protocol) {
        this.testProtocol = protocol;
    }

    public boolean isServletTestProtocol() {
        return "servlet".equalsIgnoreCase(this.testProtocol);
    }
}

