/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.arquillian.managed;

public class Interruptor {
    private final Thread interruptTarget;
    private final long timeToWait;
    private Thread taskThread;
    private boolean running = false;

    public Interruptor(Thread interruptTarget, long timeToWait) {
        this.interruptTarget = interruptTarget;
        this.timeToWait = timeToWait;
    }

    public synchronized void start() {
        if (this.running) {
            throw new IllegalArgumentException("Interruptor has already been started");
        }
        this.taskThread = new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(Interruptor.this.timeToWait);
                    Interruptor.this.doInterrupt();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.running = true;
        this.taskThread.start();
    }

    public synchronized void stop() {
        this.running = false;
        this.taskThread.interrupt();
    }

    private synchronized void doInterrupt() {
        if (this.running) {
            this.interruptTarget.interrupt();
            this.running = false;
        }
    }
}

