/*
 * Copyright 2011-2021 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.lettuce.core;

/**
 * Exception thrown when the command waiting timeout is exceeded.
 *
 * @author Mark Paluch
 */
@SuppressWarnings("serial")
public class RedisCommandTimeoutException extends RedisException {

    /**
     * Create a {@code RedisCommandTimeoutException} with a default message.
     */
    public RedisCommandTimeoutException() {
        super("Command timed out");
    }

    /**
     * Create a {@code RedisCommandTimeoutException} with the specified detail message.
     *
     * @param msg the detail message.
     */
    public RedisCommandTimeoutException(String msg) {
        super(msg);
    }

    /**
     * Create a {@code RedisException} with the specified nested exception.
     *
     * @param cause the nested exception.
     */
    public RedisCommandTimeoutException(Throwable cause) {
        super(cause);
    }

}
