/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.EquivalentAddressGroup;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.AddressFilter;
import io.grpc.xds.ClusterImplLoadBalancerProvider;
import io.grpc.xds.ClusterResolverLoadBalancerProvider;
import io.grpc.xds.Endpoints;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.InternalXdsAttributes;
import io.grpc.xds.Locality;
import io.grpc.xds.PriorityLoadBalancerProvider;
import io.grpc.xds.WeightedTargetLoadBalancerProvider;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsSubchannelPickers;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class ClusterResolverLoadBalancer
extends LoadBalancer {
    private static final Locality LOGICAL_DNS_CLUSTER_LOCALITY = Locality.create("", "", "");
    private final XdsLogger logger;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private final LoadBalancerRegistry lbRegistry;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final GracefulSwitchLoadBalancer delegate;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;
    private ClusterResolverLoadBalancerProvider.ClusterResolverConfig config;

    ClusterResolverLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, LoadBalancerRegistry.getDefaultRegistry(), (BackoffPolicy.Provider)new ExponentialBackoffPolicy.Provider());
    }

    @VisibleForTesting
    ClusterResolverLoadBalancer(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry, BackoffPolicy.Provider backoffPolicyProvider) {
        this.lbRegistry = (LoadBalancerRegistry)Preconditions.checkNotNull((Object)lbRegistry, (Object)"lbRegistry");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)helper.getSynchronizationContext(), (Object)"syncContext");
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)helper.getScheduledExecutorService(), (Object)"timeService");
        this.delegate = new GracefulSwitchLoadBalancer(helper);
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"cluster-resolver-lb", (String)helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        ClusterResolverLoadBalancerProvider.ClusterResolverConfig config;
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        if (this.xdsClientPool == null) {
            this.xdsClientPool = (ObjectPool)resolvedAddresses.getAttributes().get(InternalXdsAttributes.XDS_CLIENT_POOL);
            this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        }
        if (!Objects.equals(this.config, config = (ClusterResolverLoadBalancerProvider.ClusterResolverConfig)resolvedAddresses.getLoadBalancingPolicyConfig())) {
            this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Config: {0}", config);
            this.delegate.switchTo((LoadBalancer.Factory)new ClusterResolverLbStateFactory());
            this.config = config;
            this.delegate.handleResolvedAddresses(resolvedAddresses);
        }
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        this.delegate.handleNameResolutionError(error);
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        this.delegate.shutdown();
        if (this.xdsClientPool != null) {
            this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
    }

    private static PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig generateDnsBasedPriorityChildConfig(String cluster, @Nullable String lrsServerName, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext, LoadBalancerRegistry lbRegistry, List<Endpoints.DropOverload> dropOverloads) {
        ServiceConfigUtil.PolicySelection endpointLbPolicy = new ServiceConfigUtil.PolicySelection(lbRegistry.getProvider("pick_first"), null);
        ClusterImplLoadBalancerProvider.ClusterImplConfig clusterImplConfig = new ClusterImplLoadBalancerProvider.ClusterImplConfig(cluster, null, lrsServerName, maxConcurrentRequests, dropOverloads, endpointLbPolicy, tlsContext);
        LoadBalancerProvider clusterImplLbProvider = lbRegistry.getProvider("cluster_impl_experimental");
        ServiceConfigUtil.PolicySelection clusterImplPolicy = new ServiceConfigUtil.PolicySelection(clusterImplLbProvider, (Object)clusterImplConfig);
        return new PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig(clusterImplPolicy, false);
    }

    private static Map<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> generateEdsBasedPriorityChildConfigs(String cluster, @Nullable String edsServiceName, @Nullable String lrsServerName, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext, ServiceConfigUtil.PolicySelection endpointLbPolicy, LoadBalancerRegistry lbRegistry, Map<String, Map<Locality, Integer>> prioritizedLocalityWeights, List<Endpoints.DropOverload> dropOverloads) {
        HashMap<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> configs = new HashMap<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig>();
        for (String priority : prioritizedLocalityWeights.keySet()) {
            ServiceConfigUtil.PolicySelection leafPolicy = endpointLbPolicy;
            if (endpointLbPolicy.getProvider().getPolicyName().equals("round_robin")) {
                Map<Locality, Integer> localityWeights = prioritizedLocalityWeights.get(priority);
                HashMap<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection> targets = new HashMap<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection>();
                for (Locality locality : localityWeights.keySet()) {
                    int weight = localityWeights.get(locality);
                    WeightedTargetLoadBalancerProvider.WeightedPolicySelection target = new WeightedTargetLoadBalancerProvider.WeightedPolicySelection(weight, endpointLbPolicy);
                    targets.put(ClusterResolverLoadBalancer.localityName(locality), target);
                }
                LoadBalancerProvider weightedTargetLbProvider = lbRegistry.getProvider("weighted_target_experimental");
                WeightedTargetLoadBalancerProvider.WeightedTargetConfig weightedTargetConfig = new WeightedTargetLoadBalancerProvider.WeightedTargetConfig(Collections.unmodifiableMap(targets));
                leafPolicy = new ServiceConfigUtil.PolicySelection(weightedTargetLbProvider, (Object)weightedTargetConfig);
            }
            ClusterImplLoadBalancerProvider.ClusterImplConfig clusterImplConfig = new ClusterImplLoadBalancerProvider.ClusterImplConfig(cluster, edsServiceName, lrsServerName, maxConcurrentRequests, dropOverloads, leafPolicy, tlsContext);
            LoadBalancerProvider clusterImplLbProvider = lbRegistry.getProvider("cluster_impl_experimental");
            ServiceConfigUtil.PolicySelection clusterImplPolicy = new ServiceConfigUtil.PolicySelection(clusterImplLbProvider, (Object)clusterImplConfig);
            PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig priorityChildConfig = new PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig(clusterImplPolicy, true);
            configs.put(priority, priorityChildConfig);
        }
        return configs;
    }

    private static String priorityName(String cluster, int priority) {
        return cluster + "[priority" + priority + "]";
    }

    private static String localityName(Locality locality) {
        return locality.toString();
    }

    private static class ClusterResolutionResult {
        private final List<EquivalentAddressGroup> addresses;
        private final Map<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> priorityChildConfigs;
        private final List<String> priorities;

        ClusterResolutionResult(List<EquivalentAddressGroup> addresses, String priority, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig config) {
            this(addresses, Collections.singletonMap(priority, config), Collections.singletonList(priority));
        }

        ClusterResolutionResult(List<EquivalentAddressGroup> addresses, Map<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> configs, List<String> priorities) {
            this.addresses = addresses;
            this.priorityChildConfigs = configs;
            this.priorities = priorities;
        }
    }

    private final class ClusterResolverLbState
    extends LoadBalancer {
        private final LoadBalancer.Helper helper;
        private final List<String> clusters = new ArrayList<String>();
        private final Map<String, ClusterState> clusterStates = new HashMap<String, ClusterState>();
        private ServiceConfigUtil.PolicySelection endpointLbPolicy;
        private LoadBalancer.ResolvedAddresses resolvedAddresses;
        private LoadBalancer childLb;

        ClusterResolverLbState(LoadBalancer.Helper helper) {
            this.helper = new RefreshableHelper((LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper"));
            ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "New ClusterResolverLbState");
        }

        public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
            this.resolvedAddresses = resolvedAddresses;
            ClusterResolverLoadBalancerProvider.ClusterResolverConfig config = (ClusterResolverLoadBalancerProvider.ClusterResolverConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
            this.endpointLbPolicy = config.lbPolicy;
            for (ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism instance : config.discoveryMechanisms) {
                this.clusters.add(instance.cluster);
                ClusterState state = instance.type == ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism.Type.EDS ? new EdsClusterState(instance.cluster, instance.edsServiceName, instance.lrsServerName, instance.maxConcurrentRequests, instance.tlsContext) : new LogicalDnsClusterState(instance.cluster, instance.dnsHostName, instance.lrsServerName, instance.maxConcurrentRequests, instance.tlsContext);
                this.clusterStates.put(instance.cluster, state);
                state.start();
            }
        }

        public void handleNameResolutionError(Status error) {
            if (this.childLb != null) {
                this.childLb.handleNameResolutionError(error);
            } else {
                this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
            }
        }

        public void shutdown() {
            for (ClusterState state : this.clusterStates.values()) {
                state.shutdown();
            }
            if (this.childLb != null) {
                this.childLb.shutdown();
            }
        }

        private void handleEndpointResourceUpdate() {
            ArrayList addresses = new ArrayList();
            HashMap priorityChildConfigs = new HashMap();
            ArrayList priorities = new ArrayList();
            Status endpointNotFound = Status.OK;
            for (String cluster : this.clusters) {
                ClusterState state = this.clusterStates.get(cluster);
                if (!state.resolved && state.status.isOk()) {
                    return;
                }
                if (state.result != null) {
                    addresses.addAll(state.result.addresses);
                    priorityChildConfigs.putAll(state.result.priorityChildConfigs);
                    priorities.addAll(state.result.priorities);
                    continue;
                }
                endpointNotFound = state.status;
            }
            if (addresses.isEmpty()) {
                endpointNotFound = endpointNotFound.isOk() ? Status.UNAVAILABLE.withDescription("No usable endpoint from cluster(s): " + this.clusters) : Status.UNAVAILABLE.withCause(endpointNotFound.getCause()).withDescription(endpointNotFound.getDescription());
                this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(endpointNotFound));
                if (this.childLb != null) {
                    this.childLb.shutdown();
                    this.childLb = null;
                }
                return;
            }
            PriorityLoadBalancerProvider.PriorityLbConfig childConfig = new PriorityLoadBalancerProvider.PriorityLbConfig(Collections.unmodifiableMap(priorityChildConfigs), Collections.unmodifiableList(priorities));
            if (this.childLb == null) {
                this.childLb = ClusterResolverLoadBalancer.this.lbRegistry.getProvider("priority_experimental").newLoadBalancer(this.helper);
            }
            this.childLb.handleResolvedAddresses(this.resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig((Object)childConfig).setAddresses(Collections.unmodifiableList(addresses)).build());
        }

        private void handleEndpointResolutionError() {
            boolean allInError = true;
            Status error = null;
            for (String cluster : this.clusters) {
                ClusterState state = this.clusterStates.get(cluster);
                if (state.status.isOk()) {
                    allInError = false;
                    continue;
                }
                error = state.status;
            }
            if (allInError) {
                if (this.childLb != null) {
                    this.childLb.handleNameResolutionError(error);
                } else {
                    this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
                }
            }
        }

        private final class LogicalDnsClusterState
        extends ClusterState {
            private final String dnsHostName;
            private final NameResolver.Factory nameResolverFactory;
            private final NameResolver.Args nameResolverArgs;
            private NameResolver resolver;
            @Nullable
            private BackoffPolicy backoffPolicy;
            @Nullable
            private SynchronizationContext.ScheduledHandle scheduledRefresh;

            private LogicalDnsClusterState(String name, @Nullable String dnsHostName, @Nullable String lrsServerName, @Nullable Long maxConcurrentRequests, EnvoyServerProtoData.UpstreamTlsContext tlsContext) {
                super(name, lrsServerName, maxConcurrentRequests, tlsContext);
                this.dnsHostName = (String)Preconditions.checkNotNull((Object)dnsHostName, (Object)"dnsHostName");
                this.nameResolverFactory = (NameResolver.Factory)Preconditions.checkNotNull((Object)ClusterResolverLbState.this.helper.getNameResolverRegistry().asFactory(), (Object)"nameResolverFactory");
                this.nameResolverArgs = (NameResolver.Args)Preconditions.checkNotNull((Object)ClusterResolverLbState.this.helper.getNameResolverArgs(), (Object)"nameResolverArgs");
            }

            @Override
            void start() {
                URI uri;
                try {
                    uri = new URI("dns", "", "/" + this.dnsHostName, null);
                }
                catch (URISyntaxException e) {
                    this.status = Status.INTERNAL.withDescription("Bug, invalid URI creation: " + this.dnsHostName).withCause((Throwable)e);
                    ClusterResolverLbState.this.handleEndpointResolutionError();
                    return;
                }
                this.resolver = this.nameResolverFactory.newNameResolver(uri, this.nameResolverArgs);
                if (this.resolver == null) {
                    this.status = Status.INTERNAL.withDescription("Cannot find DNS resolver");
                    ClusterResolverLbState.this.handleEndpointResolutionError();
                    return;
                }
                this.resolver.start((NameResolver.Listener2)new NameResolverListener());
            }

            void refresh() {
                if (this.resolver == null) {
                    return;
                }
                this.cancelBackoff();
                this.resolver.refresh();
            }

            @Override
            void shutdown() {
                super.shutdown();
                if (this.resolver != null) {
                    this.resolver.shutdown();
                }
                this.cancelBackoff();
            }

            private void cancelBackoff() {
                if (this.scheduledRefresh != null) {
                    this.scheduledRefresh.cancel();
                    this.scheduledRefresh = null;
                    this.backoffPolicy = null;
                }
            }

            private class NameResolverListener
            extends NameResolver.Listener2 {
                private NameResolverListener() {
                }

                public void onResult(final NameResolver.ResolutionResult resolutionResult) {
                    class NameResolved
                    implements Runnable {
                        NameResolved() {
                        }

                        @Override
                        public void run() {
                            if (LogicalDnsClusterState.this.shutdown) {
                                return;
                            }
                            LogicalDnsClusterState.this.backoffPolicy = null;
                            String priorityName = ClusterResolverLoadBalancer.priorityName(LogicalDnsClusterState.this.name, 0);
                            ArrayList<EquivalentAddressGroup> addresses = new ArrayList<EquivalentAddressGroup>();
                            for (EquivalentAddressGroup eag : resolutionResult.getAddresses()) {
                                Attributes attr = eag.getAttributes().toBuilder().set(InternalXdsAttributes.ATTR_LOCALITY, (Object)LOGICAL_DNS_CLUSTER_LOCALITY).build();
                                eag = new EquivalentAddressGroup(eag.getAddresses(), attr);
                                eag = AddressFilter.setPathFilter(eag, Arrays.asList(priorityName, LOGICAL_DNS_CLUSTER_LOCALITY.toString()));
                                addresses.add(eag);
                            }
                            PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig priorityChildConfig = ClusterResolverLoadBalancer.generateDnsBasedPriorityChildConfig(LogicalDnsClusterState.this.name, LogicalDnsClusterState.this.lrsServerName, LogicalDnsClusterState.this.maxConcurrentRequests, LogicalDnsClusterState.this.tlsContext, ClusterResolverLoadBalancer.this.lbRegistry, Collections.emptyList());
                            LogicalDnsClusterState.this.status = Status.OK;
                            LogicalDnsClusterState.this.resolved = true;
                            LogicalDnsClusterState.this.result = new ClusterResolutionResult(addresses, priorityName, priorityChildConfig);
                            ClusterResolverLbState.this.handleEndpointResourceUpdate();
                        }
                    }
                    ClusterResolverLoadBalancer.this.syncContext.execute((Runnable)new NameResolved());
                }

                public void onError(final Status error) {
                    ClusterResolverLoadBalancer.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (LogicalDnsClusterState.this.shutdown) {
                                return;
                            }
                            LogicalDnsClusterState.this.status = error;
                            if (!LogicalDnsClusterState.this.resolved) {
                                LogicalDnsClusterState.this.resolved = true;
                                ClusterResolverLbState.this.handleEndpointResourceUpdate();
                            } else {
                                ClusterResolverLbState.this.handleEndpointResolutionError();
                            }
                            if (LogicalDnsClusterState.this.scheduledRefresh != null && LogicalDnsClusterState.this.scheduledRefresh.isPending()) {
                                return;
                            }
                            if (LogicalDnsClusterState.this.backoffPolicy == null) {
                                LogicalDnsClusterState.this.backoffPolicy = ClusterResolverLoadBalancer.this.backoffPolicyProvider.get();
                            }
                            long delayNanos = LogicalDnsClusterState.this.backoffPolicy.nextBackoffNanos();
                            ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Scheduling DNS resolution backoff for {0} ns", delayNanos);
                            LogicalDnsClusterState.this.scheduledRefresh = ClusterResolverLoadBalancer.this.syncContext.schedule((Runnable)new DelayedNameResolverRefresh(), delayNanos, TimeUnit.NANOSECONDS, ClusterResolverLoadBalancer.this.timeService);
                        }
                    });
                }
            }

            private class DelayedNameResolverRefresh
            implements Runnable {
                private DelayedNameResolverRefresh() {
                }

                @Override
                public void run() {
                    LogicalDnsClusterState.this.scheduledRefresh = null;
                    if (!LogicalDnsClusterState.this.shutdown) {
                        LogicalDnsClusterState.this.resolver.refresh();
                    }
                }
            }
        }

        private final class EdsClusterState
        extends ClusterState
        implements XdsClient.EdsResourceWatcher {
            @Nullable
            private final String edsServiceName;

            private EdsClusterState(@Nullable String name, @Nullable String edsServiceName, @Nullable String lrsServerName, @Nullable Long maxConcurrentRequests, EnvoyServerProtoData.UpstreamTlsContext tlsContext) {
                super(name, lrsServerName, maxConcurrentRequests, tlsContext);
                this.edsServiceName = edsServiceName;
            }

            @Override
            void start() {
                String resourceName = this.edsServiceName != null ? this.edsServiceName : this.name;
                ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Start watching EDS resource {0}", resourceName);
                ClusterResolverLoadBalancer.this.xdsClient.watchEdsResource(resourceName, this);
            }

            @Override
            protected void shutdown() {
                super.shutdown();
                String resourceName = this.edsServiceName != null ? this.edsServiceName : this.name;
                ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Stop watching EDS resource {0}", resourceName);
                ClusterResolverLoadBalancer.this.xdsClient.cancelEdsResourceWatch(resourceName, this);
            }

            @Override
            public void onChanged(final XdsClient.EdsUpdate update) {
                class EndpointsUpdated
                implements Runnable {
                    EndpointsUpdated() {
                    }

                    @Override
                    public void run() {
                        if (EdsClusterState.this.shutdown) {
                            return;
                        }
                        ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received endpoint update {0}", update);
                        if (ClusterResolverLoadBalancer.this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
                            ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cluster {0}: {1} localities, {2} drop categories", update.clusterName, update.localityLbEndpointsMap.size(), update.dropPolicies.size());
                        }
                        Map<Locality, Endpoints.LocalityLbEndpoints> localityLbEndpoints = update.localityLbEndpointsMap;
                        List<Endpoints.DropOverload> dropOverloads = update.dropPolicies;
                        ArrayList<EquivalentAddressGroup> addresses = new ArrayList<EquivalentAddressGroup>();
                        HashMap prioritizedLocalityWeights = new HashMap();
                        for (Locality locality : localityLbEndpoints.keySet()) {
                            Endpoints.LocalityLbEndpoints localityLbInfo = localityLbEndpoints.get(locality);
                            int priority = localityLbInfo.priority();
                            String priorityName = ClusterResolverLoadBalancer.priorityName(EdsClusterState.this.name, priority);
                            boolean discard = true;
                            for (Endpoints.LbEndpoint endpoint : localityLbInfo.endpoints()) {
                                if (!endpoint.isHealthy()) continue;
                                discard = false;
                                long weight = localityLbInfo.localityWeight();
                                if (endpoint.loadBalancingWeight() != 0) {
                                    weight *= (long)endpoint.loadBalancingWeight();
                                }
                                Attributes attr = endpoint.eag().getAttributes().toBuilder().set(InternalXdsAttributes.ATTR_LOCALITY, (Object)locality).set(InternalXdsAttributes.ATTR_SERVER_WEIGHT, (Object)weight).build();
                                EquivalentAddressGroup eag = new EquivalentAddressGroup(endpoint.eag().getAddresses(), attr);
                                eag = AddressFilter.setPathFilter(eag, Arrays.asList(priorityName, ClusterResolverLoadBalancer.localityName(locality)));
                                addresses.add(eag);
                            }
                            if (discard) {
                                ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Discard locality {0} with 0 healthy endpoints", locality);
                                continue;
                            }
                            if (!prioritizedLocalityWeights.containsKey(priorityName)) {
                                prioritizedLocalityWeights.put(priorityName, new HashMap());
                            }
                            ((Map)prioritizedLocalityWeights.get(priorityName)).put(locality, localityLbInfo.localityWeight());
                        }
                        if (prioritizedLocalityWeights.isEmpty()) {
                            ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cluster {0} has no usable priority/locality/endpoint", update.clusterName);
                        }
                        ArrayList<String> priorities = new ArrayList<String>(prioritizedLocalityWeights.keySet());
                        Collections.sort(priorities);
                        Map priorityChildConfigs = ClusterResolverLoadBalancer.generateEdsBasedPriorityChildConfigs(EdsClusterState.this.name, EdsClusterState.this.edsServiceName, EdsClusterState.this.lrsServerName, EdsClusterState.this.maxConcurrentRequests, EdsClusterState.this.tlsContext, ClusterResolverLbState.this.endpointLbPolicy, ClusterResolverLoadBalancer.this.lbRegistry, prioritizedLocalityWeights, dropOverloads);
                        EdsClusterState.this.status = Status.OK;
                        EdsClusterState.this.resolved = true;
                        EdsClusterState.this.result = new ClusterResolutionResult(addresses, priorityChildConfigs, priorities);
                        ClusterResolverLbState.this.handleEndpointResourceUpdate();
                    }
                }
                ClusterResolverLoadBalancer.this.syncContext.execute((Runnable)new EndpointsUpdated());
            }

            @Override
            public void onResourceDoesNotExist(final String resourceName) {
                ClusterResolverLoadBalancer.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (EdsClusterState.this.shutdown) {
                            return;
                        }
                        ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Resource {0} unavailable", resourceName);
                        EdsClusterState.this.status = Status.OK;
                        EdsClusterState.this.resolved = true;
                        EdsClusterState.this.result = null;
                        ClusterResolverLbState.this.handleEndpointResourceUpdate();
                    }
                });
            }

            @Override
            public void onError(final Status error) {
                ClusterResolverLoadBalancer.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (EdsClusterState.this.shutdown) {
                            return;
                        }
                        EdsClusterState.this.status = error;
                        ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received EDS error: {0}", error);
                        ClusterResolverLbState.this.handleEndpointResolutionError();
                    }
                });
            }
        }

        private abstract class ClusterState {
            protected final String name;
            @Nullable
            protected final String lrsServerName;
            @Nullable
            protected final Long maxConcurrentRequests;
            @Nullable
            protected final EnvoyServerProtoData.UpstreamTlsContext tlsContext;
            protected Status status = Status.OK;
            protected boolean resolved;
            @Nullable
            protected ClusterResolutionResult result;
            protected boolean shutdown;

            private ClusterState(@Nullable String name, @Nullable String lrsServerName, @Nullable Long maxConcurrentRequests, EnvoyServerProtoData.UpstreamTlsContext tlsContext) {
                this.name = name;
                this.lrsServerName = lrsServerName;
                this.maxConcurrentRequests = maxConcurrentRequests;
                this.tlsContext = tlsContext;
            }

            abstract void start();

            void shutdown() {
                this.shutdown = true;
            }
        }

        private final class RefreshableHelper
        extends ForwardingLoadBalancerHelper {
            private final LoadBalancer.Helper delegate;

            private RefreshableHelper(LoadBalancer.Helper delegate) {
                this.delegate = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
                delegate.ignoreRefreshNameResolutionCheck();
            }

            public void refreshNameResolution() {
                for (ClusterState state : ClusterResolverLbState.this.clusterStates.values()) {
                    if (!(state instanceof LogicalDnsClusterState)) continue;
                    ((LogicalDnsClusterState)state).refresh();
                }
            }

            protected LoadBalancer.Helper delegate() {
                return this.delegate;
            }
        }
    }

    private final class ClusterResolverLbStateFactory
    extends LoadBalancer.Factory {
        private ClusterResolverLbStateFactory() {
        }

        public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
            return new ClusterResolverLbState(helper);
        }
    }
}

