/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words.internals;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import toolgood.words.internals.TrieNode;
import toolgood.words.internals.TrieNode3;

public class BaseMatch {
    protected TrieNode3[] _first;
    protected int[] _keywordLength;
    protected int[] _keywordIndex;
    protected String[] _matchKeywords;

    protected List<TrieNode> BuildFirstLayerTrieNode(List<String> keywords) {
        int i;
        int start;
        TrieNode root = new TrieNode();
        Hashtable allNodeLayers = new Hashtable();
        for (int i2 = 0; i2 < keywords.size(); ++i2) {
            String p = keywords.get(i2);
            TrieNode nd = root;
            start = 0;
            while (p.charAt(start) == '\u0000') {
                ++start;
            }
            for (int j = start; j < p.length(); ++j) {
                nd = nd.Add(Character.valueOf(p.charAt(j)));
                if (nd.Layer != 0) continue;
                nd.Layer = j + 1 - start;
                if (!allNodeLayers.containsKey(nd.Layer)) {
                    ArrayList<TrieNode> nodes = new ArrayList<TrieNode>();
                    nodes.add(nd);
                    allNodeLayers.put(nd.Layer, nodes);
                    continue;
                }
                ((List)allNodeLayers.get(nd.Layer)).add(nd);
            }
            nd.SetResults(i2);
        }
        Character z = Character.valueOf('\u0000');
        for (int i3 = 0; i3 < keywords.size(); ++i3) {
            String p = keywords.get(i3);
            if (!p.contains(z.toString())) continue;
            start = 0;
            while (p.charAt(start) == '\u0000') {
                ++start;
            }
            ArrayList<TrieNode> trieNodes = new ArrayList<TrieNode>();
            trieNodes.add(root);
            for (int j = start; j < p.length(); ++j) {
                ArrayList<TrieNode> newTrieNodes = new ArrayList<TrieNode>();
                Character c = Character.valueOf(p.charAt(j));
                if (c.charValue() == '\u0000') {
                    for (TrieNode nd : trieNodes) {
                        for (Character key : nd.m_values.keySet()) {
                            newTrieNodes.add(nd.m_values.get(key));
                        }
                    }
                } else {
                    for (TrieNode nd : trieNodes) {
                        TrieNode nd2 = nd.Add(c);
                        if (nd2.Layer == 0) {
                            nd2.Layer = j + 1 - start;
                            if (!allNodeLayers.containsKey(nd2.Layer)) {
                                ArrayList<TrieNode> nodes = new ArrayList<TrieNode>();
                                nodes.add(nd2);
                                allNodeLayers.put(nd2.Layer, nodes);
                            } else {
                                ((List)allNodeLayers.get(nd2.Layer)).add(nd2);
                            }
                        }
                        newTrieNodes.add(nd2);
                    }
                }
                trieNodes = newTrieNodes;
            }
            for (TrieNode nd : trieNodes) {
                nd.SetResults(i3);
            }
        }
        ArrayList<TrieNode> allNode = new ArrayList<TrieNode>();
        allNode.add(root);
        for (i = 0; i < allNodeLayers.size(); ++i) {
            List nodes = (List)allNodeLayers.get(i + 1);
            for (int j = 0; j < nodes.size(); ++j) {
                allNode.add((TrieNode)nodes.get(j));
            }
        }
        allNodeLayers.clear();
        allNodeLayers = null;
        for (i = 1; i < allNode.size(); ++i) {
            TrieNode nd = (TrieNode)allNode.get(i);
            nd.Index = i;
            TrieNode r = nd.Parent.Failure;
            char c = nd.Char;
            while (r != null && !r.m_values.containsKey(Character.valueOf(c))) {
                r = r.Failure;
            }
            if (r == null) {
                nd.Failure = root;
                continue;
            }
            nd.Failure = r.m_values.get(Character.valueOf(c));
            for (Integer result : nd.Failure.Results) {
                nd.SetResults(result);
            }
        }
        Character zore = Character.valueOf('\u0000');
        for (int i4 = 1; i4 < allNode.size(); ++i4) {
            TrieNode nd = (TrieNode)allNode.get(i4);
            if (nd.Layer == 1) continue;
            if (nd.m_values.containsKey(zore)) {
                nd.HasWildcard = true;
            }
            if (nd.Failure.HasWildcard) {
                nd.HasWildcard = true;
            }
            if (nd.Char == '\u0000') {
                nd.IsWildcard = true;
                continue;
            }
            if (!nd.Parent.IsWildcard) continue;
            nd.IsWildcard = true;
            nd.WildcardLayer = nd.Parent.WildcardLayer + 1;
            if (nd.Failure == root || nd.Failure.Layer > nd.WildcardLayer) continue;
            nd.Failure = root;
        }
        root.Failure = root;
        return allNode;
    }

    protected boolean HasMatch(String keyword) {
        for (int i = 0; i < keyword.length(); ++i) {
            Character c = Character.valueOf(keyword.charAt(i));
            if (c.charValue() != '.' && c.charValue() != '?' && c.charValue() != '\\' && c.charValue() != '[' && c.charValue() != '(') continue;
            return true;
        }
        return false;
    }

    protected List<String> MatchKeywordBuild(String keyword) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        Hashtable<Integer, List<String>> parameterDict = new Hashtable<Integer, List<String>>();
        this.SeparateParameters(keyword, stringBuilder, parameterDict);
        if (parameterDict.size() == 0) {
            ArrayList<String> al = new ArrayList<String>();
            al.add(stringBuilder.toString());
            return al;
        }
        ArrayList<String> parameters = new ArrayList<String>();
        BaseMatch.KeywordBuild(parameterDict, 0, parameterDict.keySet().size() - 1, "", parameters);
        String keywordFmt = stringBuilder.toString();
        ArrayList<String> list = new ArrayList<String>();
        String z = Character.valueOf('\u0000').toString();
        for (int i = 0; i < parameters.size(); ++i) {
            String item = (String)parameters.get(i);
            String[] items = item.split(z);
            Object[] ls = new Object[items.length];
            for (int j = 0; j < ls.length; ++j) {
                ls[j] = items[j];
            }
            String t = String.format(keywordFmt, ls);
            if (list.contains(t)) continue;
            list.add(t);
        }
        return list;
    }

    private void SeparateParameters(String keyword, StringBuilder stringBuilder, Map<Integer, List<String>> parameterDict) throws Exception {
        int index = 0;
        int parameterIndex = 0;
        Character zore = Character.valueOf('\u0000');
        while (index < keyword.length()) {
            ArrayList<String> ps;
            ArrayList<String> lt;
            Character c = Character.valueOf(keyword.charAt(index));
            if (c.charValue() == '.') {
                if (index + 1 < keyword.length() && keyword.charAt(index + 1) == '?') {
                    lt = new ArrayList<String>();
                    lt.add("");
                    lt.add(zore.toString());
                    parameterDict.put(parameterIndex, lt);
                    stringBuilder.append("%" + parameterIndex + "$s");
                    ++parameterIndex;
                    index += 2;
                    continue;
                }
                stringBuilder.append('\u0000');
                ++index;
                continue;
            }
            if (c.charValue() == '\\') {
                if (index + 2 < keyword.length() && keyword.charAt(index + 2) == '?') {
                    lt = new ArrayList();
                    lt.add("");
                    lt.add(Character.valueOf(keyword.charAt(index + 1)).toString());
                    parameterDict.put(parameterIndex, lt);
                    stringBuilder.append("%" + parameterIndex + "$s");
                    ++parameterIndex;
                    index += 3;
                    continue;
                }
                if (index + 1 < keyword.length()) {
                    stringBuilder.append(keyword.charAt(index + 1));
                    index += 2;
                    continue;
                }
                throw new Exception("\u3010{keyword}\u3011\u51fa\u9519\u4e86\uff0c\u6700\u540e\u4e00\u4f4d\u4e3a\\");
            }
            if (c.charValue() == '[') {
                ++index;
                ps = new ArrayList<String>();
                while (index < keyword.length() && (c = Character.valueOf(keyword.charAt(index))).charValue() != ']') {
                    if (c.charValue() == '\\') {
                        if (index + 1 >= keyword.length()) continue;
                        ps.add(Character.valueOf(keyword.charAt(index + 1)).toString());
                        index += 2;
                        continue;
                    }
                    ps.add(c.toString());
                    ++index;
                }
                if (c.charValue() != ']') {
                    throw new Exception("\u3010{keyword}\u3011\u51fa\u9519\u4e86\uff0c\u6700\u540e\u4e00\u4f4d\u4e0d\u4e3a]");
                }
                if (index + 1 < keyword.length() && keyword.charAt(index + 1) == '?') {
                    ps.add("");
                    parameterDict.put(parameterIndex, ps);
                    stringBuilder.append("%" + parameterIndex + "$s");
                    ++parameterIndex;
                    index += 2;
                    continue;
                }
                parameterDict.put(parameterIndex, ps);
                stringBuilder.append("%" + parameterIndex + "$s");
                ++parameterIndex;
                ++index;
                continue;
            }
            if (c.charValue() == '(') {
                ++index;
                ps = new ArrayList();
                String words = "";
                while (index < keyword.length() && (c = Character.valueOf(keyword.charAt(index))).charValue() != ')') {
                    if (c.charValue() == '|') {
                        ps.add(words);
                        words = "";
                        ++index;
                        continue;
                    }
                    if (c.charValue() == '\\') {
                        if (index + 1 >= keyword.length()) continue;
                        words = words + keyword.charAt(index + 1);
                        index += 2;
                        continue;
                    }
                    words = words + c;
                    ++index;
                }
                ps.add(words);
                if (c.charValue() != ')') {
                    throw new Exception("\u3010{keyword}\u3011\u51fa\u9519\u4e86\uff0c\u6700\u540e\u4e00\u4f4d\u4e0d\u4e3a)");
                }
                if (index + 1 < keyword.length() && keyword.charAt(index + 1) == '?') {
                    ps.add("");
                    parameterDict.put(parameterIndex, ps);
                    stringBuilder.append("%" + parameterIndex + "$s");
                    ++parameterIndex;
                    index += 2;
                    continue;
                }
                parameterDict.put(parameterIndex, ps);
                stringBuilder.append("%" + parameterIndex + "$s");
                ++parameterIndex;
                ++index;
                continue;
            }
            if (index + 1 < keyword.length() && keyword.charAt(index + 1) == '?') {
                lt = new ArrayList();
                lt.add("");
                lt.add(c.toString());
                parameterDict.put(parameterIndex, lt);
                stringBuilder.append("%" + parameterIndex + "$s");
                ++parameterIndex;
                index += 2;
                continue;
            }
            if (c.charValue() == '{') {
                stringBuilder.append("{{");
            } else if (c.charValue() == '}') {
                stringBuilder.append("}}");
            } else {
                stringBuilder.append(c);
            }
            ++index;
        }
    }

    private static void KeywordBuild(Map<Integer, List<String>> parameterDict, int index, int end, String keyword, List<String> result) {
        Character span = Character.valueOf('\u0001');
        List<String> list = parameterDict.get(index);
        if (index == end) {
            for (int i = 0; i < list.size(); ++i) {
                String item = list.get(i);
                result.add((keyword + span + item).substring(1));
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                String item = list.get(i);
                BaseMatch.KeywordBuild(parameterDict, index + 1, end, keyword + span + item, result);
            }
        }
    }

    public void SetKeywords(List<String> keywords) throws Exception {
        this._matchKeywords = keywords.toArray(new String[0]);
        ArrayList<String> newKeyword = new ArrayList<String>();
        ArrayList<Integer> newKeywordLength = new ArrayList<Integer>();
        ArrayList<Integer> newKeywordIndex = new ArrayList<Integer>();
        Integer index = 0;
        for (String keyword : keywords) {
            if (!this.HasMatch(keyword)) {
                newKeyword.add(keyword);
                newKeywordLength.add(keyword.length());
                newKeywordIndex.add(index);
            } else {
                List<String> list = this.MatchKeywordBuild(keyword);
                for (String item : list) {
                    newKeyword.add(item);
                    newKeywordLength.add(item.length());
                    newKeywordIndex.add(index);
                }
            }
            Integer n = index;
            index = index + 1;
        }
        this._keywordLength = new int[newKeywordLength.size()];
        for (int i = 0; i < this._keywordLength.length; ++i) {
            this._keywordLength[i] = (Integer)newKeywordLength.get(i);
        }
        this._keywordIndex = new int[newKeywordIndex.size()];
        for (int j = 0; j < this._keywordIndex.length; ++j) {
            this._keywordIndex[j] = (Integer)newKeywordIndex.get(j);
        }
        this.SetKeywords2(newKeyword);
    }

    protected void SetKeywords2(List<String> keywords) {
        int i;
        List<TrieNode> allNode = this.BuildFirstLayerTrieNode(keywords);
        TrieNode root = allNode.get(0);
        ArrayList<TrieNode3> allNode2 = new ArrayList<TrieNode3>();
        for (i = 0; i < allNode.size(); ++i) {
            allNode2.add(new TrieNode3());
        }
        for (i = 0; i < allNode2.size(); ++i) {
            TrieNode oldNode = allNode.get(i);
            TrieNode3 newNode = (TrieNode3)allNode2.get(i);
            for (Character key : oldNode.m_values.keySet()) {
                int index = oldNode.m_values.get((Object)key).Index;
                if (key.charValue() == '\u0000') {
                    newNode.HasWildcard = true;
                    newNode.WildcardNode = (TrieNode3)allNode2.get(index);
                    continue;
                }
                newNode.Add(key.charValue(), (TrieNode3)allNode2.get(index));
            }
            for (Integer item : oldNode.Results) {
                if (oldNode.IsWildcard) {
                    if (keywords.get(item).length() <= oldNode.WildcardLayer) continue;
                    newNode.SetResults(item);
                    continue;
                }
                newNode.SetResults(item);
            }
            TrieNode failure = oldNode.Failure;
            while (!(failure == root || oldNode.IsWildcard && failure.Layer <= oldNode.WildcardLayer)) {
                for (Character key : failure.m_values.keySet()) {
                    int index = failure.m_values.get((Object)key).Index;
                    if (key.charValue() == '\u0000') {
                        newNode.HasWildcard = true;
                        if (newNode.WildcardNode != null) continue;
                        newNode.WildcardNode = (TrieNode3)allNode2.get(index);
                        continue;
                    }
                    if (newNode.HasKey(key.charValue())) continue;
                    newNode.Add(key.charValue(), (TrieNode3)allNode2.get(index));
                }
                for (Integer item : failure.Results) {
                    if (oldNode.IsWildcard) {
                        if (keywords.get(item).length() <= oldNode.WildcardLayer) continue;
                        newNode.SetResults(item);
                        continue;
                    }
                    newNode.SetResults(item);
                }
                failure = failure.Failure;
            }
        }
        allNode.clear();
        allNode = null;
        root = null;
        TrieNode3[] first = new TrieNode3[65536];
        for (Character key : ((TrieNode3)allNode2.get((int)0)).m_values.keySet()) {
            first[key.charValue()] = ((TrieNode3)allNode2.get((int)0)).m_values.get(key);
        }
        this._first = first;
    }
}

