/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NumHelper {
    private static Serializer tinyIntWriter = v -> {
        if (v < -128 || v > 127) {
            throw new RuntimeException("not tinyInt: " + v);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(v);
        return out.toByteArray();
    };
    private static Serializer smallIntWriter = v -> {
        if (v < Short.MIN_VALUE || v > Short.MAX_VALUE) {
            throw new RuntimeException("not smallInt: " + v);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(v >>> 8 & 0xFF);
        out.write(v & 0xFF);
        return out.toByteArray();
    };
    private static Serializer mediumIntWriter = v -> {
        if (v < -8388608 || v > 0x7FFFFF) {
            throw new RuntimeException("not mediumInt: " + v);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v & 0xFF);
        return out.toByteArray();
    };
    private static Serializer intWriter = v -> {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(v >>> 24 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v & 0xFF);
        return out.toByteArray();
    };
    private static final Map<SerializableType, Serializer> simpleWriterMap = new ConcurrentHashMap<SerializableType, Serializer>();
    private static Deserializer tinyIntReader;
    private static Deserializer smallIntReader;
    private static Deserializer mediumIntReader;
    private static Deserializer intReader;
    private static final Map<SerializableType, Deserializer> simpleReaderMap;

    public static byte[] serialize(int v) {
        int typeFlag;
        Serializer serializer;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (v >= -128 && v <= 127) {
            serializer = simpleWriterMap.get((Object)SerializableType.TINY_INT);
            typeFlag = SerializableType.TINY_INT.getFlag();
        } else if (v >= Short.MIN_VALUE && v <= Short.MAX_VALUE) {
            serializer = simpleWriterMap.get((Object)SerializableType.SMALL_INT);
            typeFlag = SerializableType.SMALL_INT.getFlag();
        } else if (v >= -8388608 && v <= 0x7FFFFF) {
            serializer = simpleWriterMap.get((Object)SerializableType.MEDIUM_INT);
            typeFlag = SerializableType.MEDIUM_INT.getFlag();
        } else {
            serializer = simpleWriterMap.get((Object)SerializableType.INT);
            typeFlag = SerializableType.INT.getFlag();
        }
        out.write(typeFlag);
        byte[] bytes = serializer.serialize(v);
        out.write(bytes, 0, bytes.length);
        return out.toByteArray();
    }

    public static int read(InputStream in) throws IOException {
        int flag = in.read();
        SerializableType type = SerializableType.getType(flag);
        Deserializer deserializer = simpleReaderMap.get((Object)type);
        if (deserializer == null) {
            throw new RuntimeException("wrong flag: " + flag);
        }
        return deserializer.deserialize(in);
    }

    static {
        simpleWriterMap.put(SerializableType.TINY_INT, tinyIntWriter);
        simpleWriterMap.put(SerializableType.SMALL_INT, smallIntWriter);
        simpleWriterMap.put(SerializableType.MEDIUM_INT, mediumIntWriter);
        simpleWriterMap.put(SerializableType.INT, intWriter);
        tinyIntReader = in -> {
            int ch = in.read();
            if (ch < 0) {
                throw new RuntimeException("deserializing");
            }
            if ((0x80 & ch) == 128) {
                ch = 0xFFFFFF00 | ch;
            }
            return ch;
        };
        smallIntReader = in -> {
            int ch2;
            int ch1 = in.read();
            if ((ch1 | (ch2 = in.read())) < 0) {
                throw new RuntimeException("deserializing");
            }
            int ch = (ch1 << 8) + ch2;
            if ((0x8000 & ch) == 32768) {
                ch = 0xFFFF0000 | ch;
            }
            return ch;
        };
        mediumIntReader = in -> {
            int ch3;
            int ch2;
            int ch1 = in.read();
            if ((ch1 | (ch2 = in.read()) | (ch3 = in.read())) < 0) {
                throw new RuntimeException("deserializing");
            }
            int ch = (ch1 << 16) + (ch2 << 8) + ch3;
            if ((0x800000 & ch) == 0x800000) {
                ch = 0xFF000000 | ch;
            }
            return ch;
        };
        intReader = in -> {
            int ch4;
            int ch3;
            int ch2;
            int ch1 = in.read();
            if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
                throw new RuntimeException("deserializing");
            }
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
        };
        simpleReaderMap = new ConcurrentHashMap<SerializableType, Deserializer>();
        simpleReaderMap.put(SerializableType.TINY_INT, tinyIntReader);
        simpleReaderMap.put(SerializableType.SMALL_INT, smallIntReader);
        simpleReaderMap.put(SerializableType.MEDIUM_INT, mediumIntReader);
        simpleReaderMap.put(SerializableType.INT, intReader);
    }

    public static enum SerializableType {
        TINY_INT(1),
        SMALL_INT(2),
        MEDIUM_INT(3),
        INT(4);

        private final int flag;
        private static Map<Integer, SerializableType> typeMap;

        public static SerializableType getType(int flag) {
            return typeMap.get(flag);
        }

        private SerializableType(int flag) {
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }

        static {
            HashMap<Integer, SerializableType> tmpMap = new HashMap<Integer, SerializableType>();
            for (SerializableType type : SerializableType.values()) {
                tmpMap.put(type.getFlag(), type);
            }
            typeMap = tmpMap;
        }
    }

    private static interface Serializer {
        public byte[] serialize(int var1);
    }

    public static interface Deserializer {
        public int deserialize(InputStream var1) throws IOException;
    }
}

