/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger2markup.builder.document;

import io.github.robwin.markup.builder.MarkupLanguage;
import io.github.robwin.swagger2markup.builder.document.MarkupDocument;
import io.github.robwin.swagger2markup.utils.ParameterUtils;
import io.github.robwin.swagger2markup.utils.PropertyUtils;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.Property;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class PathsDocument
extends MarkupDocument {
    private static final String PATHS = "Paths";
    private static final String PARAMETERS = "Parameters";
    private static final String RESPONSES = "Responses";
    private static final String EXAMPLE_CURL = "Example CURL request";
    private static final String EXAMPLE_REQUEST = "Example HTTP request";
    private static final String EXAMPLE_RESPONSE = "Example HTTP response";
    private static final String TYPE_COLUMN = "Type";
    private static final String HTTP_CODE_COLUMN = "HTTP Code";
    private static final String REQUEST_EXAMPLE_FILE_NAME = "http-request";
    private static final String RESPONSE_EXAMPLE_FILE_NAME = "http-response";
    private static final String CURL_EXAMPLE_FILE_NAME = "curl-request";
    private static final String DESCRIPTION_FILE_NAME = "description";
    private static final String PARAMETER = "Parameter";
    private boolean examplesEnabled;
    private String examplesFolderPath;
    private boolean handWrittenDescriptionsEnabled;
    private String descriptionsFolderPath;

    public PathsDocument(Swagger swagger, MarkupLanguage markupLanguage, String examplesFolderPath, String descriptionsFolderPath) {
        super(swagger, markupLanguage);
        if (StringUtils.isNotBlank((CharSequence)examplesFolderPath)) {
            this.examplesEnabled = true;
            this.examplesFolderPath = examplesFolderPath;
        }
        if (StringUtils.isNotBlank((CharSequence)descriptionsFolderPath)) {
            this.handWrittenDescriptionsEnabled = true;
            this.descriptionsFolderPath = descriptionsFolderPath + "/" + PATHS.toLowerCase();
        }
        if (this.examplesEnabled) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Include examples is enabled.");
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Include examples is disabled.");
        }
        if (this.handWrittenDescriptionsEnabled) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Include hand-written descriptions is enabled.");
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Include hand-written descriptions is disabled.");
        }
    }

    @Override
    public MarkupDocument build() throws IOException {
        this.paths();
        return this;
    }

    private void paths() throws IOException {
        Map paths = this.swagger.getPaths();
        if (MapUtils.isNotEmpty((Map)paths)) {
            this.markupDocBuilder.sectionTitleLevel1(PATHS);
            for (Map.Entry entry : paths.entrySet()) {
                Path path = (Path)entry.getValue();
                if (path == null) continue;
                this.path("GET", (String)entry.getKey(), path.getGet());
                this.path("PUT", (String)entry.getKey(), path.getPut());
                this.path("DELETE", (String)entry.getKey(), path.getDelete());
                this.path("POST", (String)entry.getKey(), path.getPost());
                this.path("PATCH", (String)entry.getKey(), path.getPatch());
            }
        }
    }

    private void path(String httpMethod, String resourcePath, Operation operation) throws IOException {
        if (operation != null) {
            this.pathTitle(httpMethod, resourcePath, operation);
            this.descriptionSection(operation);
            this.parametersSection(operation);
            this.responsesSection(operation);
            this.consumesSection(operation);
            this.producesSection(operation);
            this.tagsSection(operation);
            this.examplesSection(operation);
        }
    }

    private void pathTitle(String httpMethod, String resourcePath, Operation operation) {
        String title;
        String summary = operation.getSummary();
        if (StringUtils.isNotBlank((CharSequence)summary)) {
            title = summary;
            this.markupDocBuilder.sectionTitleLevel2(title);
            this.markupDocBuilder.listing(httpMethod + " " + resourcePath);
        } else {
            title = httpMethod + " " + resourcePath;
            this.markupDocBuilder.sectionTitleLevel2(title);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Path processed: {}", (Object)title);
        }
    }

    private void descriptionSection(Operation operation) throws IOException {
        if (this.handWrittenDescriptionsEnabled) {
            String summary = operation.getSummary();
            if (StringUtils.isNotBlank((CharSequence)summary)) {
                String operationFolder = summary.replace(".", "").replace(" ", "_").toLowerCase();
                String description = this.handWrittenPathDescription(operationFolder, DESCRIPTION_FILE_NAME);
                if (StringUtils.isNotBlank((CharSequence)description)) {
                    this.markupDocBuilder.sectionTitleLevel3("Description");
                    this.markupDocBuilder.paragraph(description);
                } else {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Hand-written description cannot be read. Trying to use description from Swagger source.");
                    }
                    this.pathDescription(operation);
                }
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Hand-written description cannot be read, because summary of operation is empty. Trying to use description from Swagger source.");
                }
                this.pathDescription(operation);
            }
        } else {
            this.pathDescription(operation);
        }
    }

    private void pathDescription(Operation operation) {
        String description = operation.getDescription();
        if (StringUtils.isNotBlank((CharSequence)description)) {
            this.markupDocBuilder.sectionTitleLevel3("Description");
            this.markupDocBuilder.paragraph(description);
        }
    }

    private void parametersSection(Operation operation) throws IOException {
        List parameters = operation.getParameters();
        if (CollectionUtils.isNotEmpty((Collection)parameters)) {
            ArrayList<String> headerAndContent = new ArrayList<String>();
            List<String> header = Arrays.asList(TYPE_COLUMN, "Name", "Description", "Required", "Schema", "Default");
            headerAndContent.add(StringUtils.join(header, (String)"|"));
            for (Parameter parameter : parameters) {
                String type = ParameterUtils.getType(parameter, this.markupLanguage);
                String parameterType = WordUtils.capitalize((String)(parameter.getIn() + PARAMETER));
                List<String> content = Arrays.asList(parameterType, parameter.getName(), this.parameterDescription(operation, parameter), Boolean.toString(parameter.getRequired()), type, ParameterUtils.getDefaultValue(parameter));
                headerAndContent.add(StringUtils.join(content, (String)"|"));
            }
            this.markupDocBuilder.sectionTitleLevel3(PARAMETERS);
            this.markupDocBuilder.tableWithHeaderRow(headerAndContent);
        }
    }

    private String parameterDescription(Operation operation, Parameter parameter) throws IOException {
        String description;
        if (this.handWrittenDescriptionsEnabled) {
            String summary = operation.getSummary();
            String operationFolder = summary.replace(".", "").replace(" ", "_").toLowerCase();
            String parameterName = parameter.getName();
            if (StringUtils.isNotBlank((CharSequence)operationFolder) && StringUtils.isNotBlank((CharSequence)parameterName)) {
                description = this.handWrittenPathDescription(operationFolder + "/" + parameterName, DESCRIPTION_FILE_NAME);
                if (StringUtils.isBlank((CharSequence)description)) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Hand-written description file cannot be read. Trying to use description from Swagger source.");
                    }
                    description = StringUtils.defaultString((String)parameter.getDescription());
                }
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Hand-written description file cannot be read, because summary of operation or name of parameter is empty. Trying to use description from Swagger source.");
                }
                description = StringUtils.defaultString((String)parameter.getDescription());
            }
        } else {
            description = StringUtils.defaultString((String)parameter.getDescription());
        }
        return description;
    }

    private void consumesSection(Operation operation) {
        List consumes = operation.getConsumes();
        if (CollectionUtils.isNotEmpty((Collection)consumes)) {
            this.markupDocBuilder.sectionTitleLevel3("Consumes");
            this.markupDocBuilder.unorderedList(consumes);
        }
    }

    private void producesSection(Operation operation) {
        List produces = operation.getProduces();
        if (CollectionUtils.isNotEmpty((Collection)produces)) {
            this.markupDocBuilder.sectionTitleLevel3("Produces");
            this.markupDocBuilder.unorderedList(produces);
        }
    }

    private void tagsSection(Operation operation) {
        List tags = operation.getTags();
        if (CollectionUtils.isNotEmpty((Collection)tags)) {
            this.markupDocBuilder.sectionTitleLevel3("Tags");
            this.markupDocBuilder.unorderedList(tags);
        }
    }

    private void examplesSection(Operation operation) throws IOException {
        if (this.examplesEnabled) {
            String summary = operation.getSummary();
            if (StringUtils.isNotBlank((CharSequence)summary)) {
                String responseExample;
                String requestExample;
                String exampleFolder = summary.replace(".", "").replace(" ", "_").toLowerCase();
                String curlExample = this.example(exampleFolder, CURL_EXAMPLE_FILE_NAME);
                if (StringUtils.isNotBlank((CharSequence)curlExample)) {
                    this.markupDocBuilder.sectionTitleLevel3(EXAMPLE_CURL);
                    this.markupDocBuilder.paragraph(curlExample);
                }
                if (StringUtils.isNotBlank((CharSequence)(requestExample = this.example(exampleFolder, REQUEST_EXAMPLE_FILE_NAME)))) {
                    this.markupDocBuilder.sectionTitleLevel3(EXAMPLE_REQUEST);
                    this.markupDocBuilder.paragraph(requestExample);
                }
                if (StringUtils.isNotBlank((CharSequence)(responseExample = this.example(exampleFolder, RESPONSE_EXAMPLE_FILE_NAME)))) {
                    this.markupDocBuilder.sectionTitleLevel3(EXAMPLE_RESPONSE);
                    this.markupDocBuilder.paragraph(responseExample);
                }
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn("Example file cannot be read, because summary of operation is empty.");
            }
        }
    }

    private String example(String exampleFolder, String exampleFileName) throws IOException {
        for (String fileNameExtension : this.markupLanguage.getFileNameExtensions()) {
            java.nio.file.Path path = Paths.get(this.examplesFolderPath, exampleFolder, exampleFileName + fileNameExtension);
            if (Files.isReadable(path)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Example file processed: {}", (Object)path);
                }
                return FileUtils.readFileToString((File)path.toFile(), (Charset)StandardCharsets.UTF_8).trim();
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Example file is not readable: {}", (Object)path);
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.info("No example file found with correct file name extension in folder: {}", (Object)Paths.get(this.examplesFolderPath, exampleFolder));
        }
        return null;
    }

    private String handWrittenPathDescription(String descriptionFolder, String descriptionFileName) throws IOException {
        for (String fileNameExtension : this.markupLanguage.getFileNameExtensions()) {
            java.nio.file.Path path = Paths.get(this.descriptionsFolderPath, descriptionFolder, descriptionFileName + fileNameExtension);
            if (Files.isReadable(path)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Description file processed: {}", (Object)path);
                }
                return FileUtils.readFileToString((File)path.toFile(), (Charset)StandardCharsets.UTF_8).trim();
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Description file is not readable: {}", (Object)path);
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.info("No description file found with correct file name extension in folder: {}", (Object)Paths.get(this.descriptionsFolderPath, descriptionFolder));
        }
        return null;
    }

    private void responsesSection(Operation operation) {
        Map responses = operation.getResponses();
        if (MapUtils.isNotEmpty((Map)responses)) {
            ArrayList<String> csvContent = new ArrayList<String>();
            csvContent.add("HTTP Code|Description|Schema");
            for (Map.Entry entry : responses.entrySet()) {
                Response response = (Response)entry.getValue();
                if (response.getSchema() != null) {
                    Property property = response.getSchema();
                    String type = PropertyUtils.getType(property, this.markupLanguage);
                    csvContent.add((String)entry.getKey() + "|" + response.getDescription() + "|" + type);
                    continue;
                }
                csvContent.add((String)entry.getKey() + "|" + response.getDescription() + "|" + "No Content");
            }
            this.markupDocBuilder.sectionTitleLevel3(RESPONSES);
            this.markupDocBuilder.tableWithHeaderRow(csvContent);
        }
    }
}

