package io.envoyproxy.envoy.service.trace.v2;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * Service for streaming traces to server that consumes the trace data. It
 * uses OpenCensus data model as a standard to represent trace information.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.22.1)",
    comments = "Source: envoy/service/trace/v2/trace_service.proto")
public final class TraceServiceGrpc {

  private TraceServiceGrpc() {}

  public static final String SERVICE_NAME = "envoy.service.trace.v2.TraceService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.envoyproxy.envoy.service.trace.v2.StreamTracesMessage,
      io.envoyproxy.envoy.service.trace.v2.StreamTracesResponse> getStreamTracesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "StreamTraces",
      requestType = io.envoyproxy.envoy.service.trace.v2.StreamTracesMessage.class,
      responseType = io.envoyproxy.envoy.service.trace.v2.StreamTracesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.CLIENT_STREAMING)
  public static io.grpc.MethodDescriptor<io.envoyproxy.envoy.service.trace.v2.StreamTracesMessage,
      io.envoyproxy.envoy.service.trace.v2.StreamTracesResponse> getStreamTracesMethod() {
    io.grpc.MethodDescriptor<io.envoyproxy.envoy.service.trace.v2.StreamTracesMessage, io.envoyproxy.envoy.service.trace.v2.StreamTracesResponse> getStreamTracesMethod;
    if ((getStreamTracesMethod = TraceServiceGrpc.getStreamTracesMethod) == null) {
      synchronized (TraceServiceGrpc.class) {
        if ((getStreamTracesMethod = TraceServiceGrpc.getStreamTracesMethod) == null) {
          TraceServiceGrpc.getStreamTracesMethod = getStreamTracesMethod = 
              io.grpc.MethodDescriptor.<io.envoyproxy.envoy.service.trace.v2.StreamTracesMessage, io.envoyproxy.envoy.service.trace.v2.StreamTracesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.CLIENT_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "envoy.service.trace.v2.TraceService", "StreamTraces"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.envoyproxy.envoy.service.trace.v2.StreamTracesMessage.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.envoyproxy.envoy.service.trace.v2.StreamTracesResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new TraceServiceMethodDescriptorSupplier("StreamTraces"))
                  .build();
          }
        }
     }
     return getStreamTracesMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static TraceServiceStub newStub(io.grpc.Channel channel) {
    return new TraceServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static TraceServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new TraceServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static TraceServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new TraceServiceFutureStub(channel);
  }

  /**
   * <pre>
   * Service for streaming traces to server that consumes the trace data. It
   * uses OpenCensus data model as a standard to represent trace information.
   * </pre>
   */
  public static abstract class TraceServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Envoy will connect and send StreamTracesMessage messages forever. It does
     * not expect any response to be sent as nothing would be done in the case
     * of failure.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<io.envoyproxy.envoy.service.trace.v2.StreamTracesMessage> streamTraces(
        io.grpc.stub.StreamObserver<io.envoyproxy.envoy.service.trace.v2.StreamTracesResponse> responseObserver) {
      return asyncUnimplementedStreamingCall(getStreamTracesMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getStreamTracesMethod(),
            asyncClientStreamingCall(
              new MethodHandlers<
                io.envoyproxy.envoy.service.trace.v2.StreamTracesMessage,
                io.envoyproxy.envoy.service.trace.v2.StreamTracesResponse>(
                  this, METHODID_STREAM_TRACES)))
          .build();
    }
  }

  /**
   * <pre>
   * Service for streaming traces to server that consumes the trace data. It
   * uses OpenCensus data model as a standard to represent trace information.
   * </pre>
   */
  public static final class TraceServiceStub extends io.grpc.stub.AbstractStub<TraceServiceStub> {
    private TraceServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private TraceServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TraceServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new TraceServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Envoy will connect and send StreamTracesMessage messages forever. It does
     * not expect any response to be sent as nothing would be done in the case
     * of failure.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<io.envoyproxy.envoy.service.trace.v2.StreamTracesMessage> streamTraces(
        io.grpc.stub.StreamObserver<io.envoyproxy.envoy.service.trace.v2.StreamTracesResponse> responseObserver) {
      return asyncClientStreamingCall(
          getChannel().newCall(getStreamTracesMethod(), getCallOptions()), responseObserver);
    }
  }

  /**
   * <pre>
   * Service for streaming traces to server that consumes the trace data. It
   * uses OpenCensus data model as a standard to represent trace information.
   * </pre>
   */
  public static final class TraceServiceBlockingStub extends io.grpc.stub.AbstractStub<TraceServiceBlockingStub> {
    private TraceServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private TraceServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TraceServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new TraceServiceBlockingStub(channel, callOptions);
    }
  }

  /**
   * <pre>
   * Service for streaming traces to server that consumes the trace data. It
   * uses OpenCensus data model as a standard to represent trace information.
   * </pre>
   */
  public static final class TraceServiceFutureStub extends io.grpc.stub.AbstractStub<TraceServiceFutureStub> {
    private TraceServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private TraceServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TraceServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new TraceServiceFutureStub(channel, callOptions);
    }
  }

  private static final int METHODID_STREAM_TRACES = 0;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final TraceServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(TraceServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_STREAM_TRACES:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.streamTraces(
              (io.grpc.stub.StreamObserver<io.envoyproxy.envoy.service.trace.v2.StreamTracesResponse>) responseObserver);
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class TraceServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    TraceServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.envoyproxy.envoy.service.trace.v2.TraceServiceProto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("TraceService");
    }
  }

  private static final class TraceServiceFileDescriptorSupplier
      extends TraceServiceBaseDescriptorSupplier {
    TraceServiceFileDescriptorSupplier() {}
  }

  private static final class TraceServiceMethodDescriptorSupplier
      extends TraceServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    TraceServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (TraceServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new TraceServiceFileDescriptorSupplier())
              .addMethod(getStreamTracesMethod())
              .build();
        }
      }
    }
    return result;
  }
}
