// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: envoy/extensions/filters/http/jwt_authn/v3/config.proto

package io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3;

/**
 * <pre>
 * Please see following for JWT authentication flow:
 * * `JSON Web Token (JWT) &lt;https://tools.ietf.org/html/rfc7519&gt;`_
 * * `The OAuth 2.0 Authorization Framework &lt;https://tools.ietf.org/html/rfc6749&gt;`_
 * * `OpenID Connect &lt;http://openid.net/connect&gt;`_
 * A JwtProvider message specifies how a JSON Web Token (JWT) can be verified. It specifies:
 * * issuer: the principal that issues the JWT. It has to match the one from the token.
 * * allowed audiences: the ones in the token have to be listed here.
 * * how to fetch public key JWKS to verify the token signature.
 * * how to extract JWT token in the request.
 * * how to pass successfully verified token payload.
 * Example:
 * .. code-block:: yaml
 *     issuer: https://example.com
 *     audiences:
 *     - bookstore_android.apps.googleusercontent.com
 *     - bookstore_web.apps.googleusercontent.com
 *     remote_jwks:
 *       http_uri:
 *         uri: https://example.com/.well-known/jwks.json
 *         cluster: example_jwks_cluster
 *       cache_duration:
 *         seconds: 300
 * [#next-free-field: 10]
 * </pre>
 *
 * Protobuf type {@code envoy.extensions.filters.http.jwt_authn.v3.JwtProvider}
 */
public  final class JwtProvider extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:envoy.extensions.filters.http.jwt_authn.v3.JwtProvider)
    JwtProviderOrBuilder {
private static final long serialVersionUID = 0L;
  // Use JwtProvider.newBuilder() to construct.
  private JwtProvider(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private JwtProvider() {
    issuer_ = "";
    audiences_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    fromHeaders_ = java.util.Collections.emptyList();
    fromParams_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    forwardPayloadHeader_ = "";
    payloadInMetadata_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new JwtProvider();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private JwtProvider(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            issuer_ = s;
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
              audiences_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000001;
            }
            audiences_.add(s);
            break;
          }
          case 26: {
            io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks.Builder subBuilder = null;
            if (jwksSourceSpecifierCase_ == 3) {
              subBuilder = ((io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks) jwksSourceSpecifier_).toBuilder();
            }
            jwksSourceSpecifier_ =
                input.readMessage(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks) jwksSourceSpecifier_);
              jwksSourceSpecifier_ = subBuilder.buildPartial();
            }
            jwksSourceSpecifierCase_ = 3;
            break;
          }
          case 34: {
            io.envoyproxy.envoy.config.core.v3.DataSource.Builder subBuilder = null;
            if (jwksSourceSpecifierCase_ == 4) {
              subBuilder = ((io.envoyproxy.envoy.config.core.v3.DataSource) jwksSourceSpecifier_).toBuilder();
            }
            jwksSourceSpecifier_ =
                input.readMessage(io.envoyproxy.envoy.config.core.v3.DataSource.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((io.envoyproxy.envoy.config.core.v3.DataSource) jwksSourceSpecifier_);
              jwksSourceSpecifier_ = subBuilder.buildPartial();
            }
            jwksSourceSpecifierCase_ = 4;
            break;
          }
          case 40: {

            forward_ = input.readBool();
            break;
          }
          case 50: {
            if (!((mutable_bitField0_ & 0x00000002) != 0)) {
              fromHeaders_ = new java.util.ArrayList<io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader>();
              mutable_bitField0_ |= 0x00000002;
            }
            fromHeaders_.add(
                input.readMessage(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader.parser(), extensionRegistry));
            break;
          }
          case 58: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000004) != 0)) {
              fromParams_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000004;
            }
            fromParams_.add(s);
            break;
          }
          case 66: {
            java.lang.String s = input.readStringRequireUtf8();

            forwardPayloadHeader_ = s;
            break;
          }
          case 74: {
            java.lang.String s = input.readStringRequireUtf8();

            payloadInMetadata_ = s;
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        audiences_ = audiences_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        fromHeaders_ = java.util.Collections.unmodifiableList(fromHeaders_);
      }
      if (((mutable_bitField0_ & 0x00000004) != 0)) {
        fromParams_ = fromParams_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ConfigProto.internal_static_envoy_extensions_filters_http_jwt_authn_v3_JwtProvider_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ConfigProto.internal_static_envoy_extensions_filters_http_jwt_authn_v3_JwtProvider_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider.class, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider.Builder.class);
  }

  private int jwksSourceSpecifierCase_ = 0;
  private java.lang.Object jwksSourceSpecifier_;
  public enum JwksSourceSpecifierCase
      implements com.google.protobuf.Internal.EnumLite {
    REMOTE_JWKS(3),
    LOCAL_JWKS(4),
    JWKSSOURCESPECIFIER_NOT_SET(0);
    private final int value;
    private JwksSourceSpecifierCase(int value) {
      this.value = value;
    }
    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static JwksSourceSpecifierCase valueOf(int value) {
      return forNumber(value);
    }

    public static JwksSourceSpecifierCase forNumber(int value) {
      switch (value) {
        case 3: return REMOTE_JWKS;
        case 4: return LOCAL_JWKS;
        case 0: return JWKSSOURCESPECIFIER_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public JwksSourceSpecifierCase
  getJwksSourceSpecifierCase() {
    return JwksSourceSpecifierCase.forNumber(
        jwksSourceSpecifierCase_);
  }

  public static final int ISSUER_FIELD_NUMBER = 1;
  private volatile java.lang.Object issuer_;
  /**
   * <pre>
   * Specify the `principal &lt;https://tools.ietf.org/html/rfc7519#section-4.1.1&gt;`_ that issued
   * the JWT, usually a URL or an email address.
   * Example: https://securetoken.google.com
   * Example: 1234567-compute&#64;developer.gserviceaccount.com
   * </pre>
   *
   * <code>string issuer = 1 [(.validate.rules) = { ... }</code>
   */
  public java.lang.String getIssuer() {
    java.lang.Object ref = issuer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      issuer_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Specify the `principal &lt;https://tools.ietf.org/html/rfc7519#section-4.1.1&gt;`_ that issued
   * the JWT, usually a URL or an email address.
   * Example: https://securetoken.google.com
   * Example: 1234567-compute&#64;developer.gserviceaccount.com
   * </pre>
   *
   * <code>string issuer = 1 [(.validate.rules) = { ... }</code>
   */
  public com.google.protobuf.ByteString
      getIssuerBytes() {
    java.lang.Object ref = issuer_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      issuer_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUDIENCES_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList audiences_;
  /**
   * <pre>
   * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
   * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
   * will not check audiences in the token.
   * Example:
   * .. code-block:: yaml
   *     audiences:
   *     - bookstore_android.apps.googleusercontent.com
   *     - bookstore_web.apps.googleusercontent.com
   * </pre>
   *
   * <code>repeated string audiences = 2;</code>
   */
  public com.google.protobuf.ProtocolStringList
      getAudiencesList() {
    return audiences_;
  }
  /**
   * <pre>
   * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
   * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
   * will not check audiences in the token.
   * Example:
   * .. code-block:: yaml
   *     audiences:
   *     - bookstore_android.apps.googleusercontent.com
   *     - bookstore_web.apps.googleusercontent.com
   * </pre>
   *
   * <code>repeated string audiences = 2;</code>
   */
  public int getAudiencesCount() {
    return audiences_.size();
  }
  /**
   * <pre>
   * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
   * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
   * will not check audiences in the token.
   * Example:
   * .. code-block:: yaml
   *     audiences:
   *     - bookstore_android.apps.googleusercontent.com
   *     - bookstore_web.apps.googleusercontent.com
   * </pre>
   *
   * <code>repeated string audiences = 2;</code>
   */
  public java.lang.String getAudiences(int index) {
    return audiences_.get(index);
  }
  /**
   * <pre>
   * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
   * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
   * will not check audiences in the token.
   * Example:
   * .. code-block:: yaml
   *     audiences:
   *     - bookstore_android.apps.googleusercontent.com
   *     - bookstore_web.apps.googleusercontent.com
   * </pre>
   *
   * <code>repeated string audiences = 2;</code>
   */
  public com.google.protobuf.ByteString
      getAudiencesBytes(int index) {
    return audiences_.getByteString(index);
  }

  public static final int REMOTE_JWKS_FIELD_NUMBER = 3;
  /**
   * <pre>
   * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
   * URI and how the fetched JWKS should be cached.
   * Example:
   * .. code-block:: yaml
   *    remote_jwks:
   *      http_uri:
   *        uri: https://www.googleapis.com/oauth2/v1/certs
   *        cluster: jwt.www.googleapis.com|443
   *      cache_duration:
   *        seconds: 300
   * </pre>
   *
   * <code>.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks remote_jwks = 3;</code>
   */
  public boolean hasRemoteJwks() {
    return jwksSourceSpecifierCase_ == 3;
  }
  /**
   * <pre>
   * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
   * URI and how the fetched JWKS should be cached.
   * Example:
   * .. code-block:: yaml
   *    remote_jwks:
   *      http_uri:
   *        uri: https://www.googleapis.com/oauth2/v1/certs
   *        cluster: jwt.www.googleapis.com|443
   *      cache_duration:
   *        seconds: 300
   * </pre>
   *
   * <code>.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks remote_jwks = 3;</code>
   */
  public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks getRemoteJwks() {
    if (jwksSourceSpecifierCase_ == 3) {
       return (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks) jwksSourceSpecifier_;
    }
    return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks.getDefaultInstance();
  }
  /**
   * <pre>
   * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
   * URI and how the fetched JWKS should be cached.
   * Example:
   * .. code-block:: yaml
   *    remote_jwks:
   *      http_uri:
   *        uri: https://www.googleapis.com/oauth2/v1/certs
   *        cluster: jwt.www.googleapis.com|443
   *      cache_duration:
   *        seconds: 300
   * </pre>
   *
   * <code>.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks remote_jwks = 3;</code>
   */
  public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwksOrBuilder getRemoteJwksOrBuilder() {
    if (jwksSourceSpecifierCase_ == 3) {
       return (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks) jwksSourceSpecifier_;
    }
    return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks.getDefaultInstance();
  }

  public static final int LOCAL_JWKS_FIELD_NUMBER = 4;
  /**
   * <pre>
   * JWKS is in local data source. It could be either in a local file or embedded in the
   * inline_string.
   * Example: local file
   * .. code-block:: yaml
   *    local_jwks:
   *      filename: /etc/envoy/jwks/jwks1.txt
   * Example: inline_string
   * .. code-block:: yaml
   *    local_jwks:
   *      inline_string: ACADADADADA
   * </pre>
   *
   * <code>.envoy.config.core.v3.DataSource local_jwks = 4;</code>
   */
  public boolean hasLocalJwks() {
    return jwksSourceSpecifierCase_ == 4;
  }
  /**
   * <pre>
   * JWKS is in local data source. It could be either in a local file or embedded in the
   * inline_string.
   * Example: local file
   * .. code-block:: yaml
   *    local_jwks:
   *      filename: /etc/envoy/jwks/jwks1.txt
   * Example: inline_string
   * .. code-block:: yaml
   *    local_jwks:
   *      inline_string: ACADADADADA
   * </pre>
   *
   * <code>.envoy.config.core.v3.DataSource local_jwks = 4;</code>
   */
  public io.envoyproxy.envoy.config.core.v3.DataSource getLocalJwks() {
    if (jwksSourceSpecifierCase_ == 4) {
       return (io.envoyproxy.envoy.config.core.v3.DataSource) jwksSourceSpecifier_;
    }
    return io.envoyproxy.envoy.config.core.v3.DataSource.getDefaultInstance();
  }
  /**
   * <pre>
   * JWKS is in local data source. It could be either in a local file or embedded in the
   * inline_string.
   * Example: local file
   * .. code-block:: yaml
   *    local_jwks:
   *      filename: /etc/envoy/jwks/jwks1.txt
   * Example: inline_string
   * .. code-block:: yaml
   *    local_jwks:
   *      inline_string: ACADADADADA
   * </pre>
   *
   * <code>.envoy.config.core.v3.DataSource local_jwks = 4;</code>
   */
  public io.envoyproxy.envoy.config.core.v3.DataSourceOrBuilder getLocalJwksOrBuilder() {
    if (jwksSourceSpecifierCase_ == 4) {
       return (io.envoyproxy.envoy.config.core.v3.DataSource) jwksSourceSpecifier_;
    }
    return io.envoyproxy.envoy.config.core.v3.DataSource.getDefaultInstance();
  }

  public static final int FORWARD_FIELD_NUMBER = 5;
  private boolean forward_;
  /**
   * <pre>
   * If false, the JWT is removed in the request after a success verification. If true, the JWT is
   * not removed in the request. Default value is false.
   * </pre>
   *
   * <code>bool forward = 5;</code>
   */
  public boolean getForward() {
    return forward_;
  }

  public static final int FROM_HEADERS_FIELD_NUMBER = 6;
  private java.util.List<io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader> fromHeaders_;
  /**
   * <pre>
   * Two fields below define where to extract the JWT from an HTTP request.
   * If no explicit location is specified, the following default locations are tried in order:
   * 1. The Authorization header using the `Bearer schema
   * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
   *    Authorization: Bearer &lt;token&gt;.
   * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
   * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
   * its provider specified or from the default locations.
   * Specify the HTTP headers to extract JWT token. For examples, following config:
   * .. code-block:: yaml
   *   from_headers:
   *   - name: x-goog-iap-jwt-assertion
   * can be used to extract token from header::
   *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
   * </pre>
   *
   * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
   */
  public java.util.List<io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader> getFromHeadersList() {
    return fromHeaders_;
  }
  /**
   * <pre>
   * Two fields below define where to extract the JWT from an HTTP request.
   * If no explicit location is specified, the following default locations are tried in order:
   * 1. The Authorization header using the `Bearer schema
   * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
   *    Authorization: Bearer &lt;token&gt;.
   * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
   * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
   * its provider specified or from the default locations.
   * Specify the HTTP headers to extract JWT token. For examples, following config:
   * .. code-block:: yaml
   *   from_headers:
   *   - name: x-goog-iap-jwt-assertion
   * can be used to extract token from header::
   *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
   * </pre>
   *
   * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
   */
  public java.util.List<? extends io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeaderOrBuilder> 
      getFromHeadersOrBuilderList() {
    return fromHeaders_;
  }
  /**
   * <pre>
   * Two fields below define where to extract the JWT from an HTTP request.
   * If no explicit location is specified, the following default locations are tried in order:
   * 1. The Authorization header using the `Bearer schema
   * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
   *    Authorization: Bearer &lt;token&gt;.
   * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
   * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
   * its provider specified or from the default locations.
   * Specify the HTTP headers to extract JWT token. For examples, following config:
   * .. code-block:: yaml
   *   from_headers:
   *   - name: x-goog-iap-jwt-assertion
   * can be used to extract token from header::
   *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
   * </pre>
   *
   * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
   */
  public int getFromHeadersCount() {
    return fromHeaders_.size();
  }
  /**
   * <pre>
   * Two fields below define where to extract the JWT from an HTTP request.
   * If no explicit location is specified, the following default locations are tried in order:
   * 1. The Authorization header using the `Bearer schema
   * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
   *    Authorization: Bearer &lt;token&gt;.
   * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
   * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
   * its provider specified or from the default locations.
   * Specify the HTTP headers to extract JWT token. For examples, following config:
   * .. code-block:: yaml
   *   from_headers:
   *   - name: x-goog-iap-jwt-assertion
   * can be used to extract token from header::
   *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
   * </pre>
   *
   * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
   */
  public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader getFromHeaders(int index) {
    return fromHeaders_.get(index);
  }
  /**
   * <pre>
   * Two fields below define where to extract the JWT from an HTTP request.
   * If no explicit location is specified, the following default locations are tried in order:
   * 1. The Authorization header using the `Bearer schema
   * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
   *    Authorization: Bearer &lt;token&gt;.
   * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
   * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
   * its provider specified or from the default locations.
   * Specify the HTTP headers to extract JWT token. For examples, following config:
   * .. code-block:: yaml
   *   from_headers:
   *   - name: x-goog-iap-jwt-assertion
   * can be used to extract token from header::
   *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
   * </pre>
   *
   * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
   */
  public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeaderOrBuilder getFromHeadersOrBuilder(
      int index) {
    return fromHeaders_.get(index);
  }

  public static final int FROM_PARAMS_FIELD_NUMBER = 7;
  private com.google.protobuf.LazyStringList fromParams_;
  /**
   * <pre>
   * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
   * For example, if config is:
   * .. code-block:: yaml
   *   from_params:
   *   - jwt_token
   * The JWT format in query parameter is::
   *    /path?jwt_token=&lt;JWT&gt;
   * </pre>
   *
   * <code>repeated string from_params = 7;</code>
   */
  public com.google.protobuf.ProtocolStringList
      getFromParamsList() {
    return fromParams_;
  }
  /**
   * <pre>
   * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
   * For example, if config is:
   * .. code-block:: yaml
   *   from_params:
   *   - jwt_token
   * The JWT format in query parameter is::
   *    /path?jwt_token=&lt;JWT&gt;
   * </pre>
   *
   * <code>repeated string from_params = 7;</code>
   */
  public int getFromParamsCount() {
    return fromParams_.size();
  }
  /**
   * <pre>
   * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
   * For example, if config is:
   * .. code-block:: yaml
   *   from_params:
   *   - jwt_token
   * The JWT format in query parameter is::
   *    /path?jwt_token=&lt;JWT&gt;
   * </pre>
   *
   * <code>repeated string from_params = 7;</code>
   */
  public java.lang.String getFromParams(int index) {
    return fromParams_.get(index);
  }
  /**
   * <pre>
   * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
   * For example, if config is:
   * .. code-block:: yaml
   *   from_params:
   *   - jwt_token
   * The JWT format in query parameter is::
   *    /path?jwt_token=&lt;JWT&gt;
   * </pre>
   *
   * <code>repeated string from_params = 7;</code>
   */
  public com.google.protobuf.ByteString
      getFromParamsBytes(int index) {
    return fromParams_.getByteString(index);
  }

  public static final int FORWARD_PAYLOAD_HEADER_FIELD_NUMBER = 8;
  private volatile java.lang.Object forwardPayloadHeader_;
  /**
   * <pre>
   * This field specifies the header name to forward a successfully verified JWT payload to the
   * backend. The forwarded data is::
   *    base64url_encoded(jwt_payload_in_JSON)
   * If it is not specified, the payload will not be forwarded.
   * </pre>
   *
   * <code>string forward_payload_header = 8 [(.validate.rules) = { ... }</code>
   */
  public java.lang.String getForwardPayloadHeader() {
    java.lang.Object ref = forwardPayloadHeader_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      forwardPayloadHeader_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * This field specifies the header name to forward a successfully verified JWT payload to the
   * backend. The forwarded data is::
   *    base64url_encoded(jwt_payload_in_JSON)
   * If it is not specified, the payload will not be forwarded.
   * </pre>
   *
   * <code>string forward_payload_header = 8 [(.validate.rules) = { ... }</code>
   */
  public com.google.protobuf.ByteString
      getForwardPayloadHeaderBytes() {
    java.lang.Object ref = forwardPayloadHeader_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      forwardPayloadHeader_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAYLOAD_IN_METADATA_FIELD_NUMBER = 9;
  private volatile java.lang.Object payloadInMetadata_;
  /**
   * <pre>
   * If non empty, successfully verified JWT payloads will be written to StreamInfo DynamicMetadata
   * in the format as: *namespace* is the jwt_authn filter name as **envoy.filters.http.jwt_authn**
   * The value is the *protobuf::Struct*. The value of this field will be the key for its *fields*
   * and the value is the *protobuf::Struct* converted from JWT JSON payload.
   * For example, if payload_in_metadata is *my_payload*:
   * .. code-block:: yaml
   *   envoy.filters.http.jwt_authn:
   *     my_payload:
   *       iss: https://example.com
   *       sub: test&#64;example.com
   *       aud: https://example.com
   *       exp: 1501281058
   * </pre>
   *
   * <code>string payload_in_metadata = 9;</code>
   */
  public java.lang.String getPayloadInMetadata() {
    java.lang.Object ref = payloadInMetadata_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      payloadInMetadata_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * If non empty, successfully verified JWT payloads will be written to StreamInfo DynamicMetadata
   * in the format as: *namespace* is the jwt_authn filter name as **envoy.filters.http.jwt_authn**
   * The value is the *protobuf::Struct*. The value of this field will be the key for its *fields*
   * and the value is the *protobuf::Struct* converted from JWT JSON payload.
   * For example, if payload_in_metadata is *my_payload*:
   * .. code-block:: yaml
   *   envoy.filters.http.jwt_authn:
   *     my_payload:
   *       iss: https://example.com
   *       sub: test&#64;example.com
   *       aud: https://example.com
   *       exp: 1501281058
   * </pre>
   *
   * <code>string payload_in_metadata = 9;</code>
   */
  public com.google.protobuf.ByteString
      getPayloadInMetadataBytes() {
    java.lang.Object ref = payloadInMetadata_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      payloadInMetadata_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getIssuerBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, issuer_);
    }
    for (int i = 0; i < audiences_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, audiences_.getRaw(i));
    }
    if (jwksSourceSpecifierCase_ == 3) {
      output.writeMessage(3, (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks) jwksSourceSpecifier_);
    }
    if (jwksSourceSpecifierCase_ == 4) {
      output.writeMessage(4, (io.envoyproxy.envoy.config.core.v3.DataSource) jwksSourceSpecifier_);
    }
    if (forward_ != false) {
      output.writeBool(5, forward_);
    }
    for (int i = 0; i < fromHeaders_.size(); i++) {
      output.writeMessage(6, fromHeaders_.get(i));
    }
    for (int i = 0; i < fromParams_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, fromParams_.getRaw(i));
    }
    if (!getForwardPayloadHeaderBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, forwardPayloadHeader_);
    }
    if (!getPayloadInMetadataBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, payloadInMetadata_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getIssuerBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, issuer_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < audiences_.size(); i++) {
        dataSize += computeStringSizeNoTag(audiences_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAudiencesList().size();
    }
    if (jwksSourceSpecifierCase_ == 3) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks) jwksSourceSpecifier_);
    }
    if (jwksSourceSpecifierCase_ == 4) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, (io.envoyproxy.envoy.config.core.v3.DataSource) jwksSourceSpecifier_);
    }
    if (forward_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(5, forward_);
    }
    for (int i = 0; i < fromHeaders_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, fromHeaders_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < fromParams_.size(); i++) {
        dataSize += computeStringSizeNoTag(fromParams_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFromParamsList().size();
    }
    if (!getForwardPayloadHeaderBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, forwardPayloadHeader_);
    }
    if (!getPayloadInMetadataBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, payloadInMetadata_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider)) {
      return super.equals(obj);
    }
    io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider other = (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider) obj;

    if (!getIssuer()
        .equals(other.getIssuer())) return false;
    if (!getAudiencesList()
        .equals(other.getAudiencesList())) return false;
    if (getForward()
        != other.getForward()) return false;
    if (!getFromHeadersList()
        .equals(other.getFromHeadersList())) return false;
    if (!getFromParamsList()
        .equals(other.getFromParamsList())) return false;
    if (!getForwardPayloadHeader()
        .equals(other.getForwardPayloadHeader())) return false;
    if (!getPayloadInMetadata()
        .equals(other.getPayloadInMetadata())) return false;
    if (!getJwksSourceSpecifierCase().equals(other.getJwksSourceSpecifierCase())) return false;
    switch (jwksSourceSpecifierCase_) {
      case 3:
        if (!getRemoteJwks()
            .equals(other.getRemoteJwks())) return false;
        break;
      case 4:
        if (!getLocalJwks()
            .equals(other.getLocalJwks())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ISSUER_FIELD_NUMBER;
    hash = (53 * hash) + getIssuer().hashCode();
    if (getAudiencesCount() > 0) {
      hash = (37 * hash) + AUDIENCES_FIELD_NUMBER;
      hash = (53 * hash) + getAudiencesList().hashCode();
    }
    hash = (37 * hash) + FORWARD_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getForward());
    if (getFromHeadersCount() > 0) {
      hash = (37 * hash) + FROM_HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + getFromHeadersList().hashCode();
    }
    if (getFromParamsCount() > 0) {
      hash = (37 * hash) + FROM_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getFromParamsList().hashCode();
    }
    hash = (37 * hash) + FORWARD_PAYLOAD_HEADER_FIELD_NUMBER;
    hash = (53 * hash) + getForwardPayloadHeader().hashCode();
    hash = (37 * hash) + PAYLOAD_IN_METADATA_FIELD_NUMBER;
    hash = (53 * hash) + getPayloadInMetadata().hashCode();
    switch (jwksSourceSpecifierCase_) {
      case 3:
        hash = (37 * hash) + REMOTE_JWKS_FIELD_NUMBER;
        hash = (53 * hash) + getRemoteJwks().hashCode();
        break;
      case 4:
        hash = (37 * hash) + LOCAL_JWKS_FIELD_NUMBER;
        hash = (53 * hash) + getLocalJwks().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Please see following for JWT authentication flow:
   * * `JSON Web Token (JWT) &lt;https://tools.ietf.org/html/rfc7519&gt;`_
   * * `The OAuth 2.0 Authorization Framework &lt;https://tools.ietf.org/html/rfc6749&gt;`_
   * * `OpenID Connect &lt;http://openid.net/connect&gt;`_
   * A JwtProvider message specifies how a JSON Web Token (JWT) can be verified. It specifies:
   * * issuer: the principal that issues the JWT. It has to match the one from the token.
   * * allowed audiences: the ones in the token have to be listed here.
   * * how to fetch public key JWKS to verify the token signature.
   * * how to extract JWT token in the request.
   * * how to pass successfully verified token payload.
   * Example:
   * .. code-block:: yaml
   *     issuer: https://example.com
   *     audiences:
   *     - bookstore_android.apps.googleusercontent.com
   *     - bookstore_web.apps.googleusercontent.com
   *     remote_jwks:
   *       http_uri:
   *         uri: https://example.com/.well-known/jwks.json
   *         cluster: example_jwks_cluster
   *       cache_duration:
   *         seconds: 300
   * [#next-free-field: 10]
   * </pre>
   *
   * Protobuf type {@code envoy.extensions.filters.http.jwt_authn.v3.JwtProvider}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:envoy.extensions.filters.http.jwt_authn.v3.JwtProvider)
      io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProviderOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ConfigProto.internal_static_envoy_extensions_filters_http_jwt_authn_v3_JwtProvider_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ConfigProto.internal_static_envoy_extensions_filters_http_jwt_authn_v3_JwtProvider_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider.class, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider.Builder.class);
    }

    // Construct using io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getFromHeadersFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      issuer_ = "";

      audiences_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      forward_ = false;

      if (fromHeadersBuilder_ == null) {
        fromHeaders_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        fromHeadersBuilder_.clear();
      }
      fromParams_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      forwardPayloadHeader_ = "";

      payloadInMetadata_ = "";

      jwksSourceSpecifierCase_ = 0;
      jwksSourceSpecifier_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ConfigProto.internal_static_envoy_extensions_filters_http_jwt_authn_v3_JwtProvider_descriptor;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider getDefaultInstanceForType() {
      return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider.getDefaultInstance();
    }

    @java.lang.Override
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider build() {
      io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider buildPartial() {
      io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider result = new io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider(this);
      int from_bitField0_ = bitField0_;
      result.issuer_ = issuer_;
      if (((bitField0_ & 0x00000001) != 0)) {
        audiences_ = audiences_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.audiences_ = audiences_;
      if (jwksSourceSpecifierCase_ == 3) {
        if (remoteJwksBuilder_ == null) {
          result.jwksSourceSpecifier_ = jwksSourceSpecifier_;
        } else {
          result.jwksSourceSpecifier_ = remoteJwksBuilder_.build();
        }
      }
      if (jwksSourceSpecifierCase_ == 4) {
        if (localJwksBuilder_ == null) {
          result.jwksSourceSpecifier_ = jwksSourceSpecifier_;
        } else {
          result.jwksSourceSpecifier_ = localJwksBuilder_.build();
        }
      }
      result.forward_ = forward_;
      if (fromHeadersBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          fromHeaders_ = java.util.Collections.unmodifiableList(fromHeaders_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.fromHeaders_ = fromHeaders_;
      } else {
        result.fromHeaders_ = fromHeadersBuilder_.build();
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        fromParams_ = fromParams_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.fromParams_ = fromParams_;
      result.forwardPayloadHeader_ = forwardPayloadHeader_;
      result.payloadInMetadata_ = payloadInMetadata_;
      result.jwksSourceSpecifierCase_ = jwksSourceSpecifierCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider) {
        return mergeFrom((io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider other) {
      if (other == io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider.getDefaultInstance()) return this;
      if (!other.getIssuer().isEmpty()) {
        issuer_ = other.issuer_;
        onChanged();
      }
      if (!other.audiences_.isEmpty()) {
        if (audiences_.isEmpty()) {
          audiences_ = other.audiences_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureAudiencesIsMutable();
          audiences_.addAll(other.audiences_);
        }
        onChanged();
      }
      if (other.getForward() != false) {
        setForward(other.getForward());
      }
      if (fromHeadersBuilder_ == null) {
        if (!other.fromHeaders_.isEmpty()) {
          if (fromHeaders_.isEmpty()) {
            fromHeaders_ = other.fromHeaders_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureFromHeadersIsMutable();
            fromHeaders_.addAll(other.fromHeaders_);
          }
          onChanged();
        }
      } else {
        if (!other.fromHeaders_.isEmpty()) {
          if (fromHeadersBuilder_.isEmpty()) {
            fromHeadersBuilder_.dispose();
            fromHeadersBuilder_ = null;
            fromHeaders_ = other.fromHeaders_;
            bitField0_ = (bitField0_ & ~0x00000002);
            fromHeadersBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getFromHeadersFieldBuilder() : null;
          } else {
            fromHeadersBuilder_.addAllMessages(other.fromHeaders_);
          }
        }
      }
      if (!other.fromParams_.isEmpty()) {
        if (fromParams_.isEmpty()) {
          fromParams_ = other.fromParams_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureFromParamsIsMutable();
          fromParams_.addAll(other.fromParams_);
        }
        onChanged();
      }
      if (!other.getForwardPayloadHeader().isEmpty()) {
        forwardPayloadHeader_ = other.forwardPayloadHeader_;
        onChanged();
      }
      if (!other.getPayloadInMetadata().isEmpty()) {
        payloadInMetadata_ = other.payloadInMetadata_;
        onChanged();
      }
      switch (other.getJwksSourceSpecifierCase()) {
        case REMOTE_JWKS: {
          mergeRemoteJwks(other.getRemoteJwks());
          break;
        }
        case LOCAL_JWKS: {
          mergeLocalJwks(other.getLocalJwks());
          break;
        }
        case JWKSSOURCESPECIFIER_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int jwksSourceSpecifierCase_ = 0;
    private java.lang.Object jwksSourceSpecifier_;
    public JwksSourceSpecifierCase
        getJwksSourceSpecifierCase() {
      return JwksSourceSpecifierCase.forNumber(
          jwksSourceSpecifierCase_);
    }

    public Builder clearJwksSourceSpecifier() {
      jwksSourceSpecifierCase_ = 0;
      jwksSourceSpecifier_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object issuer_ = "";
    /**
     * <pre>
     * Specify the `principal &lt;https://tools.ietf.org/html/rfc7519#section-4.1.1&gt;`_ that issued
     * the JWT, usually a URL or an email address.
     * Example: https://securetoken.google.com
     * Example: 1234567-compute&#64;developer.gserviceaccount.com
     * </pre>
     *
     * <code>string issuer = 1 [(.validate.rules) = { ... }</code>
     */
    public java.lang.String getIssuer() {
      java.lang.Object ref = issuer_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        issuer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Specify the `principal &lt;https://tools.ietf.org/html/rfc7519#section-4.1.1&gt;`_ that issued
     * the JWT, usually a URL or an email address.
     * Example: https://securetoken.google.com
     * Example: 1234567-compute&#64;developer.gserviceaccount.com
     * </pre>
     *
     * <code>string issuer = 1 [(.validate.rules) = { ... }</code>
     */
    public com.google.protobuf.ByteString
        getIssuerBytes() {
      java.lang.Object ref = issuer_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        issuer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Specify the `principal &lt;https://tools.ietf.org/html/rfc7519#section-4.1.1&gt;`_ that issued
     * the JWT, usually a URL or an email address.
     * Example: https://securetoken.google.com
     * Example: 1234567-compute&#64;developer.gserviceaccount.com
     * </pre>
     *
     * <code>string issuer = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder setIssuer(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      issuer_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specify the `principal &lt;https://tools.ietf.org/html/rfc7519#section-4.1.1&gt;`_ that issued
     * the JWT, usually a URL or an email address.
     * Example: https://securetoken.google.com
     * Example: 1234567-compute&#64;developer.gserviceaccount.com
     * </pre>
     *
     * <code>string issuer = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder clearIssuer() {
      
      issuer_ = getDefaultInstance().getIssuer();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specify the `principal &lt;https://tools.ietf.org/html/rfc7519#section-4.1.1&gt;`_ that issued
     * the JWT, usually a URL or an email address.
     * Example: https://securetoken.google.com
     * Example: 1234567-compute&#64;developer.gserviceaccount.com
     * </pre>
     *
     * <code>string issuer = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder setIssuerBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      issuer_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList audiences_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureAudiencesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        audiences_ = new com.google.protobuf.LazyStringArrayList(audiences_);
        bitField0_ |= 0x00000001;
       }
    }
    /**
     * <pre>
     * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
     * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
     * will not check audiences in the token.
     * Example:
     * .. code-block:: yaml
     *     audiences:
     *     - bookstore_android.apps.googleusercontent.com
     *     - bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getAudiencesList() {
      return audiences_.getUnmodifiableView();
    }
    /**
     * <pre>
     * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
     * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
     * will not check audiences in the token.
     * Example:
     * .. code-block:: yaml
     *     audiences:
     *     - bookstore_android.apps.googleusercontent.com
     *     - bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     */
    public int getAudiencesCount() {
      return audiences_.size();
    }
    /**
     * <pre>
     * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
     * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
     * will not check audiences in the token.
     * Example:
     * .. code-block:: yaml
     *     audiences:
     *     - bookstore_android.apps.googleusercontent.com
     *     - bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     */
    public java.lang.String getAudiences(int index) {
      return audiences_.get(index);
    }
    /**
     * <pre>
     * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
     * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
     * will not check audiences in the token.
     * Example:
     * .. code-block:: yaml
     *     audiences:
     *     - bookstore_android.apps.googleusercontent.com
     *     - bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     */
    public com.google.protobuf.ByteString
        getAudiencesBytes(int index) {
      return audiences_.getByteString(index);
    }
    /**
     * <pre>
     * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
     * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
     * will not check audiences in the token.
     * Example:
     * .. code-block:: yaml
     *     audiences:
     *     - bookstore_android.apps.googleusercontent.com
     *     - bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     */
    public Builder setAudiences(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureAudiencesIsMutable();
      audiences_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
     * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
     * will not check audiences in the token.
     * Example:
     * .. code-block:: yaml
     *     audiences:
     *     - bookstore_android.apps.googleusercontent.com
     *     - bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     */
    public Builder addAudiences(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureAudiencesIsMutable();
      audiences_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
     * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
     * will not check audiences in the token.
     * Example:
     * .. code-block:: yaml
     *     audiences:
     *     - bookstore_android.apps.googleusercontent.com
     *     - bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     */
    public Builder addAllAudiences(
        java.lang.Iterable<java.lang.String> values) {
      ensureAudiencesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, audiences_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
     * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
     * will not check audiences in the token.
     * Example:
     * .. code-block:: yaml
     *     audiences:
     *     - bookstore_android.apps.googleusercontent.com
     *     - bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     */
    public Builder clearAudiences() {
      audiences_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
     * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
     * will not check audiences in the token.
     * Example:
     * .. code-block:: yaml
     *     audiences:
     *     - bookstore_android.apps.googleusercontent.com
     *     - bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     */
    public Builder addAudiencesBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureAudiencesIsMutable();
      audiences_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwksOrBuilder> remoteJwksBuilder_;
    /**
     * <pre>
     * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
     * URI and how the fetched JWKS should be cached.
     * Example:
     * .. code-block:: yaml
     *    remote_jwks:
     *      http_uri:
     *        uri: https://www.googleapis.com/oauth2/v1/certs
     *        cluster: jwt.www.googleapis.com|443
     *      cache_duration:
     *        seconds: 300
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks remote_jwks = 3;</code>
     */
    public boolean hasRemoteJwks() {
      return jwksSourceSpecifierCase_ == 3;
    }
    /**
     * <pre>
     * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
     * URI and how the fetched JWKS should be cached.
     * Example:
     * .. code-block:: yaml
     *    remote_jwks:
     *      http_uri:
     *        uri: https://www.googleapis.com/oauth2/v1/certs
     *        cluster: jwt.www.googleapis.com|443
     *      cache_duration:
     *        seconds: 300
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks remote_jwks = 3;</code>
     */
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks getRemoteJwks() {
      if (remoteJwksBuilder_ == null) {
        if (jwksSourceSpecifierCase_ == 3) {
          return (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks) jwksSourceSpecifier_;
        }
        return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks.getDefaultInstance();
      } else {
        if (jwksSourceSpecifierCase_ == 3) {
          return remoteJwksBuilder_.getMessage();
        }
        return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
     * URI and how the fetched JWKS should be cached.
     * Example:
     * .. code-block:: yaml
     *    remote_jwks:
     *      http_uri:
     *        uri: https://www.googleapis.com/oauth2/v1/certs
     *        cluster: jwt.www.googleapis.com|443
     *      cache_duration:
     *        seconds: 300
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks remote_jwks = 3;</code>
     */
    public Builder setRemoteJwks(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks value) {
      if (remoteJwksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jwksSourceSpecifier_ = value;
        onChanged();
      } else {
        remoteJwksBuilder_.setMessage(value);
      }
      jwksSourceSpecifierCase_ = 3;
      return this;
    }
    /**
     * <pre>
     * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
     * URI and how the fetched JWKS should be cached.
     * Example:
     * .. code-block:: yaml
     *    remote_jwks:
     *      http_uri:
     *        uri: https://www.googleapis.com/oauth2/v1/certs
     *        cluster: jwt.www.googleapis.com|443
     *      cache_duration:
     *        seconds: 300
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks remote_jwks = 3;</code>
     */
    public Builder setRemoteJwks(
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks.Builder builderForValue) {
      if (remoteJwksBuilder_ == null) {
        jwksSourceSpecifier_ = builderForValue.build();
        onChanged();
      } else {
        remoteJwksBuilder_.setMessage(builderForValue.build());
      }
      jwksSourceSpecifierCase_ = 3;
      return this;
    }
    /**
     * <pre>
     * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
     * URI and how the fetched JWKS should be cached.
     * Example:
     * .. code-block:: yaml
     *    remote_jwks:
     *      http_uri:
     *        uri: https://www.googleapis.com/oauth2/v1/certs
     *        cluster: jwt.www.googleapis.com|443
     *      cache_duration:
     *        seconds: 300
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks remote_jwks = 3;</code>
     */
    public Builder mergeRemoteJwks(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks value) {
      if (remoteJwksBuilder_ == null) {
        if (jwksSourceSpecifierCase_ == 3 &&
            jwksSourceSpecifier_ != io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks.getDefaultInstance()) {
          jwksSourceSpecifier_ = io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks.newBuilder((io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks) jwksSourceSpecifier_)
              .mergeFrom(value).buildPartial();
        } else {
          jwksSourceSpecifier_ = value;
        }
        onChanged();
      } else {
        if (jwksSourceSpecifierCase_ == 3) {
          remoteJwksBuilder_.mergeFrom(value);
        }
        remoteJwksBuilder_.setMessage(value);
      }
      jwksSourceSpecifierCase_ = 3;
      return this;
    }
    /**
     * <pre>
     * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
     * URI and how the fetched JWKS should be cached.
     * Example:
     * .. code-block:: yaml
     *    remote_jwks:
     *      http_uri:
     *        uri: https://www.googleapis.com/oauth2/v1/certs
     *        cluster: jwt.www.googleapis.com|443
     *      cache_duration:
     *        seconds: 300
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks remote_jwks = 3;</code>
     */
    public Builder clearRemoteJwks() {
      if (remoteJwksBuilder_ == null) {
        if (jwksSourceSpecifierCase_ == 3) {
          jwksSourceSpecifierCase_ = 0;
          jwksSourceSpecifier_ = null;
          onChanged();
        }
      } else {
        if (jwksSourceSpecifierCase_ == 3) {
          jwksSourceSpecifierCase_ = 0;
          jwksSourceSpecifier_ = null;
        }
        remoteJwksBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
     * URI and how the fetched JWKS should be cached.
     * Example:
     * .. code-block:: yaml
     *    remote_jwks:
     *      http_uri:
     *        uri: https://www.googleapis.com/oauth2/v1/certs
     *        cluster: jwt.www.googleapis.com|443
     *      cache_duration:
     *        seconds: 300
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks remote_jwks = 3;</code>
     */
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks.Builder getRemoteJwksBuilder() {
      return getRemoteJwksFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
     * URI and how the fetched JWKS should be cached.
     * Example:
     * .. code-block:: yaml
     *    remote_jwks:
     *      http_uri:
     *        uri: https://www.googleapis.com/oauth2/v1/certs
     *        cluster: jwt.www.googleapis.com|443
     *      cache_duration:
     *        seconds: 300
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks remote_jwks = 3;</code>
     */
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwksOrBuilder getRemoteJwksOrBuilder() {
      if ((jwksSourceSpecifierCase_ == 3) && (remoteJwksBuilder_ != null)) {
        return remoteJwksBuilder_.getMessageOrBuilder();
      } else {
        if (jwksSourceSpecifierCase_ == 3) {
          return (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks) jwksSourceSpecifier_;
        }
        return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
     * URI and how the fetched JWKS should be cached.
     * Example:
     * .. code-block:: yaml
     *    remote_jwks:
     *      http_uri:
     *        uri: https://www.googleapis.com/oauth2/v1/certs
     *        cluster: jwt.www.googleapis.com|443
     *      cache_duration:
     *        seconds: 300
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks remote_jwks = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwksOrBuilder> 
        getRemoteJwksFieldBuilder() {
      if (remoteJwksBuilder_ == null) {
        if (!(jwksSourceSpecifierCase_ == 3)) {
          jwksSourceSpecifier_ = io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks.getDefaultInstance();
        }
        remoteJwksBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwksOrBuilder>(
                (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks) jwksSourceSpecifier_,
                getParentForChildren(),
                isClean());
        jwksSourceSpecifier_ = null;
      }
      jwksSourceSpecifierCase_ = 3;
      onChanged();;
      return remoteJwksBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v3.DataSource, io.envoyproxy.envoy.config.core.v3.DataSource.Builder, io.envoyproxy.envoy.config.core.v3.DataSourceOrBuilder> localJwksBuilder_;
    /**
     * <pre>
     * JWKS is in local data source. It could be either in a local file or embedded in the
     * inline_string.
     * Example: local file
     * .. code-block:: yaml
     *    local_jwks:
     *      filename: /etc/envoy/jwks/jwks1.txt
     * Example: inline_string
     * .. code-block:: yaml
     *    local_jwks:
     *      inline_string: ACADADADADA
     * </pre>
     *
     * <code>.envoy.config.core.v3.DataSource local_jwks = 4;</code>
     */
    public boolean hasLocalJwks() {
      return jwksSourceSpecifierCase_ == 4;
    }
    /**
     * <pre>
     * JWKS is in local data source. It could be either in a local file or embedded in the
     * inline_string.
     * Example: local file
     * .. code-block:: yaml
     *    local_jwks:
     *      filename: /etc/envoy/jwks/jwks1.txt
     * Example: inline_string
     * .. code-block:: yaml
     *    local_jwks:
     *      inline_string: ACADADADADA
     * </pre>
     *
     * <code>.envoy.config.core.v3.DataSource local_jwks = 4;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.DataSource getLocalJwks() {
      if (localJwksBuilder_ == null) {
        if (jwksSourceSpecifierCase_ == 4) {
          return (io.envoyproxy.envoy.config.core.v3.DataSource) jwksSourceSpecifier_;
        }
        return io.envoyproxy.envoy.config.core.v3.DataSource.getDefaultInstance();
      } else {
        if (jwksSourceSpecifierCase_ == 4) {
          return localJwksBuilder_.getMessage();
        }
        return io.envoyproxy.envoy.config.core.v3.DataSource.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * JWKS is in local data source. It could be either in a local file or embedded in the
     * inline_string.
     * Example: local file
     * .. code-block:: yaml
     *    local_jwks:
     *      filename: /etc/envoy/jwks/jwks1.txt
     * Example: inline_string
     * .. code-block:: yaml
     *    local_jwks:
     *      inline_string: ACADADADADA
     * </pre>
     *
     * <code>.envoy.config.core.v3.DataSource local_jwks = 4;</code>
     */
    public Builder setLocalJwks(io.envoyproxy.envoy.config.core.v3.DataSource value) {
      if (localJwksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jwksSourceSpecifier_ = value;
        onChanged();
      } else {
        localJwksBuilder_.setMessage(value);
      }
      jwksSourceSpecifierCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * JWKS is in local data source. It could be either in a local file or embedded in the
     * inline_string.
     * Example: local file
     * .. code-block:: yaml
     *    local_jwks:
     *      filename: /etc/envoy/jwks/jwks1.txt
     * Example: inline_string
     * .. code-block:: yaml
     *    local_jwks:
     *      inline_string: ACADADADADA
     * </pre>
     *
     * <code>.envoy.config.core.v3.DataSource local_jwks = 4;</code>
     */
    public Builder setLocalJwks(
        io.envoyproxy.envoy.config.core.v3.DataSource.Builder builderForValue) {
      if (localJwksBuilder_ == null) {
        jwksSourceSpecifier_ = builderForValue.build();
        onChanged();
      } else {
        localJwksBuilder_.setMessage(builderForValue.build());
      }
      jwksSourceSpecifierCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * JWKS is in local data source. It could be either in a local file or embedded in the
     * inline_string.
     * Example: local file
     * .. code-block:: yaml
     *    local_jwks:
     *      filename: /etc/envoy/jwks/jwks1.txt
     * Example: inline_string
     * .. code-block:: yaml
     *    local_jwks:
     *      inline_string: ACADADADADA
     * </pre>
     *
     * <code>.envoy.config.core.v3.DataSource local_jwks = 4;</code>
     */
    public Builder mergeLocalJwks(io.envoyproxy.envoy.config.core.v3.DataSource value) {
      if (localJwksBuilder_ == null) {
        if (jwksSourceSpecifierCase_ == 4 &&
            jwksSourceSpecifier_ != io.envoyproxy.envoy.config.core.v3.DataSource.getDefaultInstance()) {
          jwksSourceSpecifier_ = io.envoyproxy.envoy.config.core.v3.DataSource.newBuilder((io.envoyproxy.envoy.config.core.v3.DataSource) jwksSourceSpecifier_)
              .mergeFrom(value).buildPartial();
        } else {
          jwksSourceSpecifier_ = value;
        }
        onChanged();
      } else {
        if (jwksSourceSpecifierCase_ == 4) {
          localJwksBuilder_.mergeFrom(value);
        }
        localJwksBuilder_.setMessage(value);
      }
      jwksSourceSpecifierCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * JWKS is in local data source. It could be either in a local file or embedded in the
     * inline_string.
     * Example: local file
     * .. code-block:: yaml
     *    local_jwks:
     *      filename: /etc/envoy/jwks/jwks1.txt
     * Example: inline_string
     * .. code-block:: yaml
     *    local_jwks:
     *      inline_string: ACADADADADA
     * </pre>
     *
     * <code>.envoy.config.core.v3.DataSource local_jwks = 4;</code>
     */
    public Builder clearLocalJwks() {
      if (localJwksBuilder_ == null) {
        if (jwksSourceSpecifierCase_ == 4) {
          jwksSourceSpecifierCase_ = 0;
          jwksSourceSpecifier_ = null;
          onChanged();
        }
      } else {
        if (jwksSourceSpecifierCase_ == 4) {
          jwksSourceSpecifierCase_ = 0;
          jwksSourceSpecifier_ = null;
        }
        localJwksBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * JWKS is in local data source. It could be either in a local file or embedded in the
     * inline_string.
     * Example: local file
     * .. code-block:: yaml
     *    local_jwks:
     *      filename: /etc/envoy/jwks/jwks1.txt
     * Example: inline_string
     * .. code-block:: yaml
     *    local_jwks:
     *      inline_string: ACADADADADA
     * </pre>
     *
     * <code>.envoy.config.core.v3.DataSource local_jwks = 4;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.DataSource.Builder getLocalJwksBuilder() {
      return getLocalJwksFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * JWKS is in local data source. It could be either in a local file or embedded in the
     * inline_string.
     * Example: local file
     * .. code-block:: yaml
     *    local_jwks:
     *      filename: /etc/envoy/jwks/jwks1.txt
     * Example: inline_string
     * .. code-block:: yaml
     *    local_jwks:
     *      inline_string: ACADADADADA
     * </pre>
     *
     * <code>.envoy.config.core.v3.DataSource local_jwks = 4;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.DataSourceOrBuilder getLocalJwksOrBuilder() {
      if ((jwksSourceSpecifierCase_ == 4) && (localJwksBuilder_ != null)) {
        return localJwksBuilder_.getMessageOrBuilder();
      } else {
        if (jwksSourceSpecifierCase_ == 4) {
          return (io.envoyproxy.envoy.config.core.v3.DataSource) jwksSourceSpecifier_;
        }
        return io.envoyproxy.envoy.config.core.v3.DataSource.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * JWKS is in local data source. It could be either in a local file or embedded in the
     * inline_string.
     * Example: local file
     * .. code-block:: yaml
     *    local_jwks:
     *      filename: /etc/envoy/jwks/jwks1.txt
     * Example: inline_string
     * .. code-block:: yaml
     *    local_jwks:
     *      inline_string: ACADADADADA
     * </pre>
     *
     * <code>.envoy.config.core.v3.DataSource local_jwks = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v3.DataSource, io.envoyproxy.envoy.config.core.v3.DataSource.Builder, io.envoyproxy.envoy.config.core.v3.DataSourceOrBuilder> 
        getLocalJwksFieldBuilder() {
      if (localJwksBuilder_ == null) {
        if (!(jwksSourceSpecifierCase_ == 4)) {
          jwksSourceSpecifier_ = io.envoyproxy.envoy.config.core.v3.DataSource.getDefaultInstance();
        }
        localJwksBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.envoyproxy.envoy.config.core.v3.DataSource, io.envoyproxy.envoy.config.core.v3.DataSource.Builder, io.envoyproxy.envoy.config.core.v3.DataSourceOrBuilder>(
                (io.envoyproxy.envoy.config.core.v3.DataSource) jwksSourceSpecifier_,
                getParentForChildren(),
                isClean());
        jwksSourceSpecifier_ = null;
      }
      jwksSourceSpecifierCase_ = 4;
      onChanged();;
      return localJwksBuilder_;
    }

    private boolean forward_ ;
    /**
     * <pre>
     * If false, the JWT is removed in the request after a success verification. If true, the JWT is
     * not removed in the request. Default value is false.
     * </pre>
     *
     * <code>bool forward = 5;</code>
     */
    public boolean getForward() {
      return forward_;
    }
    /**
     * <pre>
     * If false, the JWT is removed in the request after a success verification. If true, the JWT is
     * not removed in the request. Default value is false.
     * </pre>
     *
     * <code>bool forward = 5;</code>
     */
    public Builder setForward(boolean value) {
      
      forward_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If false, the JWT is removed in the request after a success verification. If true, the JWT is
     * not removed in the request. Default value is false.
     * </pre>
     *
     * <code>bool forward = 5;</code>
     */
    public Builder clearForward() {
      
      forward_ = false;
      onChanged();
      return this;
    }

    private java.util.List<io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader> fromHeaders_ =
      java.util.Collections.emptyList();
    private void ensureFromHeadersIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        fromHeaders_ = new java.util.ArrayList<io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader>(fromHeaders_);
        bitField0_ |= 0x00000002;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeaderOrBuilder> fromHeadersBuilder_;

    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     * If no explicit location is specified, the following default locations are tried in order:
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *    Authorization: Bearer &lt;token&gt;.
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     * .. code-block:: yaml
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     * can be used to extract token from header::
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
     */
    public java.util.List<io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader> getFromHeadersList() {
      if (fromHeadersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fromHeaders_);
      } else {
        return fromHeadersBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     * If no explicit location is specified, the following default locations are tried in order:
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *    Authorization: Bearer &lt;token&gt;.
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     * .. code-block:: yaml
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     * can be used to extract token from header::
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
     */
    public int getFromHeadersCount() {
      if (fromHeadersBuilder_ == null) {
        return fromHeaders_.size();
      } else {
        return fromHeadersBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     * If no explicit location is specified, the following default locations are tried in order:
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *    Authorization: Bearer &lt;token&gt;.
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     * .. code-block:: yaml
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     * can be used to extract token from header::
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
     */
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader getFromHeaders(int index) {
      if (fromHeadersBuilder_ == null) {
        return fromHeaders_.get(index);
      } else {
        return fromHeadersBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     * If no explicit location is specified, the following default locations are tried in order:
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *    Authorization: Bearer &lt;token&gt;.
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     * .. code-block:: yaml
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     * can be used to extract token from header::
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
     */
    public Builder setFromHeaders(
        int index, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader value) {
      if (fromHeadersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFromHeadersIsMutable();
        fromHeaders_.set(index, value);
        onChanged();
      } else {
        fromHeadersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     * If no explicit location is specified, the following default locations are tried in order:
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *    Authorization: Bearer &lt;token&gt;.
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     * .. code-block:: yaml
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     * can be used to extract token from header::
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
     */
    public Builder setFromHeaders(
        int index, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader.Builder builderForValue) {
      if (fromHeadersBuilder_ == null) {
        ensureFromHeadersIsMutable();
        fromHeaders_.set(index, builderForValue.build());
        onChanged();
      } else {
        fromHeadersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     * If no explicit location is specified, the following default locations are tried in order:
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *    Authorization: Bearer &lt;token&gt;.
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     * .. code-block:: yaml
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     * can be used to extract token from header::
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
     */
    public Builder addFromHeaders(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader value) {
      if (fromHeadersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFromHeadersIsMutable();
        fromHeaders_.add(value);
        onChanged();
      } else {
        fromHeadersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     * If no explicit location is specified, the following default locations are tried in order:
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *    Authorization: Bearer &lt;token&gt;.
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     * .. code-block:: yaml
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     * can be used to extract token from header::
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
     */
    public Builder addFromHeaders(
        int index, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader value) {
      if (fromHeadersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFromHeadersIsMutable();
        fromHeaders_.add(index, value);
        onChanged();
      } else {
        fromHeadersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     * If no explicit location is specified, the following default locations are tried in order:
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *    Authorization: Bearer &lt;token&gt;.
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     * .. code-block:: yaml
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     * can be used to extract token from header::
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
     */
    public Builder addFromHeaders(
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader.Builder builderForValue) {
      if (fromHeadersBuilder_ == null) {
        ensureFromHeadersIsMutable();
        fromHeaders_.add(builderForValue.build());
        onChanged();
      } else {
        fromHeadersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     * If no explicit location is specified, the following default locations are tried in order:
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *    Authorization: Bearer &lt;token&gt;.
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     * .. code-block:: yaml
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     * can be used to extract token from header::
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
     */
    public Builder addFromHeaders(
        int index, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader.Builder builderForValue) {
      if (fromHeadersBuilder_ == null) {
        ensureFromHeadersIsMutable();
        fromHeaders_.add(index, builderForValue.build());
        onChanged();
      } else {
        fromHeadersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     * If no explicit location is specified, the following default locations are tried in order:
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *    Authorization: Bearer &lt;token&gt;.
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     * .. code-block:: yaml
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     * can be used to extract token from header::
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
     */
    public Builder addAllFromHeaders(
        java.lang.Iterable<? extends io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader> values) {
      if (fromHeadersBuilder_ == null) {
        ensureFromHeadersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, fromHeaders_);
        onChanged();
      } else {
        fromHeadersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     * If no explicit location is specified, the following default locations are tried in order:
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *    Authorization: Bearer &lt;token&gt;.
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     * .. code-block:: yaml
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     * can be used to extract token from header::
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
     */
    public Builder clearFromHeaders() {
      if (fromHeadersBuilder_ == null) {
        fromHeaders_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        fromHeadersBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     * If no explicit location is specified, the following default locations are tried in order:
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *    Authorization: Bearer &lt;token&gt;.
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     * .. code-block:: yaml
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     * can be used to extract token from header::
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
     */
    public Builder removeFromHeaders(int index) {
      if (fromHeadersBuilder_ == null) {
        ensureFromHeadersIsMutable();
        fromHeaders_.remove(index);
        onChanged();
      } else {
        fromHeadersBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     * If no explicit location is specified, the following default locations are tried in order:
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *    Authorization: Bearer &lt;token&gt;.
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     * .. code-block:: yaml
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     * can be used to extract token from header::
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
     */
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader.Builder getFromHeadersBuilder(
        int index) {
      return getFromHeadersFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     * If no explicit location is specified, the following default locations are tried in order:
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *    Authorization: Bearer &lt;token&gt;.
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     * .. code-block:: yaml
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     * can be used to extract token from header::
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
     */
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeaderOrBuilder getFromHeadersOrBuilder(
        int index) {
      if (fromHeadersBuilder_ == null) {
        return fromHeaders_.get(index);  } else {
        return fromHeadersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     * If no explicit location is specified, the following default locations are tried in order:
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *    Authorization: Bearer &lt;token&gt;.
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     * .. code-block:: yaml
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     * can be used to extract token from header::
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
     */
    public java.util.List<? extends io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeaderOrBuilder> 
         getFromHeadersOrBuilderList() {
      if (fromHeadersBuilder_ != null) {
        return fromHeadersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fromHeaders_);
      }
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     * If no explicit location is specified, the following default locations are tried in order:
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *    Authorization: Bearer &lt;token&gt;.
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     * .. code-block:: yaml
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     * can be used to extract token from header::
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
     */
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader.Builder addFromHeadersBuilder() {
      return getFromHeadersFieldBuilder().addBuilder(
          io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader.getDefaultInstance());
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     * If no explicit location is specified, the following default locations are tried in order:
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *    Authorization: Bearer &lt;token&gt;.
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     * .. code-block:: yaml
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     * can be used to extract token from header::
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
     */
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader.Builder addFromHeadersBuilder(
        int index) {
      return getFromHeadersFieldBuilder().addBuilder(
          index, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader.getDefaultInstance());
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     * If no explicit location is specified, the following default locations are tried in order:
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *    Authorization: Bearer &lt;token&gt;.
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     * .. code-block:: yaml
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     * can be used to extract token from header::
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.JwtHeader from_headers = 6;</code>
     */
    public java.util.List<io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader.Builder> 
         getFromHeadersBuilderList() {
      return getFromHeadersFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeaderOrBuilder> 
        getFromHeadersFieldBuilder() {
      if (fromHeadersBuilder_ == null) {
        fromHeadersBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeader.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtHeaderOrBuilder>(
                fromHeaders_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        fromHeaders_ = null;
      }
      return fromHeadersBuilder_;
    }

    private com.google.protobuf.LazyStringList fromParams_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureFromParamsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        fromParams_ = new com.google.protobuf.LazyStringArrayList(fromParams_);
        bitField0_ |= 0x00000004;
       }
    }
    /**
     * <pre>
     * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
     * For example, if config is:
     * .. code-block:: yaml
     *   from_params:
     *   - jwt_token
     * The JWT format in query parameter is::
     *    /path?jwt_token=&lt;JWT&gt;
     * </pre>
     *
     * <code>repeated string from_params = 7;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getFromParamsList() {
      return fromParams_.getUnmodifiableView();
    }
    /**
     * <pre>
     * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
     * For example, if config is:
     * .. code-block:: yaml
     *   from_params:
     *   - jwt_token
     * The JWT format in query parameter is::
     *    /path?jwt_token=&lt;JWT&gt;
     * </pre>
     *
     * <code>repeated string from_params = 7;</code>
     */
    public int getFromParamsCount() {
      return fromParams_.size();
    }
    /**
     * <pre>
     * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
     * For example, if config is:
     * .. code-block:: yaml
     *   from_params:
     *   - jwt_token
     * The JWT format in query parameter is::
     *    /path?jwt_token=&lt;JWT&gt;
     * </pre>
     *
     * <code>repeated string from_params = 7;</code>
     */
    public java.lang.String getFromParams(int index) {
      return fromParams_.get(index);
    }
    /**
     * <pre>
     * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
     * For example, if config is:
     * .. code-block:: yaml
     *   from_params:
     *   - jwt_token
     * The JWT format in query parameter is::
     *    /path?jwt_token=&lt;JWT&gt;
     * </pre>
     *
     * <code>repeated string from_params = 7;</code>
     */
    public com.google.protobuf.ByteString
        getFromParamsBytes(int index) {
      return fromParams_.getByteString(index);
    }
    /**
     * <pre>
     * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
     * For example, if config is:
     * .. code-block:: yaml
     *   from_params:
     *   - jwt_token
     * The JWT format in query parameter is::
     *    /path?jwt_token=&lt;JWT&gt;
     * </pre>
     *
     * <code>repeated string from_params = 7;</code>
     */
    public Builder setFromParams(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureFromParamsIsMutable();
      fromParams_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
     * For example, if config is:
     * .. code-block:: yaml
     *   from_params:
     *   - jwt_token
     * The JWT format in query parameter is::
     *    /path?jwt_token=&lt;JWT&gt;
     * </pre>
     *
     * <code>repeated string from_params = 7;</code>
     */
    public Builder addFromParams(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureFromParamsIsMutable();
      fromParams_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
     * For example, if config is:
     * .. code-block:: yaml
     *   from_params:
     *   - jwt_token
     * The JWT format in query parameter is::
     *    /path?jwt_token=&lt;JWT&gt;
     * </pre>
     *
     * <code>repeated string from_params = 7;</code>
     */
    public Builder addAllFromParams(
        java.lang.Iterable<java.lang.String> values) {
      ensureFromParamsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, fromParams_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
     * For example, if config is:
     * .. code-block:: yaml
     *   from_params:
     *   - jwt_token
     * The JWT format in query parameter is::
     *    /path?jwt_token=&lt;JWT&gt;
     * </pre>
     *
     * <code>repeated string from_params = 7;</code>
     */
    public Builder clearFromParams() {
      fromParams_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
     * For example, if config is:
     * .. code-block:: yaml
     *   from_params:
     *   - jwt_token
     * The JWT format in query parameter is::
     *    /path?jwt_token=&lt;JWT&gt;
     * </pre>
     *
     * <code>repeated string from_params = 7;</code>
     */
    public Builder addFromParamsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureFromParamsIsMutable();
      fromParams_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object forwardPayloadHeader_ = "";
    /**
     * <pre>
     * This field specifies the header name to forward a successfully verified JWT payload to the
     * backend. The forwarded data is::
     *    base64url_encoded(jwt_payload_in_JSON)
     * If it is not specified, the payload will not be forwarded.
     * </pre>
     *
     * <code>string forward_payload_header = 8 [(.validate.rules) = { ... }</code>
     */
    public java.lang.String getForwardPayloadHeader() {
      java.lang.Object ref = forwardPayloadHeader_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        forwardPayloadHeader_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * This field specifies the header name to forward a successfully verified JWT payload to the
     * backend. The forwarded data is::
     *    base64url_encoded(jwt_payload_in_JSON)
     * If it is not specified, the payload will not be forwarded.
     * </pre>
     *
     * <code>string forward_payload_header = 8 [(.validate.rules) = { ... }</code>
     */
    public com.google.protobuf.ByteString
        getForwardPayloadHeaderBytes() {
      java.lang.Object ref = forwardPayloadHeader_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        forwardPayloadHeader_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * This field specifies the header name to forward a successfully verified JWT payload to the
     * backend. The forwarded data is::
     *    base64url_encoded(jwt_payload_in_JSON)
     * If it is not specified, the payload will not be forwarded.
     * </pre>
     *
     * <code>string forward_payload_header = 8 [(.validate.rules) = { ... }</code>
     */
    public Builder setForwardPayloadHeader(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      forwardPayloadHeader_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * This field specifies the header name to forward a successfully verified JWT payload to the
     * backend. The forwarded data is::
     *    base64url_encoded(jwt_payload_in_JSON)
     * If it is not specified, the payload will not be forwarded.
     * </pre>
     *
     * <code>string forward_payload_header = 8 [(.validate.rules) = { ... }</code>
     */
    public Builder clearForwardPayloadHeader() {
      
      forwardPayloadHeader_ = getDefaultInstance().getForwardPayloadHeader();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * This field specifies the header name to forward a successfully verified JWT payload to the
     * backend. The forwarded data is::
     *    base64url_encoded(jwt_payload_in_JSON)
     * If it is not specified, the payload will not be forwarded.
     * </pre>
     *
     * <code>string forward_payload_header = 8 [(.validate.rules) = { ... }</code>
     */
    public Builder setForwardPayloadHeaderBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      forwardPayloadHeader_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object payloadInMetadata_ = "";
    /**
     * <pre>
     * If non empty, successfully verified JWT payloads will be written to StreamInfo DynamicMetadata
     * in the format as: *namespace* is the jwt_authn filter name as **envoy.filters.http.jwt_authn**
     * The value is the *protobuf::Struct*. The value of this field will be the key for its *fields*
     * and the value is the *protobuf::Struct* converted from JWT JSON payload.
     * For example, if payload_in_metadata is *my_payload*:
     * .. code-block:: yaml
     *   envoy.filters.http.jwt_authn:
     *     my_payload:
     *       iss: https://example.com
     *       sub: test&#64;example.com
     *       aud: https://example.com
     *       exp: 1501281058
     * </pre>
     *
     * <code>string payload_in_metadata = 9;</code>
     */
    public java.lang.String getPayloadInMetadata() {
      java.lang.Object ref = payloadInMetadata_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        payloadInMetadata_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * If non empty, successfully verified JWT payloads will be written to StreamInfo DynamicMetadata
     * in the format as: *namespace* is the jwt_authn filter name as **envoy.filters.http.jwt_authn**
     * The value is the *protobuf::Struct*. The value of this field will be the key for its *fields*
     * and the value is the *protobuf::Struct* converted from JWT JSON payload.
     * For example, if payload_in_metadata is *my_payload*:
     * .. code-block:: yaml
     *   envoy.filters.http.jwt_authn:
     *     my_payload:
     *       iss: https://example.com
     *       sub: test&#64;example.com
     *       aud: https://example.com
     *       exp: 1501281058
     * </pre>
     *
     * <code>string payload_in_metadata = 9;</code>
     */
    public com.google.protobuf.ByteString
        getPayloadInMetadataBytes() {
      java.lang.Object ref = payloadInMetadata_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        payloadInMetadata_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * If non empty, successfully verified JWT payloads will be written to StreamInfo DynamicMetadata
     * in the format as: *namespace* is the jwt_authn filter name as **envoy.filters.http.jwt_authn**
     * The value is the *protobuf::Struct*. The value of this field will be the key for its *fields*
     * and the value is the *protobuf::Struct* converted from JWT JSON payload.
     * For example, if payload_in_metadata is *my_payload*:
     * .. code-block:: yaml
     *   envoy.filters.http.jwt_authn:
     *     my_payload:
     *       iss: https://example.com
     *       sub: test&#64;example.com
     *       aud: https://example.com
     *       exp: 1501281058
     * </pre>
     *
     * <code>string payload_in_metadata = 9;</code>
     */
    public Builder setPayloadInMetadata(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      payloadInMetadata_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non empty, successfully verified JWT payloads will be written to StreamInfo DynamicMetadata
     * in the format as: *namespace* is the jwt_authn filter name as **envoy.filters.http.jwt_authn**
     * The value is the *protobuf::Struct*. The value of this field will be the key for its *fields*
     * and the value is the *protobuf::Struct* converted from JWT JSON payload.
     * For example, if payload_in_metadata is *my_payload*:
     * .. code-block:: yaml
     *   envoy.filters.http.jwt_authn:
     *     my_payload:
     *       iss: https://example.com
     *       sub: test&#64;example.com
     *       aud: https://example.com
     *       exp: 1501281058
     * </pre>
     *
     * <code>string payload_in_metadata = 9;</code>
     */
    public Builder clearPayloadInMetadata() {
      
      payloadInMetadata_ = getDefaultInstance().getPayloadInMetadata();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non empty, successfully verified JWT payloads will be written to StreamInfo DynamicMetadata
     * in the format as: *namespace* is the jwt_authn filter name as **envoy.filters.http.jwt_authn**
     * The value is the *protobuf::Struct*. The value of this field will be the key for its *fields*
     * and the value is the *protobuf::Struct* converted from JWT JSON payload.
     * For example, if payload_in_metadata is *my_payload*:
     * .. code-block:: yaml
     *   envoy.filters.http.jwt_authn:
     *     my_payload:
     *       iss: https://example.com
     *       sub: test&#64;example.com
     *       aud: https://example.com
     *       exp: 1501281058
     * </pre>
     *
     * <code>string payload_in_metadata = 9;</code>
     */
    public Builder setPayloadInMetadataBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      payloadInMetadata_ = value;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:envoy.extensions.filters.http.jwt_authn.v3.JwtProvider)
  }

  // @@protoc_insertion_point(class_scope:envoy.extensions.filters.http.jwt_authn.v3.JwtProvider)
  private static final io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider();
  }

  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<JwtProvider>
      PARSER = new com.google.protobuf.AbstractParser<JwtProvider>() {
    @java.lang.Override
    public JwtProvider parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new JwtProvider(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<JwtProvider> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<JwtProvider> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

