/*
 * Decompiled with CFR 0.152.
 */
package io.arivera.oss.embedded.rabbitmq.helpers;

import io.arivera.oss.embedded.rabbitmq.EmbeddedRabbitMqConfig;
import io.arivera.oss.embedded.rabbitmq.bin.RabbitMqCommandException;
import io.arivera.oss.embedded.rabbitmq.bin.RabbitMqServer;
import io.arivera.oss.embedded.rabbitmq.helpers.StartupException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.listener.ProcessListener;
import org.zeroturnaround.exec.stream.LogOutputStream;

public class StartupHelper
implements Callable<Future<ProcessResult>> {
    public static final String BROKER_STARTUP_COMPLETED = ".*completed with \\d+ plugins.*";
    private final EmbeddedRabbitMqConfig config;

    public StartupHelper(EmbeddedRabbitMqConfig config) {
        this.config = config;
    }

    @Override
    public Future<ProcessResult> call() throws StartupException {
        PatternFinderOutputStream initializationWatcher = new PatternFinderOutputStream(BROKER_STARTUP_COMPLETED);
        PublishingProcessListener rabbitMqProcessListener = new PublishingProcessListener(new PublishingProcessListener.Subscriber[0]);
        rabbitMqProcessListener.addSubscriber(initializationWatcher);
        Future<ProcessResult> resultFuture = this.startProcess(initializationWatcher, rabbitMqProcessListener);
        this.waitForConfirmation(initializationWatcher);
        return resultFuture;
    }

    private Future<ProcessResult> startProcess(PatternFinderOutputStream initializationWatcher, PublishingProcessListener rabbitMqProcessListener) {
        Future<ProcessResult> resultFuture;
        try {
            resultFuture = new RabbitMqServer(this.config).writeOutputTo((OutputStream)((Object)initializationWatcher)).listeningToEventsWith(rabbitMqProcessListener).start();
        }
        catch (RabbitMqCommandException e) {
            throw new StartupException("Could not start RabbitMQ Server", e);
        }
        return resultFuture;
    }

    private void waitForConfirmation(PatternFinderOutputStream initializationWatcher) {
        long timeout = this.config.getRabbitMqServerInitializationTimeoutInMillis();
        boolean match = initializationWatcher.waitForMatch(timeout, TimeUnit.MILLISECONDS);
        if (!match) {
            throw new StartupException("Could not confirm RabbitMQ Server initialization completed successfully within " + timeout + "ms");
        }
    }

    static class PatternFinderOutputStream
    extends LogOutputStream
    implements PublishingProcessListener.Subscriber {
        private static final Logger LOGGER = LoggerFactory.getLogger(PatternFinderOutputStream.class);
        private final Pattern pattern;
        private final Semaphore lock;
        private boolean matchFound;

        public PatternFinderOutputStream(String initializationMarkerPattern) {
            this(Pattern.compile(initializationMarkerPattern, 2));
        }

        public PatternFinderOutputStream(Pattern initializationMarkerPattern) {
            try {
                this.lock = new Semaphore(1);
                this.lock.acquire();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Could not acquire a lock we create right above?", e);
            }
            this.pattern = initializationMarkerPattern;
            this.matchFound = false;
        }

        protected void processLine(String line) {
            if (this.pattern.matcher(line).matches()) {
                LOGGER.trace("Pattern '{}' found in line: {}", (Object)this.pattern, (Object)line);
                this.matchFound = true;
                this.lock.release();
            }
            LOGGER.trace("Pattern '{}' NOT found in line: {}", (Object)this.pattern, (Object)line);
        }

        @Override
        public void processFinished(int exitValue) {
            LOGGER.debug("No more output is expected since process finished (exit code: {})", (Object)exitValue);
            this.lock.release();
        }

        public boolean waitForMatch(long duration, TimeUnit timeUnit) {
            try {
                boolean acquired = this.lock.tryAcquire(duration, timeUnit);
                if (!acquired) {
                    LOGGER.info("Waited for {} {} for pattern '{}' to appear but it didn't.", new Object[]{duration, timeUnit, this.pattern});
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("Error while waiting for process output that matches the pattern '{}'", (Object)this.pattern);
            }
            return this.isMatchFound();
        }

        public boolean isMatchFound() {
            return this.matchFound;
        }
    }

    static class PublishingProcessListener
    extends ProcessListener {
        private final List<Subscriber> subscribers;

        public PublishingProcessListener(Subscriber ... subscribers) {
            this.subscribers = new ArrayList<Subscriber>(Arrays.asList(subscribers));
        }

        public void afterFinish(Process process, ProcessResult result) {
            super.afterFinish(process, result);
            for (Subscriber subscriber : this.subscribers) {
                subscriber.processFinished(result.getExitValue());
            }
        }

        public void addSubscriber(Subscriber subscriber) {
            this.subscribers.add(subscriber);
        }

        static interface Subscriber {
            public void processFinished(int var1);
        }
    }
}

