/*
 * Decompiled with CFR 0.152.
 */
package io.arivera.oss.embedded.rabbitmq.helpers;

import io.arivera.oss.embedded.rabbitmq.EmbeddedRabbitMqConfig;
import io.arivera.oss.embedded.rabbitmq.bin.ErlangShell;
import io.arivera.oss.embedded.rabbitmq.bin.ErlangShellException;
import io.arivera.oss.embedded.rabbitmq.helpers.ErlangVersionException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErlangVersionChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErlangVersionChecker.class);
    private final ErlangShell erlangShell;
    private final String minErlangVersion;

    public ErlangVersionChecker(EmbeddedRabbitMqConfig config) {
        this(config.getVersion().getMinimumErlangVersion(), new ErlangShell(config));
    }

    public ErlangVersionChecker(String minErlangVersion, ErlangShell erlangShell) {
        this.minErlangVersion = minErlangVersion;
        this.erlangShell = erlangShell;
    }

    public void check() throws ErlangVersionException {
        int[] actual;
        int[] expected;
        String erlangVersion;
        try {
            erlangVersion = this.erlangShell.getErlangVersion();
            LOGGER.debug("Erlang version installed in this system: {}", (Object)erlangVersion);
        }
        catch (ErlangShellException e) {
            throw new ErlangVersionException("Could not determine Erlang version. Ensure Erlang is correctly installed.", e);
        }
        if (this.minErlangVersion == null) {
            LOGGER.debug("RabbitMQ version to execute doesn't specify a minimum Erlang version. Will skip this check.");
            return;
        }
        LOGGER.debug("RabbitMQ version to execute requires Erlang version {} or above.", (Object)this.minErlangVersion);
        try {
            expected = ErlangVersionChecker.parse(this.minErlangVersion);
            actual = ErlangVersionChecker.parse(erlangVersion);
        }
        catch (RuntimeException e) {
            LOGGER.warn("Error parsing Erlang version: " + this.minErlangVersion + " or " + erlangVersion + ". Ignoring check...");
            return;
        }
        for (int i = 0; i < actual.length && actual[i] <= expected[i]; ++i) {
            if (actual[i] >= expected[i]) continue;
            throw new ErlangVersionException(String.format("Minimum required Erlang version not found. Expected '%s' or higher. Actual is: '%s'", this.minErlangVersion, erlangVersion));
        }
    }

    static int[] parse(String erlangVersion) {
        int[] version = new int[]{0, 0, 0, 0, 0};
        if (erlangVersion.startsWith("r") || erlangVersion.startsWith("R")) {
            erlangVersion = erlangVersion.substring(1);
            String[] components = erlangVersion.split("\\D", 2);
            version[0] = Integer.parseInt(components[0]);
            version[1] = erlangVersion.toUpperCase(Locale.US).replaceAll("[^A-Z]", "").charAt(0);
            if (components.length >= 2 && !components[1].isEmpty() && components[1].indexOf("-") != 0) {
                version[2] = Integer.parseInt(components[1].split("-", 2)[0]);
            }
        } else {
            String[] components = erlangVersion.split("\\.", 5);
            for (int i = 0; i < components.length; ++i) {
                version[i] = Integer.parseInt(components[i]);
            }
        }
        return version;
    }
}

