/*
 * Decompiled with CFR 0.152.
 */
package io.arivera.oss.embedded.rabbitmq.extract;

import io.arivera.oss.embedded.rabbitmq.EmbeddedRabbitMqConfig;
import io.arivera.oss.embedded.rabbitmq.extract.ExtractionException;
import io.arivera.oss.embedded.rabbitmq.extract.Extractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachedExtractor
extends Extractor.Decorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedExtractor.class);
    private final EmbeddedRabbitMqConfig config;

    CachedExtractor(Extractor extractor, EmbeddedRabbitMqConfig config) {
        super(extractor);
        this.config = config;
    }

    @Override
    public void run() throws ExtractionException {
        try {
            this.innerExtractor.run();
        }
        catch (ExtractionException e) {
            if (this.config.shouldDeleteCachedFileOnErrors()) {
                boolean deleted = this.config.getDownloadTarget().delete();
                if (deleted) {
                    LOGGER.info("Removed downloaded file because it's possibly corrupted: {}", (Object)this.config.getDownloadTarget());
                } else {
                    LOGGER.warn("Could not delete downloaded file. Please remove it manually: {}", (Object)this.config.getDownloadTarget());
                }
            } else {
                LOGGER.info("Downloaded file is possibly corrupted but won't be removed: {}", (Object)this.config.getDownloadTarget());
            }
            throw e;
        }
    }
}

