/*
 * Decompiled with CFR 0.152.
 */
package io.arivera.oss.embedded.rabbitmq.extract;

import io.arivera.oss.embedded.rabbitmq.EmbeddedRabbitMqConfig;
import io.arivera.oss.embedded.rabbitmq.apache.commons.lang3.StopWatch;
import io.arivera.oss.embedded.rabbitmq.extract.ExtractionException;
import io.arivera.oss.embedded.rabbitmq.extract.Extractor;
import io.arivera.oss.embedded.rabbitmq.util.ArchiveType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tukaani.xz.XZInputStream;

class BasicExtractor
implements Extractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicExtractor.class);
    private final EmbeddedRabbitMqConfig config;

    BasicExtractor(EmbeddedRabbitMqConfig config) {
        this.config = config;
    }

    @Override
    public void run() throws ExtractionException {
        CompressedExtractor extractor = this.getExtractor(this.config);
        extractor.run();
    }

    CompressedExtractor getExtractor(EmbeddedRabbitMqConfig config) {
        String downloadedFilename = config.getDownloadTarget().toString();
        if (ArchiveType.TAR_GZ.matches(downloadedFilename)) {
            return new TarGzExtractor(config);
        }
        if (ArchiveType.TAR_XZ.matches(downloadedFilename)) {
            return new TarXzExtractor(config);
        }
        if (ArchiveType.ZIP.matches(downloadedFilename)) {
            return new ZipExtractor(config);
        }
        throw new IllegalStateException("Could not determine compression format for file: " + downloadedFilename);
    }

    private static class ZipExtractor
    extends CompressedExtractor {
        public ZipExtractor(EmbeddedRabbitMqConfig config) {
            super(config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() throws ExtractionException {
            ZipFile zipFile;
            try {
                zipFile = new ZipFile(this.config.getDownloadTarget());
            }
            catch (IOException e) {
                throw new ExtractionException("Download file '" + this.config.getDownloadTarget() + "' was not found or is not accessible.", e);
            }
            try {
                LOGGER.info("Extracting '{}' to '{}'", (Object)this.config.getDownloadTarget(), (Object)this.config.getExtractionFolder());
                StopWatch stopWatch = new StopWatch();
                stopWatch.start();
                this.extractZip(zipFile);
                stopWatch.stop();
                LOGGER.info("Finished extracting files in {}ms", (Object)stopWatch.getTime());
            }
            finally {
                IOUtils.closeQuietly((Closeable)zipFile);
            }
        }

        private void extractZip(ZipFile zipFile) {
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                String fileName = entry.getName();
                File outputFile = new File(this.config.getExtractionFolder(), fileName);
                if (entry.isDirectory()) {
                    ZipExtractor.makeDirectory(outputFile);
                    continue;
                }
                ZipExtractor.createNewFile(outputFile);
                try {
                    InputStream inputStream = zipFile.getInputStream(entry);
                    ZipExtractor.extractFile(inputStream, outputFile, fileName);
                }
                catch (IOException e) {
                    throw new ExtractionException("Error extracting file '" + fileName + "' " + "from downloaded file: " + this.config.getDownloadTarget(), e);
                }
            }
        }
    }

    private static class TarXzExtractor
    extends AbstractTarExtractor {
        public TarXzExtractor(EmbeddedRabbitMqConfig config) {
            super(config);
        }

        @Override
        protected InputStream getCompressedInputStream(String downloadedFile, BufferedInputStream bufferedFileInput) throws IOException {
            return new XZInputStream((InputStream)bufferedFileInput);
        }
    }

    private static class TarGzExtractor
    extends AbstractTarExtractor {
        public TarGzExtractor(EmbeddedRabbitMqConfig config) {
            super(config);
        }

        @Override
        protected InputStream getCompressedInputStream(String downloadedFile, BufferedInputStream bufferedFileInput) throws IOException {
            return new GZIPInputStream(bufferedFileInput);
        }
    }

    static abstract class AbstractTarExtractor
    extends CompressedExtractor {
        AbstractTarExtractor(EmbeddedRabbitMqConfig config) {
            super(config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() throws ExtractionException {
            TarArchiveInputStream archive;
            String downloadedFile = this.config.getDownloadTarget().toString();
            try {
                BufferedInputStream bufferedFileInput = new BufferedInputStream(new FileInputStream(this.config.getDownloadTarget()));
                InputStream compressedInputStream = this.getCompressedInputStream(downloadedFile, bufferedFileInput);
                archive = new TarArchiveInputStream(compressedInputStream);
            }
            catch (IOException e) {
                throw new ExtractionException("Download file '" + this.config.getDownloadTarget() + "' was not found or is not accessible.", e);
            }
            try {
                LOGGER.info("Extracting '{}' to '{}'", (Object)this.config.getDownloadTarget(), (Object)this.config.getExtractionFolder());
                StopWatch stopWatch = new StopWatch();
                stopWatch.start();
                this.extractTar(archive);
                stopWatch.stop();
                LOGGER.info("Finished extracting files in {}ms", (Object)stopWatch.getTime());
            }
            finally {
                IOUtils.closeQuietly((Closeable)archive);
            }
        }

        protected abstract InputStream getCompressedInputStream(String var1, BufferedInputStream var2) throws IOException;

        private void extractTar(TarArchiveInputStream archive) {
            File extractionFolder;
            boolean madeReadable;
            TarArchiveEntry fileToExtract;
            try {
                fileToExtract = archive.getNextTarEntry();
            }
            catch (IOException e) {
                throw new ExtractionException("Could not extract files from file '" + this.config.getDownloadTarget() + "' due to: " + e.getLocalizedMessage(), e);
            }
            while (fileToExtract != null) {
                File destPath = new File(this.config.getExtractionFolder(), fileToExtract.getName());
                if (fileToExtract.isDirectory()) {
                    AbstractTarExtractor.makeDirectory(destPath);
                } else if (fileToExtract.isLink()) {
                    this.createLink(fileToExtract, destPath);
                } else {
                    boolean madeReadable2;
                    AbstractTarExtractor.createNewFile(destPath);
                    int mode = fileToExtract.getMode();
                    int ownerBits = mode >> 2;
                    int isExecutable = ownerBits & 1;
                    boolean madeExecutable = destPath.setExecutable(isExecutable == 1);
                    if (!madeExecutable) {
                        LOGGER.warn("File '{}' (original mode {}) could not be made executable probably due to permission issues.", (Object)fileToExtract.getName(), (Object)mode);
                    }
                    if (!(madeReadable2 = destPath.setReadable(true))) {
                        LOGGER.warn("File '{}' (original mode {}) could not be made readable probably due to permission issues.", (Object)fileToExtract.getName(), (Object)mode);
                    }
                    AbstractTarExtractor.extractFile((InputStream)archive, destPath, fileToExtract.getName());
                }
                try {
                    fileToExtract = archive.getNextTarEntry();
                }
                catch (IOException e) {
                    LOGGER.error("Could not find next file to extract.", (Throwable)e);
                    break;
                }
            }
            if (!(madeReadable = (extractionFolder = this.config.getExtractionFolder()).setReadable(true))) {
                LOGGER.warn("File '{}' could not be made readable probably due to permission issues.", (Object)extractionFolder);
            }
        }

        private void createLink(TarArchiveEntry fileToExtract, File destPath) {
            Path link = Paths.get(destPath.toURI());
            Path existingFile = Paths.get(this.config.getExtractionFolder().toString(), fileToExtract.getLinkName());
            try {
                LOGGER.debug("Extracting '{}'...", (Object)destPath);
                Files.createLink(link, existingFile);
            }
            catch (IOException e) {
                LOGGER.warn("Could not create link '{}' to '{}'", new Object[]{link, existingFile, e});
            }
        }
    }

    static abstract class CompressedExtractor
    implements Runnable {
        protected final EmbeddedRabbitMqConfig config;

        CompressedExtractor(EmbeddedRabbitMqConfig config) {
            this.config = config;
        }

        protected static void createNewFile(File destPath) {
            try {
                boolean newFile = destPath.createNewFile();
                if (!newFile) {
                    LOGGER.warn("File '{}' already exists. Will attempt to continue...", (Object)destPath);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Could not extract file '" + destPath + "'. Will attempt to continue...", (Throwable)e);
            }
        }

        protected static void makeDirectory(File destPath) {
            boolean mkdirs = destPath.mkdirs();
            if (!mkdirs) {
                LOGGER.warn("Directory '{}' could not be created. Will attempt to continue...", (Object)destPath);
            }
        }

        protected static void extractFile(InputStream archive, File destPath, String fileName) {
            BufferedOutputStream output = null;
            try {
                LOGGER.debug("Extracting '{}'...", (Object)fileName);
                output = new BufferedOutputStream(new FileOutputStream(destPath));
                IOUtils.copy((InputStream)archive, (OutputStream)output);
            }
            catch (IOException e) {
                try {
                    throw new ExtractionException("Error extracting file '" + fileName + "' ", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(output);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)output);
        }
    }
}

