/*
 * Decompiled with CFR 0.152.
 */
package io.arivera.oss.embedded.rabbitmq.download;

import io.arivera.oss.embedded.rabbitmq.EmbeddedRabbitMqConfig;
import io.arivera.oss.embedded.rabbitmq.download.DownloadException;
import io.arivera.oss.embedded.rabbitmq.download.Downloader;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachedDownloader
extends Downloader.Decorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedDownloader.class);
    private final EmbeddedRabbitMqConfig config;

    CachedDownloader(Downloader downloader, EmbeddedRabbitMqConfig config) {
        super(downloader);
        this.config = config;
    }

    @Override
    public void run() {
        if (this.isDownloadAlreadyCached()) {
            LOGGER.debug("RabbitMQ has been downloaded before. Using file: {}", (Object)this.config.getDownloadTarget());
        } else {
            this.download();
        }
    }

    private boolean isDownloadAlreadyCached() {
        File downloadTarget = this.config.getDownloadTarget();
        return downloadTarget.exists() && downloadTarget.isFile() && downloadTarget.canRead() && downloadTarget.length() > 0L;
    }

    private void download() {
        try {
            this.innerDownloader.run();
        }
        catch (DownloadException e) {
            if (this.config.shouldDeleteCachedFileOnErrors()) {
                if (this.config.getDownloadTarget().exists()) {
                    boolean deleted = this.config.getDownloadTarget().delete();
                    if (deleted) {
                        LOGGER.info("Removed partially downloaded file: {}", (Object)this.config.getDownloadTarget());
                    } else {
                        LOGGER.warn("Could not remove partially downloaded file. Please remove it manually: {}", (Object)this.config.getDownloadTarget());
                    }
                }
            } else {
                LOGGER.info("Partially downloaded file will not be deleted: {}", (Object)this.config.getDownloadTarget());
            }
            throw e;
        }
    }
}

