/*
 * Decompiled with CFR 0.152.
 */
package io.arivera.oss.embedded.rabbitmq.download;

import io.arivera.oss.embedded.rabbitmq.EmbeddedRabbitMqConfig;
import io.arivera.oss.embedded.rabbitmq.apache.commons.io.FileUtils;
import io.arivera.oss.embedded.rabbitmq.apache.commons.lang3.StopWatch;
import io.arivera.oss.embedded.rabbitmq.download.DownloadException;
import io.arivera.oss.embedded.rabbitmq.download.Downloader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BasicDownloader
implements Runnable,
Downloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicDownloader.class);
    private final EmbeddedRabbitMqConfig config;

    BasicDownloader(EmbeddedRabbitMqConfig config) {
        this.config = config;
    }

    @Override
    public void run() throws DownloadException {
        DownloadProgressNotifier progressNotifier = new DownloadProgressNotifier(this.config);
        DownloadTask downloadTask = new DownloadTask(this.config);
        downloadTask.addListener(progressNotifier);
        Thread notifierThread = new Thread((Runnable)progressNotifier, "RabbitMQ-Download-Watcher");
        notifierThread.start();
        downloadTask.run();
    }

    private static class DownloadProgressNotifier
    implements Runnable,
    DownloadListener {
        private final Semaphore semaphore = new Semaphore(1);
        private final EmbeddedRabbitMqConfig config;

        DownloadProgressNotifier(EmbeddedRabbitMqConfig config) {
            this.config = config;
        }

        @Override
        public void downloadFinished() {
            this.semaphore.release();
        }

        @Override
        public void run() {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Acquire should work!");
            }
            while (!this.semaphore.tryAcquire()) {
                try {
                    LOGGER.debug("Downloaded {} bytes", (Object)this.config.getDownloadTarget().length());
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    LOGGER.trace("Download indicator interrupted");
                }
            }
            LOGGER.trace("Download indicator finished normally");
        }
    }

    private static interface DownloadListener {
        public void downloadFinished();
    }

    private static class DownloadTask
    implements Runnable {
        private final StopWatch stopWatch;
        private final EmbeddedRabbitMqConfig config;
        private final List<DownloadListener> downloadListeners;

        public DownloadTask(EmbeddedRabbitMqConfig config) {
            this.config = config;
            this.stopWatch = new StopWatch();
            this.downloadListeners = new ArrayList<DownloadListener>();
        }

        public void addListener(DownloadListener downloadListener) {
            this.downloadListeners.add(downloadListener);
        }

        @Override
        public void run() {
            LOGGER.info("Downloading '{}'...", (Object)this.config.getDownloadSource());
            LOGGER.debug("Downloading to '{}' with {}ms connection and {}ms download timeout...", new Object[]{this.config.getDownloadTarget(), this.config.getDownloadConnectionTimeoutInMillis(), this.config.getDownloadReadTimeoutInMillis()});
            try {
                this.stopWatch.start();
                FileUtils.copyUrlToFile(this.config.getDownloadSource(), this.config.getDownloadTarget(), (int)this.config.getDownloadConnectionTimeoutInMillis(), (int)this.config.getDownloadReadTimeoutInMillis(), this.config.getDownloadProxy());
                this.stopWatch.stop();
                LOGGER.info("Download finished in {}ms", (Object)this.stopWatch.getTime());
            }
            catch (IOException e) {
                throw new DownloadException("Could not download '" + this.config.getDownloadSource() + "' to '" + this.config.getDownloadTarget() + "'", e);
            }
            finally {
                this.notifyListeners();
            }
        }

        private void notifyListeners() {
            for (DownloadListener downloadListener : this.downloadListeners) {
                downloadListener.downloadFinished();
            }
        }
    }
}

