/*
 * Decompiled with CFR 0.152.
 */
package io.arivera.oss.embedded.rabbitmq.bin;

import io.arivera.oss.embedded.rabbitmq.EmbeddedRabbitMqConfig;
import io.arivera.oss.embedded.rabbitmq.bin.RabbitMqCommand;
import io.arivera.oss.embedded.rabbitmq.bin.RabbitMqCommandException;
import java.io.OutputStream;
import java.util.concurrent.Future;
import org.apache.commons.io.output.NullOutputStream;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.listener.ProcessListener;

public class RabbitMqServer {
    private static final String COMMAND = "rabbitmq-server";
    private final EmbeddedRabbitMqConfig config;
    private OutputStream outputStream;
    private ProcessListener listener;

    public RabbitMqServer(EmbeddedRabbitMqConfig config) {
        this.config = config;
        this.outputStream = new NullOutputStream();
        this.listener = new NullProcessListener();
    }

    public RabbitMqServer writeOutputTo(OutputStream outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    public RabbitMqServer listeningToEventsWith(ProcessListener listener) {
        this.listener = listener;
        return this;
    }

    public Future<ProcessResult> start() throws RabbitMqCommandException {
        return this.execute(new String[0]);
    }

    public Future<ProcessResult> startDetached() throws RabbitMqCommandException {
        return this.execute("-detached");
    }

    private Future<ProcessResult> execute(String ... arguments) throws RabbitMqCommandException {
        return new RabbitMqCommand(this.config, COMMAND, arguments).writeOutputTo(this.outputStream).listenToEvents(this.listener).call().getFuture();
    }

    private static class NullProcessListener
    extends ProcessListener {
        private NullProcessListener() {
        }
    }
}

