/*
 * Decompiled with CFR 0.152.
 */
package io.arivera.oss.embedded.rabbitmq.bin;

import io.arivera.oss.embedded.rabbitmq.EmbeddedRabbitMqConfig;
import io.arivera.oss.embedded.rabbitmq.bin.RabbitMqCommand;
import io.arivera.oss.embedded.rabbitmq.bin.RabbitMqCommandException;
import io.arivera.oss.embedded.rabbitmq.bin.RabbitMqDiagnostics;
import io.arivera.oss.embedded.rabbitmq.bin.plugins.Plugin;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.zeroturnaround.exec.ProcessResult;

public class RabbitMqPlugins
extends RabbitMqDiagnostics {
    private static final String LIST_COMMAND = "list";
    private static final String COMMAND = "rabbitmq-plugins";
    private final long timeoutInMillis;

    public RabbitMqPlugins(EmbeddedRabbitMqConfig config) {
        super(config);
        this.timeoutInMillis = config.getDefaultRabbitMqCtlTimeoutInMillis();
    }

    public RabbitMqPlugins(EmbeddedRabbitMqConfig config, Map<String, String> extraEnvVars) {
        super(config, extraEnvVars);
        this.timeoutInMillis = config.getDefaultRabbitMqCtlTimeoutInMillis();
    }

    public RabbitMqPlugins(EmbeddedRabbitMqConfig config, Set<String> envVarsToDiscard, Map<String, String> envVarsToAdd) {
        super(config, envVarsToDiscard, envVarsToAdd);
        this.timeoutInMillis = config.getDefaultRabbitMqCtlTimeoutInMillis();
    }

    public RabbitMqPlugins(RabbitMqCommand.ProcessExecutorFactory processExecutorFactory, File appFolder, Map<String, String> envVars, long timeoutInMillis) {
        super(processExecutorFactory, appFolder, envVars);
        this.timeoutInMillis = timeoutInMillis;
    }

    public Map<Plugin.State, Set<Plugin>> groupedList() throws RabbitMqCommandException {
        Collection<Plugin> plugins = this.list().values();
        return this.groupPluginsByState(plugins);
    }

    private Map<Plugin.State, Set<Plugin>> groupPluginsByState(Collection<Plugin> plugins) {
        HashMap<Plugin.State, Set<Plugin>> groupedPlugins = new HashMap<Plugin.State, Set<Plugin>>();
        for (Plugin.State state : Plugin.State.values()) {
            groupedPlugins.put(state, new TreeSet());
        }
        for (Plugin plugin : plugins) {
            for (Plugin.State state : plugin.getState()) {
                ((Set)groupedPlugins.get((Object)state)).add(plugin);
            }
        }
        return groupedPlugins;
    }

    public Map<String, Plugin> list() {
        String[] args = new String[]{LIST_COMMAND};
        String executionErrorMessage = String.format("Error executing: %s %s", COMMAND, LIST_COMMAND);
        String unexpectedExitCodeMessage = "Listing of plugins failed with exit code: ";
        ProcessResult processResult = this.getProcessResult(args, executionErrorMessage, unexpectedExitCodeMessage);
        List<Plugin> plugins = this.parseListOutput(processResult);
        Map<String, Plugin> result = this.mapPluginsByName(plugins);
        return result;
    }

    private List<Plugin> parseListOutput(ProcessResult processResult) {
        List lines = processResult.getOutput().getLinesAsUTF8();
        return Plugin.fromStrings(lines);
    }

    private Map<String, Plugin> mapPluginsByName(List<Plugin> plugins) {
        HashMap<String, Plugin> result = new HashMap<String, Plugin>(plugins.size());
        for (Plugin plugin : plugins) {
            result.put(plugin.getName(), plugin);
        }
        return result;
    }

    public void enable(String plugin) throws RabbitMqCommandException {
        String[] args = new String[]{"enable", plugin};
        String executionErrorMessage = "Error while enabling plugin '" + plugin + "'";
        String unexpectedExitCodeMessage = "Enabling of plugin '" + plugin + "' failed with exit code: ";
        this.getProcessResult(args, executionErrorMessage, unexpectedExitCodeMessage);
    }

    public void disable(String plugin) throws RabbitMqCommandException {
        String[] args = new String[]{"disable", plugin};
        String executionErrorMessage = "Error while disabling plugin '" + plugin + "'";
        String unexpectedExitCodeMessage = "Disabling of plugin '" + plugin + "' failed with exit code: ";
        this.getProcessResult(args, executionErrorMessage, unexpectedExitCodeMessage);
    }

    private ProcessResult getProcessResult(String[] args, String executionErrorMessage, String unexpectedExitCodeMessage) {
        ProcessResult processResult;
        try {
            Future<ProcessResult> startedProcess = this.execute(args);
            processResult = startedProcess.get(this.timeoutInMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RabbitMqCommandException(executionErrorMessage, e);
        }
        int exitValue = processResult.getExitValue();
        if (exitValue != 0) {
            throw new RabbitMqCommandException(unexpectedExitCodeMessage + exitValue);
        }
        return processResult;
    }

    @Override
    protected String getCommand() {
        return COMMAND;
    }
}

