/*
 * Decompiled with CFR 0.152.
 */
package io.arivera.oss.embedded.rabbitmq.bin;

import io.arivera.oss.embedded.rabbitmq.EmbeddedRabbitMqConfig;
import io.arivera.oss.embedded.rabbitmq.bin.RabbitMqCommand;
import io.arivera.oss.embedded.rabbitmq.bin.RabbitMqCommandException;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.zeroturnaround.exec.ProcessResult;

public class RabbitMqDiagnostics {
    private static final Set<String> DEFAULT_ENV_VARS_TO_DISCARD = new HashSet<String>(Arrays.asList("RABBITMQ_NODE_PORT"));
    private static final String COMMAND = "rabbitmq-diagnostics";
    private RabbitMqCommand.ProcessExecutorFactory peFactory;
    private File appFolder;
    private Map<String, String> envVars;

    public RabbitMqDiagnostics(EmbeddedRabbitMqConfig config) {
        this(config, Collections.EMPTY_MAP);
    }

    public RabbitMqDiagnostics(EmbeddedRabbitMqConfig config, Map<String, String> extraEnvVars) {
        this(config, DEFAULT_ENV_VARS_TO_DISCARD, extraEnvVars);
    }

    public RabbitMqDiagnostics(EmbeddedRabbitMqConfig config, Set<String> envVarsToDiscard, Map<String, String> envVarsToAdd) {
        this(config.getProcessExecutorFactory(), config.getAppFolder(), RabbitMqDiagnostics.mapFilterAndAppend(config.getEnvVars(), envVarsToDiscard, envVarsToAdd));
    }

    public RabbitMqDiagnostics(RabbitMqCommand.ProcessExecutorFactory processExecutorFactory, File appFolder, Map<String, String> envVars) {
        this.peFactory = processExecutorFactory;
        this.appFolder = appFolder;
        this.envVars = envVars;
    }

    protected static Map<String, String> mapFilterAndAppend(Map<String, String> envVars, Set<String> envVarsToDiscard, Map<String, String> envVarsToAdd) {
        Map<String, String> tmpEnvVars = envVars;
        if (!envVarsToDiscard.isEmpty() || envVarsToAdd.isEmpty()) {
            tmpEnvVars = new HashMap<String, String>(tmpEnvVars);
            for (String var : envVarsToDiscard) {
                tmpEnvVars.remove(var);
            }
            tmpEnvVars.putAll(envVarsToAdd);
        }
        return tmpEnvVars;
    }

    public Future<ProcessResult> execute(String ... arguments) throws RabbitMqCommandException {
        return new RabbitMqCommand(this.peFactory, this.envVars, this.appFolder, this.getCommand(), arguments).call().getFuture();
    }

    protected String getCommand() {
        return COMMAND;
    }
}

