/*
 * Decompiled with CFR 0.152.
 */
package io.arivera.oss.embedded.rabbitmq.bin;

import io.arivera.oss.embedded.rabbitmq.EmbeddedRabbitMq;
import io.arivera.oss.embedded.rabbitmq.EmbeddedRabbitMqConfig;
import io.arivera.oss.embedded.rabbitmq.apache.commons.lang3.SystemUtils;
import io.arivera.oss.embedded.rabbitmq.bin.LoggingProcessListener;
import io.arivera.oss.embedded.rabbitmq.bin.RabbitMqCommandException;
import io.arivera.oss.embedded.rabbitmq.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.io.output.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.exec.listener.ProcessListener;
import org.zeroturnaround.exec.stream.slf4j.Level;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public class RabbitMqCommand
implements Callable<StartedProcess> {
    static final String BINARIES_FOLDER = "sbin";
    private static final String LOGGER_TEMPLATE = "%s.Process.%s";
    private static final ProcessListener NULL_LISTENER = new NullProcessListener();
    private static final NullOutputStream NULL_OUTPUT_STREAM = new NullOutputStream();
    private static final boolean IS_WIN = SystemUtils.IS_OS_WINDOWS;
    private static final String WIN_EXT = ".bat";
    private static final String UNIT_EXT = "";
    private final String command;
    private final File executableFile;
    private final List<String> arguments;
    private final ProcessExecutorFactory processExecutorFactory;
    private final File appFolder;
    private final Map<String, String> envVars;
    private Logger processOutputLogger;
    private OutputStream outputStream;
    private OutputStream errorOutputStream;
    private ProcessListener eventsListener;
    private boolean storeOutput;
    private Level stdOutLogLevel;
    private Level stdErrLogLevel;

    public RabbitMqCommand(EmbeddedRabbitMqConfig config, String command, String ... arguments) {
        this(config.getProcessExecutorFactory(), config.getEnvVars(), config.getAppFolder(), command, arguments);
    }

    public RabbitMqCommand(ProcessExecutorFactory processExecutorFactory, Map<String, String> envVars, File appFolder, String command, String ... arguments) {
        this.processExecutorFactory = processExecutorFactory;
        this.command = command + RabbitMqCommand.getCommandExtension();
        this.envVars = envVars;
        this.appFolder = appFolder;
        this.executableFile = new File(new File(this.appFolder, BINARIES_FOLDER), this.command);
        if (!this.executableFile.exists()) {
            throw new IllegalArgumentException("The given command could not be found using the path: " + this.executableFile);
        }
        this.arguments = Arrays.asList(arguments);
        this.processOutputLogger = LoggerFactory.getLogger((String)String.format(LOGGER_TEMPLATE, EmbeddedRabbitMq.class.getName(), command));
        this.outputStream = NULL_OUTPUT_STREAM;
        this.errorOutputStream = NULL_OUTPUT_STREAM;
        this.eventsListener = NULL_LISTENER;
        this.storeOutput = true;
        this.stdOutLogLevel = Level.INFO;
        this.stdErrLogLevel = Level.WARN;
    }

    static String getCommandExtension() {
        return IS_WIN ? WIN_EXT : UNIT_EXT;
    }

    public RabbitMqCommand writeOutputTo(OutputStream outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    public RabbitMqCommand writeErrorOutputTo(OutputStream outputStream) {
        this.errorOutputStream = outputStream;
        return this;
    }

    public RabbitMqCommand logWith(Logger logger) {
        this.processOutputLogger = logger;
        return this;
    }

    public RabbitMqCommand listenToEvents(ProcessListener listener) {
        this.eventsListener = listener;
        return this;
    }

    public RabbitMqCommand storeOutput(boolean storeOutput) {
        this.storeOutput = storeOutput;
        return this;
    }

    public RabbitMqCommand logStandardOutputAs(Level level) {
        this.stdOutLogLevel = level;
        return this;
    }

    public RabbitMqCommand logStandardErrorOutputAs(Level level) {
        this.stdErrLogLevel = level;
        return this;
    }

    @Override
    public StartedProcess call() throws RabbitMqCommandException {
        ArrayList<String> fullCommand = new ArrayList<String>(this.arguments);
        fullCommand.add(0, this.executableFile.toString());
        Slf4jStream loggingStream = Slf4jStream.of((Logger)this.processOutputLogger);
        LoggingProcessListener loggingListener = new LoggingProcessListener(this.processOutputLogger);
        ProcessExecutor processExecutor = this.processExecutorFactory.createInstance().environment(this.envVars).directory(this.appFolder).command(fullCommand).destroyOnExit().addListener((ProcessListener)loggingListener).addListener(this.eventsListener).redirectError((OutputStream)loggingStream.as(this.stdErrLogLevel)).redirectOutput((OutputStream)loggingStream.as(this.stdOutLogLevel)).redirectOutputAlsoTo(this.outputStream).redirectErrorAlsoTo(this.errorOutputStream).readOutput(this.storeOutput);
        try {
            return processExecutor.start();
        }
        catch (IOException e) {
            throw new RabbitMqCommandException("Failed to execute: " + StringUtils.join(fullCommand, " "), e);
        }
    }

    private static class NullProcessListener
    extends ProcessListener {
        private NullProcessListener() {
        }
    }

    public static class ProcessExecutorFactory {
        public ProcessExecutor createInstance() {
            return new ProcessExecutor();
        }
    }
}

