/*
 * Decompiled with CFR 0.152.
 */
package io.arivera.oss.embedded.rabbitmq.bin;

import io.arivera.oss.embedded.rabbitmq.util.StringUtils;
import org.slf4j.Logger;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.listener.ProcessListener;

class LoggingProcessListener
extends ProcessListener {
    private final Logger logger;
    private ProcessExecutor executor;

    LoggingProcessListener(Logger logger) {
        this.logger = logger;
    }

    public void beforeStart(ProcessExecutor executor) {
        this.executor = executor;
        this.logger.debug("Executing '{}' with environment vars: {}", (Object)StringUtils.join(executor.getCommand(), " "), (Object)executor.getEnvironment());
    }

    public void afterStart(Process process, ProcessExecutor executor) {
        this.logger.debug("Process started.");
    }

    public void afterFinish(Process process, ProcessResult result) {
        assert (this.executor != null);
        try {
            this.executor.checkExitValue(result);
            this.logger.debug("Process finished (exit code: {}).", (Object)result.getExitValue());
        }
        catch (InvalidExitValueException e) {
            this.logger.error("Process finished with unexpected exit code: {}.", (Object)result.getExitValue());
        }
    }

    public void afterStop(Process process) {
        this.logger.debug("Process stopped");
    }
}

