/*
 * Decompiled with CFR 0.152.
 */
package io.arivera.oss.embedded.rabbitmq.bin;

import io.arivera.oss.embedded.rabbitmq.EmbeddedRabbitMqConfig;
import io.arivera.oss.embedded.rabbitmq.bin.ErlangShellException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.stream.slf4j.Level;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public class ErlangShell {
    private static final String LOGGER_TEMPLATE = "%s.Process.%s";
    private static final String UNIX_ERL_COMMAND = "erl";
    private final EmbeddedRabbitMqConfig config;

    public ErlangShell(EmbeddedRabbitMqConfig config) {
        this.config = config;
    }

    public String getErlangVersion() throws ErlangShellException {
        String erlangShell = UNIX_ERL_COMMAND;
        Logger processOutputLogger = LoggerFactory.getLogger((String)String.format(LOGGER_TEMPLATE, this.getClass().getName(), erlangShell));
        Slf4jStream stream = Slf4jStream.of((Logger)processOutputLogger);
        ProcessExecutor processExecutor = this.config.getProcessExecutorFactory().createInstance().command(new String[]{erlangShell, "-noshell", "-eval", "erlang:display(erlang:system_info(otp_release)), halt()."}).timeout(this.config.getErlangCheckTimeoutInMillis(), TimeUnit.MILLISECONDS).redirectError((OutputStream)stream.as(Level.WARN)).destroyOnExit().readOutput(true);
        try {
            ProcessResult processResult = processExecutor.execute();
            int exitValue = processResult.getExitValue();
            if (exitValue == 0) {
                return processResult.outputUTF8().trim().replaceAll("[\"\\\\n]", "");
            }
            throw new ErlangShellException("Erlang exited with status " + exitValue);
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            throw new ErlangShellException("Exception executing Erlang shell command", e);
        }
    }
}

