/*
 * Decompiled with CFR 0.152.
 */
package io.arivera.oss.embedded.rabbitmq.apache.commons.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;

public class FileUtils {
    public static void copyURLToFile(URL source, File destination, int connectionTimeout, int readTimeout) throws IOException {
        FileUtils.copyUrlToFile(source, destination, connectionTimeout, readTimeout, null);
    }

    public static void copyUrlToFile(URL source, File destination, int connectionTimeout, int readTimeout, Proxy proxy) throws IOException {
        URLConnection connection = proxy == null ? source.openConnection() : source.openConnection(proxy);
        connection.setConnectTimeout(connectionTimeout);
        connection.setReadTimeout(readTimeout);
        InputStream input = connection.getInputStream();
        FileUtils.copyInputStreamToFile(input, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyInputStreamToFile(InputStream source, File destination) throws IOException {
        try {
            FileOutputStream output = FileUtils.openOutputStream(destination);
            try {
                FileUtils.copy(source, output);
                output.close();
            }
            finally {
                FileUtils.closeQuietly(output);
            }
        }
        finally {
            FileUtils.closeQuietly(source);
        }
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw new IOException("File '" + file + "' could not be created");
            }
        }
        return new FileOutputStream(file);
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = FileUtils.copyLarge(input, output);
        return count > Integer.MAX_VALUE ? -1 : (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        int n1;
        byte[] buffer = new byte[4096];
        long count = 0L;
        boolean n = false;
        while (-1 != (n1 = input.read(buffer))) {
            output.write(buffer, 0, n1);
            count += (long)n1;
        }
        return count;
    }

    public static void closeQuietly(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

