/*
 * Decompiled with CFR 0.152.
 */
package io.arivera.oss.embedded.rabbitmq;

import io.arivera.oss.embedded.rabbitmq.ArtifactRepository;
import io.arivera.oss.embedded.rabbitmq.PredefinedVersion;
import io.arivera.oss.embedded.rabbitmq.Version;
import io.arivera.oss.embedded.rabbitmq.util.ArchiveType;
import io.arivera.oss.embedded.rabbitmq.util.OperatingSystem;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public enum OfficialArtifactRepository implements ArtifactRepository
{
    RABBITMQ("http://www.rabbitmq.com/releases/rabbitmq-server/%sv%s/rabbitmq-server-%s-%s.%s"){

        @Override
        public URL getUrl(Version version, OperatingSystem operatingSystem) {
            if (Version.VERSION_COMPARATOR.compare(version, PredefinedVersion.V3_7_0) >= 0) {
                throw new IllegalStateException(this.name() + " Repository does not store distributions for " + PredefinedVersion.V3_7_0.getVersionAsString() + " or higher. See 'Package Distribution' in " + "http://www.rabbitmq.com/blog/2018/02/05/whats-new-in-rabbitmq-3-7/ for more info");
            }
            return super.getUrl(version, operatingSystem);
        }
    }
    ,
    GITHUB("https://github.com/rabbitmq/rabbitmq-server/releases/download/%sv%s/rabbitmq-server-%s-%s.%s"){

        @Override
        protected String getFolderPrefix(Version version) {
            if (Version.VERSION_COMPARATOR.compare(version, PredefinedVersion.V3_7_0) < 0) {
                return "rabbitmq_";
            }
            return super.getFolderPrefix(version);
        }

        @Override
        protected String getFolderVersion(Version version) {
            if (Version.VERSION_COMPARATOR.compare(version, PredefinedVersion.V3_7_0) < 0) {
                return version.getVersionAsString("_");
            }
            return super.getFolderVersion(version);
        }
    }
    ,
    BINTRAY("https://dl.bintray.com/rabbitmq/all/rabbitmq-server/%s%s/rabbitmq-server-%s-%s.%s");

    private static Map<OperatingSystem, String> downloadPlatformName;
    private final String urlPattern;

    private OfficialArtifactRepository(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    @Override
    public URL getUrl(Version version, OperatingSystem operatingSystem) {
        String artifactPlatform = this.getArtifactPlatform(version, operatingSystem);
        ArchiveType archiveType = version.getArchiveType(operatingSystem);
        String filenameVersion = version.getVersionAsString();
        String folderPrefix = this.getFolderPrefix(version);
        String folderVersion = this.getFolderVersion(version);
        String url = String.format(this.urlPattern, folderPrefix, folderVersion, artifactPlatform, filenameVersion, archiveType.getExtension());
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Download URL is invalid: " + url, e);
        }
    }

    protected String getArtifactPlatform(Version version, OperatingSystem operatingSystem) {
        if (operatingSystem == OperatingSystem.MAC_OS && Version.VERSION_COMPARATOR.compare(PredefinedVersion.V3_7_18, version) <= 0) {
            return downloadPlatformName.get((Object)OperatingSystem.UNIX);
        }
        return downloadPlatformName.get((Object)operatingSystem);
    }

    protected String getFolderVersion(Version version) {
        return version.getVersionAsString();
    }

    protected String getFolderPrefix(Version version) {
        return "";
    }

    static {
        downloadPlatformName = new HashMap<OperatingSystem, String>(3);
        downloadPlatformName.put(OperatingSystem.MAC_OS, "mac-standalone");
        downloadPlatformName.put(OperatingSystem.UNIX, "generic-unix");
        downloadPlatformName.put(OperatingSystem.WINDOWS, "windows");
    }
}

