/*
 * Decompiled with CFR 0.152.
 */
package io.arivera.oss.embedded.rabbitmq;

import io.arivera.oss.embedded.rabbitmq.ArtifactRepository;
import io.arivera.oss.embedded.rabbitmq.Beta;
import io.arivera.oss.embedded.rabbitmq.OfficialArtifactRepository;
import io.arivera.oss.embedded.rabbitmq.PredefinedVersion;
import io.arivera.oss.embedded.rabbitmq.RabbitMqEnvVar;
import io.arivera.oss.embedded.rabbitmq.SingleArtifactRepository;
import io.arivera.oss.embedded.rabbitmq.UnknownVersion;
import io.arivera.oss.embedded.rabbitmq.Version;
import io.arivera.oss.embedded.rabbitmq.apache.commons.lang3.SystemUtils;
import io.arivera.oss.embedded.rabbitmq.bin.RabbitMqCommand;
import io.arivera.oss.embedded.rabbitmq.util.OperatingSystem;
import io.arivera.oss.embedded.rabbitmq.util.RandomPortSupplier;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class EmbeddedRabbitMqConfig {
    private final Version version;
    private final URL downloadSource;
    private final File downloadTarget;
    private final File extractionFolder;
    private final File appFolder;
    private final long downloadReadTimeoutInMillis;
    private final long downloadConnectionTimeoutInMillis;
    private final long defaultRabbitMqCtlTimeoutInMillis;
    private final long rabbitMqServerInitializationTimeoutInMillis;
    private final long erlangCheckTimeoutInMillis;
    private final boolean shouldCacheDownload;
    private final boolean deleteCachedFileOnErrors;
    private final Map<String, String> envVars;
    private final RabbitMqCommand.ProcessExecutorFactory processExecutorFactory;
    private final Proxy downloadProxy;

    protected EmbeddedRabbitMqConfig(Version version, URL downloadSource, File downloadTarget, File extractionFolder, File appFolder, long downloadReadTimeoutInMillis, long downloadConnectionTimeoutInMillis, long defaultRabbitMqCtlTimeoutInMillis, long rabbitMqServerInitializationTimeoutInMillis, long erlangCheckTimeoutInMillis, boolean cacheDownload, boolean deleteCachedFile, Map<String, String> envVars, RabbitMqCommand.ProcessExecutorFactory processExecutorFactory, Proxy downloadProxy) {
        this.version = version;
        this.downloadSource = downloadSource;
        this.downloadTarget = downloadTarget;
        this.extractionFolder = extractionFolder;
        this.appFolder = appFolder;
        this.downloadReadTimeoutInMillis = downloadReadTimeoutInMillis;
        this.downloadConnectionTimeoutInMillis = downloadConnectionTimeoutInMillis;
        this.defaultRabbitMqCtlTimeoutInMillis = defaultRabbitMqCtlTimeoutInMillis;
        this.rabbitMqServerInitializationTimeoutInMillis = rabbitMqServerInitializationTimeoutInMillis;
        this.erlangCheckTimeoutInMillis = erlangCheckTimeoutInMillis;
        this.shouldCacheDownload = cacheDownload;
        this.deleteCachedFileOnErrors = deleteCachedFile;
        this.envVars = envVars;
        this.processExecutorFactory = processExecutorFactory;
        this.downloadProxy = downloadProxy;
    }

    public long getDownloadReadTimeoutInMillis() {
        return this.downloadReadTimeoutInMillis;
    }

    public long getDownloadConnectionTimeoutInMillis() {
        return this.downloadConnectionTimeoutInMillis;
    }

    public long getDefaultRabbitMqCtlTimeoutInMillis() {
        return this.defaultRabbitMqCtlTimeoutInMillis;
    }

    public long getRabbitMqServerInitializationTimeoutInMillis() {
        return this.rabbitMqServerInitializationTimeoutInMillis;
    }

    public long getErlangCheckTimeoutInMillis() {
        return this.erlangCheckTimeoutInMillis;
    }

    public URL getDownloadSource() {
        return this.downloadSource;
    }

    public File getDownloadTarget() {
        return this.downloadTarget;
    }

    public File getExtractionFolder() {
        return this.extractionFolder;
    }

    public boolean shouldCachedDownload() {
        return this.shouldCacheDownload;
    }

    public boolean shouldDeleteCachedFileOnErrors() {
        return this.deleteCachedFileOnErrors;
    }

    public File getAppFolder() {
        return this.appFolder;
    }

    public Map<String, String> getEnvVars() {
        return this.envVars;
    }

    public RabbitMqCommand.ProcessExecutorFactory getProcessExecutorFactory() {
        return this.processExecutorFactory;
    }

    public Version getVersion() {
        return this.version;
    }

    public int getRabbitMqPort() {
        String portValue = this.envVars.get(RabbitMqEnvVar.NODE_PORT.getEnvVarName());
        if (portValue == null) {
            return 5672;
        }
        return Integer.parseInt(portValue);
    }

    public Proxy getDownloadProxy() {
        return this.downloadProxy;
    }

    public static class Builder {
        public static final String DOWNLOAD_FOLDER = ".embeddedrabbitmq";
        private long downloadReadTimeoutInMillis;
        private long downloadConnectionTimeoutInMillis = TimeUnit.SECONDS.toMillis(2L);
        private long defaultRabbitMqCtlTimeoutInMillis;
        private long rabbitMqServerInitializationTimeoutInMillis;
        private long erlangCheckTimeoutInMillis;
        private File downloadFolder;
        private File downloadTarget;
        private File extractionFolder;
        private boolean cacheDownload = true;
        private boolean deleteCachedFile = true;
        private Version version;
        private Map<String, String> envVars;
        private ArtifactRepository artifactRepository;
        private RabbitMqCommand.ProcessExecutorFactory processExecutorFactory;
        private Proxy downloadProxy = null;

        public Builder() {
            this.downloadReadTimeoutInMillis = TimeUnit.SECONDS.toMillis(3L);
            this.defaultRabbitMqCtlTimeoutInMillis = TimeUnit.SECONDS.toMillis(2L);
            this.rabbitMqServerInitializationTimeoutInMillis = TimeUnit.SECONDS.toMillis(3L);
            this.erlangCheckTimeoutInMillis = TimeUnit.SECONDS.toMillis(1L);
            this.downloadFolder = new File(System.getProperty("user.home"), DOWNLOAD_FOLDER);
            this.artifactRepository = OfficialArtifactRepository.GITHUB;
            this.envVars = new HashMap<String, String>();
            this.processExecutorFactory = new RabbitMqCommand.ProcessExecutorFactory();
        }

        @Beta
        public Builder downloadReadTimeoutInMillis(long downloadReadTimeoutInMillis) {
            this.downloadReadTimeoutInMillis = downloadReadTimeoutInMillis;
            return this;
        }

        @Beta
        public Builder downloadConnectionTimeoutInMillis(long downloadConnectionTimeoutInMillis) {
            this.downloadConnectionTimeoutInMillis = downloadConnectionTimeoutInMillis;
            return this;
        }

        @Beta
        public Builder defaultRabbitMqCtlTimeoutInMillis(long defaultRabbitMqCtlTimeoutInMillis) {
            this.defaultRabbitMqCtlTimeoutInMillis = defaultRabbitMqCtlTimeoutInMillis;
            return this;
        }

        @Beta
        public Builder rabbitMqServerInitializationTimeoutInMillis(long rabbitMqServerInitializationTimeoutInMillis) {
            this.rabbitMqServerInitializationTimeoutInMillis = rabbitMqServerInitializationTimeoutInMillis;
            return this;
        }

        @Beta
        public Builder erlangCheckTimeoutInMillis(long erlangCheckTimeoutInMillis) {
            this.erlangCheckTimeoutInMillis = erlangCheckTimeoutInMillis;
            return this;
        }

        public Builder downloadFrom(ArtifactRepository repository) {
            this.artifactRepository = repository;
            return this;
        }

        public Builder downloadFrom(URL downloadSource, String appFolderName) {
            this.artifactRepository = new SingleArtifactRepository(downloadSource);
            this.version = new UnknownVersion(appFolderName);
            return this;
        }

        public Builder version(Version version) {
            this.version = version;
            return this;
        }

        public Builder downloadFolder(File downloadFolder) {
            if (this.downloadTarget != null) {
                throw new IllegalStateException("Download Target has already been set.");
            }
            this.downloadFolder = downloadFolder;
            return this;
        }

        public Builder downloadTarget(File downloadTarget) {
            if (this.downloadFolder != null) {
                throw new IllegalStateException("Download Folder has already been set.");
            }
            this.downloadTarget = downloadTarget;
            return this;
        }

        public Builder extractionFolder(File extractionFolder) {
            this.extractionFolder = extractionFolder;
            return this;
        }

        public Builder useCachedDownload(boolean cacheDownload) {
            this.cacheDownload = cacheDownload;
            return this;
        }

        public Builder deleteDownloadedFileOnErrors(boolean deleteCachedFile) {
            this.deleteCachedFile = deleteCachedFile;
            return this;
        }

        public Builder envVar(String key, String value) {
            this.envVars.put(key, value);
            return this;
        }

        public Builder envVar(RabbitMqEnvVar key, String value) {
            this.envVar(key.getEnvVarName(), value);
            return this;
        }

        public Builder port(int port) {
            if (port == -1) {
                return this.randomPort();
            }
            this.envVar(RabbitMqEnvVar.NODE_PORT, String.valueOf(port));
            return this;
        }

        public Builder randomPort() {
            int randomPort = new RandomPortSupplier().get();
            return this.port(randomPort);
        }

        public Builder envVars(Map<String, String> map) {
            this.envVars.putAll(map);
            return this;
        }

        public Builder processExecutorFactory(RabbitMqCommand.ProcessExecutorFactory factory) {
            this.processExecutorFactory = factory;
            return this;
        }

        public Builder downloadProxy(String hostname, int port) {
            return this.downloadProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(hostname, port)));
        }

        public Builder downloadProxy(Proxy downloadProxy) {
            this.downloadProxy = downloadProxy;
            return this;
        }

        public EmbeddedRabbitMqConfig build() {
            if (this.artifactRepository == null) {
                this.artifactRepository = OfficialArtifactRepository.GITHUB;
            }
            OperatingSystem os = OperatingSystem.detect();
            if (this.version == null) {
                this.version = PredefinedVersion.LATEST;
            }
            URL downloadSource = this.artifactRepository.getUrl(this.version, os);
            if (this.downloadTarget == null) {
                String filename = downloadSource.getPath().substring(downloadSource.getPath().lastIndexOf("/"));
                this.downloadTarget = new File(this.downloadFolder, filename);
            }
            if (this.extractionFolder == null) {
                this.extractionFolder = new File(SystemUtils.JAVA_IO_TMPDIR);
            }
            File appAbsPath = new File(this.extractionFolder.toString(), this.version.getExtractionFolder());
            return new EmbeddedRabbitMqConfig(this.version, downloadSource, this.downloadTarget, this.extractionFolder, appAbsPath, this.downloadConnectionTimeoutInMillis, this.downloadReadTimeoutInMillis, this.defaultRabbitMqCtlTimeoutInMillis, this.rabbitMqServerInitializationTimeoutInMillis, this.erlangCheckTimeoutInMillis, this.cacheDownload, this.deleteCachedFile, this.envVars, this.processExecutorFactory, this.downloadProxy);
        }
    }
}

