/*
 * Decompiled with CFR 0.152.
 */
package io.arivera.oss.embedded.rabbitmq;

import io.arivera.oss.embedded.rabbitmq.EmbeddedRabbitMqConfig;
import io.arivera.oss.embedded.rabbitmq.download.DownloadException;
import io.arivera.oss.embedded.rabbitmq.download.Downloader;
import io.arivera.oss.embedded.rabbitmq.download.DownloaderFactory;
import io.arivera.oss.embedded.rabbitmq.extract.ExtractionException;
import io.arivera.oss.embedded.rabbitmq.extract.Extractor;
import io.arivera.oss.embedded.rabbitmq.extract.ExtractorFactory;
import io.arivera.oss.embedded.rabbitmq.helpers.ErlangVersionChecker;
import io.arivera.oss.embedded.rabbitmq.helpers.ErlangVersionException;
import io.arivera.oss.embedded.rabbitmq.helpers.ShutDownException;
import io.arivera.oss.embedded.rabbitmq.helpers.ShutdownHelper;
import io.arivera.oss.embedded.rabbitmq.helpers.StartupException;
import io.arivera.oss.embedded.rabbitmq.helpers.StartupHelper;
import java.util.concurrent.Future;
import org.zeroturnaround.exec.ProcessResult;

public class EmbeddedRabbitMq {
    private EmbeddedRabbitMqConfig config;
    private Future<ProcessResult> rabbitMqProcess;

    public EmbeddedRabbitMq(EmbeddedRabbitMqConfig config) {
        this.config = config;
    }

    public void start() throws ErlangVersionException, DownloadException, ExtractionException, StartupException {
        if (this.rabbitMqProcess != null) {
            throw new IllegalStateException("Start shouldn't be called more than once unless stop() has been called before.");
        }
        this.check();
        this.download();
        this.extract();
        this.run();
    }

    private void check() throws ErlangVersionException {
        new ErlangVersionChecker(this.config).check();
    }

    private void download() throws DownloadException {
        Downloader downloader = new DownloaderFactory(this.config).getNewInstance();
        downloader.run();
    }

    private void extract() throws ExtractionException {
        Extractor extractor = new ExtractorFactory(this.config).getNewInstance();
        extractor.run();
    }

    private void run() throws StartupException {
        this.rabbitMqProcess = new StartupHelper(this.config).call();
    }

    public void stop() throws ShutDownException {
        if (this.rabbitMqProcess == null) {
            throw new IllegalStateException("Stop shouldn't be called unless 'start()' was successful.");
        }
        new ShutdownHelper(this.config, this.rabbitMqProcess).run();
        this.rabbitMqProcess = null;
    }
}

