/*
 * Decompiled with CFR 0.152.
 */
package io.arivera.oss.embedded.rabbitmq;

import io.arivera.oss.embedded.rabbitmq.ErlangVersion;
import io.arivera.oss.embedded.rabbitmq.Version;
import io.arivera.oss.embedded.rabbitmq.util.ArchiveType;
import io.arivera.oss.embedded.rabbitmq.util.OperatingSystem;
import io.arivera.oss.embedded.rabbitmq.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class BaseVersion
implements Version {
    private static final String EXTRACTION_FOLDER = "rabbitmq_server-%s";
    final List<Integer> versionComponents;
    final ArchiveType unixArchiveType;
    final ArchiveType windowsArchiveType;
    final String minErlangVersion;

    public BaseVersion(String semanticVersion) {
        this(semanticVersion, ErlangVersion.UNKNOWN);
    }

    public BaseVersion(String semanticVersion, String minErlangVersion) {
        this(semanticVersion, minErlangVersion, ArchiveType.TAR_XZ);
    }

    public BaseVersion(String semanticVersion, String minErlangVersion, ArchiveType unixArchiveType) {
        this(semanticVersion, minErlangVersion, unixArchiveType, ArchiveType.ZIP);
    }

    public BaseVersion(String semanticVersion, String minErlangVersion, ArchiveType unixArchiveType, ArchiveType windowsArchiveType) {
        String[] versionComponents = semanticVersion.split("\\.");
        this.versionComponents = new ArrayList<Integer>(versionComponents.length);
        for (String versionComponent : versionComponents) {
            this.versionComponents.add(Integer.parseInt(versionComponent));
        }
        this.unixArchiveType = unixArchiveType;
        this.windowsArchiveType = windowsArchiveType;
        this.minErlangVersion = minErlangVersion;
    }

    @Override
    public List<Integer> getVersionComponents() {
        return this.versionComponents;
    }

    @Override
    public String getVersionAsString() {
        return this.getVersionAsString(".");
    }

    @Override
    public String getVersionAsString(CharSequence separator) {
        return StringUtils.join(this.versionComponents, separator);
    }

    @Override
    public ArchiveType getArchiveType(OperatingSystem operatingSystem) {
        return operatingSystem == OperatingSystem.WINDOWS ? this.windowsArchiveType : this.unixArchiveType;
    }

    @Override
    public String getExtractionFolder() {
        return String.format(EXTRACTION_FOLDER, this.getVersionAsString());
    }

    @Override
    public String getMinimumErlangVersion() {
        return this.minErlangVersion;
    }
}

