/*
 * Decompiled with CFR 0.152.
 */
package airbrake;

import airbrake.AirbrakeNotice;
import airbrake.NoticeXml;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;

public class AirbrakeNotifier {
    private String url;

    public static String slurp(InputStream stream) {
        try {
            int len;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buff = new byte[4096];
            while ((len = stream.read(buff)) != -1) {
                outputStream.write(buff, 0, len);
            }
            return outputStream.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public AirbrakeNotifier() {
        this.setUrl("http://api.airbrake.io/notifier_api/v2/notices");
    }

    public AirbrakeNotifier(String url) {
        this.setUrl(url);
    }

    private void addingPropertiesTo(HttpURLConnection connection) throws ProtocolException {
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-type", "text/xml");
        connection.setRequestProperty("Accept", "text/xml, application/xml");
        connection.setRequestMethod("POST");
    }

    private HttpURLConnection createConnection() throws IOException {
        return (HttpURLConnection)new URL(this.url).openConnection();
    }

    public int notify(AirbrakeNotice notice) {
        try {
            HttpURLConnection airbrakeConnection = this.createConnection();
            this.addingPropertiesTo(airbrakeConnection);
            String noticeXml = new NoticeXml(notice).toString();
            return this.send(noticeXml, airbrakeConnection);
        }
        catch (Exception e) {
            this.printStacktrace(notice, e);
            return 0;
        }
    }

    private void printStacktrace(AirbrakeNotice notice, Exception e) {
        e.printStackTrace();
    }

    private int send(String xml, HttpURLConnection connection) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
        writer.write(xml);
        writer.close();
        int statusCode = connection.getResponseCode();
        return statusCode;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

