/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.crypto.asymmetric;

import com.xiaoleilu.hutool.codec.Base64;
import com.xiaoleilu.hutool.collection.CollUtil;
import com.xiaoleilu.hutool.crypto.CryptoException;
import com.xiaoleilu.hutool.crypto.asymmetric.BaseAsymmetric;
import com.xiaoleilu.hutool.crypto.asymmetric.SignAlgorithm;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Set;

public class Sign
extends BaseAsymmetric<Sign> {
    protected Signature signature;

    public Sign(SignAlgorithm algorithm) {
        this(algorithm, (byte[])null, (byte[])null);
    }

    public Sign(String algorithm) {
        this(algorithm, (byte[])null, (byte[])null);
    }

    public Sign(SignAlgorithm algorithm, String privateKeyBase64, String publicKeyBase64) {
        this(algorithm.getValue(), Base64.decode(privateKeyBase64), Base64.decode(publicKeyBase64));
    }

    public Sign(SignAlgorithm algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public Sign(SignAlgorithm algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public Sign(String algorithm, String privateKeyBase64, String publicKeyBase64) {
        super(algorithm, privateKeyBase64, publicKeyBase64);
    }

    public Sign(String algorithm, byte[] privateKey, byte[] publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    public Sign(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    @Override
    public Sign init(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        try {
            this.signature = Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        super.init(algorithm, privateKey, publicKey);
        return this;
    }

    public byte[] sign(byte[] data) {
        this.lock.lock();
        try {
            this.signature.initSign(this.privateKey);
            this.signature.update(data);
            byte[] byArray = this.signature.sign();
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean verify(byte[] data, byte[] sign) {
        this.lock.lock();
        try {
            this.signature.initVerify(this.publicKey);
            this.signature.update(data);
            boolean bl = this.signature.verify(sign);
            return bl;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Signature getSignature() {
        return this.signature;
    }

    public Sign setSignature(Signature signature) {
        this.signature = signature;
        return this;
    }

    public Sign setCertificate(Certificate certificate) {
        boolean[] keyUsageInfo;
        X509Certificate cert;
        Set<String> critSet;
        if (certificate instanceof X509Certificate && CollUtil.isNotEmpty(critSet = (cert = (X509Certificate)certificate).getCriticalExtensionOIDs()) && critSet.contains("2.5.29.15") && (keyUsageInfo = cert.getKeyUsage()) != null && !keyUsageInfo[0]) {
            throw new CryptoException("Wrong key usage");
        }
        this.publicKey = certificate.getPublicKey();
        return this;
    }
}

