/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.jdbc.common.JDBCObjectFactory;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SConnectionHandle;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public abstract class SPooledConnection
implements PooledConnection {
    private List<ConnectionEventListener> m_listeners = new ArrayList<ConnectionEventListener>();
    protected SConnectionHandle m_connectionHandle;
    protected ILogger m_logger;
    private List<StatementEventListener> m_statementlisteners = new ArrayList<StatementEventListener>();

    public SPooledConnection(SConnection connection) throws SQLException {
        this.m_logger = connection.getConnection().getConnectionLog();
        LogUtilities.logFunctionEntrance(this.m_logger, connection);
        this.m_connectionHandle = JDBCObjectFactory.getInstance().createConnectionHandle(connection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        LogUtilities.logFunctionEntrance(this.m_logger, listener);
        if (null != listener) {
            List<ConnectionEventListener> list = this.m_listeners;
            synchronized (list) {
                this.m_listeners.add(listener);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_connectionHandle.forceClose();
    }

    @Override
    public Connection getConnection() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_connectionHandle.open();
        return this.m_connectionHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        LogUtilities.logFunctionEntrance(this.m_logger, listener);
        if (null != listener) {
            List<ConnectionEventListener> list = this.m_listeners;
            synchronized (list) {
                this.m_listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHandleError(SQLException exception) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        List<ConnectionEventListener> list = this.m_listeners;
        synchronized (list) {
            for (ConnectionEventListener listener : this.m_listeners) {
                listener.connectionErrorOccurred(new ConnectionEvent(this, exception));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        LogUtilities.logFunctionEntrance(this.m_logger, listener);
        if (null != listener) {
            List<StatementEventListener> list = this.m_statementlisteners;
            synchronized (list) {
                this.m_statementlisteners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        LogUtilities.logFunctionEntrance(this.m_logger, listener);
        if (null != listener) {
            List<StatementEventListener> list = this.m_statementlisteners;
            synchronized (list) {
                this.m_statementlisteners.remove(listener);
            }
        }
    }

    public void onHandleStatementClose(PreparedStatement statement) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        for (StatementEventListener listener : this.m_statementlisteners) {
            listener.statementClosed(new StatementEvent(this, statement));
        }
    }

    public void onHandleStatementError(PreparedStatement statement, SQLException exception) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        for (StatementEventListener listener : this.m_statementlisteners) {
            listener.statementErrorOccurred(new StatementEvent(this, statement, exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onHandleClose() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        List<ConnectionEventListener> list = this.m_listeners;
        synchronized (list) {
            for (ConnectionEventListener listener : new ArrayList<ConnectionEventListener>(this.m_listeners)) {
                listener.connectionClosed(new ConnectionEvent(this));
            }
        }
    }
}

