/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.util;

import com.opentok.exception.OpenTokException;
import com.vonage.jwt.Jwt;
import java.io.IOException;
import java.nio.file.Path;
import java.security.Key;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.lang.JoseException;

public class TokenGenerator {
    public static final String ISSUER = "iss";
    public static final String ISSUER_TYPE = "ist";
    public static final String ISSUED_AT = "iat";
    public static final String EXP = "exp";
    public static final String PROJECT_ISSUER_TYPE = "project";

    public static String generateToken(Integer apiKey, String apiSecret) throws OpenTokException {
        JwtClaims claims = new JwtClaims();
        long defaultExpireTime = Instant.now().plus(3L, ChronoUnit.MINUTES).getEpochSecond();
        return TokenGenerator.generateToken(claims, defaultExpireTime, apiKey, apiSecret);
    }

    public static String generateToken(Map<String, Object> claims, long expireTime, String applicationId, Path privateKeyPath) throws OpenTokException {
        try {
            claims.put(EXP, expireTime);
            return Jwt.builder().applicationId(applicationId).privateKeyPath(privateKeyPath).claims(claims).build().generate();
        }
        catch (IOException ex) {
            throw new OpenTokException("Could not generate token: " + ex.getMessage());
        }
    }

    public static String generateToken(JwtClaims claims, long expireTime, int apiKey, String apiSecret) throws OpenTokException {
        SecretKeySpec spec = new SecretKeySpec(apiSecret.getBytes(), "HS256");
        claims.setStringClaim(ISSUER_TYPE, PROJECT_ISSUER_TYPE);
        claims.setIssuer(apiKey + "");
        claims.setGeneratedJwtId();
        claims.setExpirationTime(NumericDate.fromSeconds((long)expireTime));
        claims.setIssuedAtToNow();
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claims.toJson());
        jws.setKey((Key)spec);
        jws.setAlgorithmHeaderValue("HS256");
        try {
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new OpenTokException(e.getMessage());
        }
    }
}

