/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import com.opentok.ArchiveMode;
import com.opentok.MediaMode;
import com.opentok.Resolution;
import com.opentok.exception.InvalidArgumentException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SessionProperties {
    private String location;
    private String archiveName;
    private MediaMode mediaMode;
    private ArchiveMode archiveMode;
    private Resolution archiveResolution;
    private boolean e2ee;

    private SessionProperties(Builder builder) {
        this.location = builder.location;
        this.mediaMode = builder.mediaMode;
        this.archiveMode = builder.archiveMode;
        this.e2ee = builder.e2ee;
        this.archiveName = builder.archiveName;
        this.archiveResolution = builder.archiveResolution;
    }

    public String getLocation() {
        return this.location;
    }

    public MediaMode mediaMode() {
        return this.mediaMode;
    }

    public ArchiveMode archiveMode() {
        return this.archiveMode;
    }

    public String archiveName() {
        return this.archiveName;
    }

    public Resolution archiveResolution() {
        return this.archiveResolution;
    }

    public boolean isEndToEndEncrypted() {
        return this.e2ee;
    }

    public Map<String, List<String>> toMap() {
        ArrayList<String> e2eeValueList;
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        if (this.location != null) {
            ArrayList<String> valueList = new ArrayList<String>(1);
            valueList.add(this.location);
            params.put("location", valueList);
        }
        if (this.mediaMode != null) {
            ArrayList<String> mediaModeValueList = new ArrayList<String>(1);
            mediaModeValueList.add(this.mediaMode.toString());
            params.put("p2p.preference", mediaModeValueList);
        }
        if (this.archiveMode != null) {
            ArrayList<String> archiveModeValueList = new ArrayList<String>(1);
            archiveModeValueList.add(this.archiveMode.toString());
            params.put("archiveMode", archiveModeValueList);
        }
        if (this.archiveResolution != null) {
            ArrayList<String> archiveResolutionValueList = new ArrayList<String>(1);
            archiveResolutionValueList.add(this.archiveResolution.toString());
            params.put("archiveResolution", archiveResolutionValueList);
        }
        if (this.archiveName != null) {
            ArrayList<String> archiveNameValueList = new ArrayList<String>(1);
            archiveNameValueList.add(this.archiveName);
            params.put("archiveName", archiveNameValueList);
        }
        if (this.e2ee) {
            e2eeValueList = new ArrayList<String>(1);
            e2eeValueList.add(String.valueOf(this.e2ee));
            params.put("e2ee", e2eeValueList);
        }
        if (this.e2ee) {
            e2eeValueList = new ArrayList(1);
            e2eeValueList.add("" + this.e2ee);
            params.put("e2ee", e2eeValueList);
        }
        return params;
    }

    public static class Builder {
        private String location;
        private String archiveName;
        private MediaMode mediaMode = MediaMode.RELAYED;
        private ArchiveMode archiveMode = ArchiveMode.MANUAL;
        private Resolution archiveResolution;
        private boolean e2ee = false;

        public Builder location(String location) throws InvalidArgumentException {
            boolean valid;
            try {
                InetAddress ip = InetAddress.getByName(location);
                valid = ip instanceof Inet4Address && ip.getHostAddress().equals(location);
            }
            catch (UnknownHostException ex) {
                valid = false;
            }
            if (!valid) {
                throw new InvalidArgumentException("Location must be a valid IPv4 address. location = " + location);
            }
            this.location = location;
            return this;
        }

        public Builder mediaMode(MediaMode mediaMode) {
            this.mediaMode = mediaMode;
            return this;
        }

        public Builder archiveMode(ArchiveMode archiveMode) {
            this.archiveMode = archiveMode;
            return this;
        }

        public Builder archiveResolution(Resolution archiveResolution) {
            this.archiveResolution = archiveResolution;
            return this;
        }

        public Builder archiveName(String archiveName) {
            this.archiveName = archiveName;
            return this;
        }

        public Builder endToEndEncryption() {
            this.e2ee = true;
            return this;
        }

        public SessionProperties build() {
            if (this.archiveMode == ArchiveMode.ALWAYS && this.mediaMode != MediaMode.ROUTED) {
                throw new IllegalStateException("A session with ALWAYS archive mode must also have the ROUTED media mode.");
            }
            if (this.e2ee && this.mediaMode != MediaMode.ROUTED) {
                throw new IllegalStateException("A session with RELAYED media mode cannot have end-to-end encryption enabled.");
            }
            if (this.e2ee && this.archiveMode == ArchiveMode.ALWAYS) {
                throw new IllegalStateException("A session with ALWAYS archive mode cannot have end-to-end encryption enabled.");
            }
            if (this.archiveMode == ArchiveMode.MANUAL) {
                if (this.archiveResolution != null) {
                    throw new IllegalStateException("Resolution cannot be set for manual archives.");
                }
                if (this.archiveName != null) {
                    throw new IllegalStateException("Name cannot be set for manual archives.");
                }
            }
            if (this.archiveName != null && (this.archiveName.trim().length() < 1 || this.archiveName.length() > 80)) {
                throw new IllegalArgumentException("Archive name must be between 1 and 80 characters.");
            }
            return new SessionProperties(this);
        }
    }
}

