/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import com.opentok.Role;
import com.opentok.SessionProperties;
import com.opentok.TokenOptions;
import com.opentok.exception.InvalidArgumentException;
import com.opentok.exception.OpenTokException;
import com.opentok.util.Crypto;
import com.opentok.util.TokenGenerator;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;
import org.jose4j.jwt.JwtClaims;

public class Session {
    private String sessionId;
    private String apiSecret;
    private String applicationId;
    private Path privateKeyPath;
    private int apiKey;
    private SessionProperties properties;

    protected Session(String sessionId, int apiKey, String apiSecret) {
        this(sessionId, apiKey, apiSecret, new SessionProperties.Builder().build());
    }

    protected Session(String sessionId, int apiKey, String apiSecret, SessionProperties properties) {
        this.sessionId = sessionId;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.properties = properties;
    }

    protected Session(String sessionId, String applicationId, Path privateKeyPath) {
        this(sessionId, applicationId, privateKeyPath, new SessionProperties.Builder().build());
    }

    protected Session(String sessionId, String applicationId, Path privateKeyPath, SessionProperties properties) {
        this.sessionId = sessionId;
        this.properties = properties;
        this.applicationId = applicationId;
        this.privateKeyPath = privateKeyPath;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public int getApiKey() {
        return this.apiKey;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public SessionProperties getProperties() {
        return this.properties;
    }

    public String generateToken() throws OpenTokException {
        return this.generateToken(new TokenOptions.Builder().build());
    }

    public String generateToken(TokenOptions tokenOptions) throws OpenTokException {
        if (tokenOptions == null) {
            throw new InvalidArgumentException("Token options cannot be null");
        }
        Role role = tokenOptions.getRole();
        String data = tokenOptions.getData();
        int nonce = new Random().nextInt();
        long iat = System.currentTimeMillis() / 1000L;
        long exp = tokenOptions.getExpireTime();
        if (exp == 0L) {
            exp = iat + 86400L;
        } else {
            if (exp < iat) {
                throw new InvalidArgumentException("Expire time must be in the future. Relative time: " + (exp - iat));
            }
            if (exp > iat + 2592000L) {
                throw new InvalidArgumentException("Expire time must be in the next 30 days. Too large by " + (exp - (iat + 2592000L)));
            }
        }
        LinkedHashMap<String, Object> claims = new LinkedHashMap<String, Object>();
        claims.put("session_id", this.sessionId);
        claims.put("nonce", nonce);
        claims.put("role", role.toString());
        claims.put("scope", "session.connect");
        if (tokenOptions.getInitialLayoutClassList() != null) {
            claims.put("initial_layout_class_list", String.join((CharSequence)" ", tokenOptions.getInitialLayoutClassList()));
        }
        if (data != null) {
            if (data.length() > 1000) {
                throw new InvalidArgumentException("Connection data must be less than 1000 characters. length: " + data.length());
            }
            try {
                claims.put("connection_data", tokenOptions.isLegacyT1Token() ? URLEncoder.encode(data, "UTF-8") : data);
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidArgumentException("Error during URL encode of your connection data: " + e.getMessage());
            }
        }
        if (tokenOptions.isLegacyT1Token()) {
            StringBuilder dataStringBuilder = new StringBuilder().append("create_time=").append(iat).append("&expire_time=").append(exp);
            for (Map.Entry entry : claims.entrySet()) {
                dataStringBuilder.append('&').append((String)entry.getKey()).append('=').append(entry.getValue());
            }
            StringBuilder tokenStringBuilder = new StringBuilder();
            try {
                tokenStringBuilder.append("T1==");
                String innerBuilder = "partner_id=" + this.apiKey + "&sig=" + Crypto.signData(dataStringBuilder.toString(), this.apiSecret) + ":" + dataStringBuilder;
                tokenStringBuilder.append(Base64.encodeBase64String((byte[])innerBuilder.getBytes(StandardCharsets.UTF_8)).replace("+", "-").replace("/", "_"));
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                throw new OpenTokException("Could not generate token, a signing error occurred.", e);
            }
            return tokenStringBuilder.toString();
        }
        if (this.applicationId == null && this.privateKeyPath == null && this.apiKey != 0 && this.apiSecret != null) {
            JwtClaims jwtClaims = new JwtClaims();
            for (Map.Entry entry : claims.entrySet()) {
                jwtClaims.setClaim((String)entry.getKey(), entry.getValue());
            }
            return TokenGenerator.generateToken(jwtClaims, exp, this.apiKey, this.apiSecret);
        }
        if (this.applicationId != null && this.privateKeyPath != null) {
            return TokenGenerator.generateToken(claims, exp, this.applicationId, this.privateKeyPath);
        }
        throw new IllegalStateException("Insufficient auth credentials.");
    }
}

