/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class AudioConnectorProperties {
    private final URI uri;
    private final Collection<String> streams;
    private final Map<String, String> headers;

    public URI uri() {
        return this.uri;
    }

    public Collection<String> streams() {
        return this.streams;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public String type() {
        return "websocket";
    }

    protected AudioConnectorProperties(Builder builder) {
        this.uri = Objects.requireNonNull(builder.uri);
        this.streams = builder.streams.isEmpty() ? null : Collections.unmodifiableCollection(builder.streams);
        this.headers = builder.headers.isEmpty() ? null : Collections.unmodifiableMap(builder.headers);
    }

    public static class Builder {
        private final URI uri;
        private final Collection<String> streams = new ArrayList<String>();
        private final Map<String, String> headers = new HashMap<String, String>();

        public Builder(URI uri) {
            this.uri = uri;
        }

        public Builder(String uri) {
            this(URI.create(uri));
        }

        public Builder addStream(String stream) {
            if (StringUtils.isBlank((CharSequence)stream)) {
                throw new IllegalArgumentException("Stream ID cannot be blank");
            }
            this.streams.add(stream);
            return this;
        }

        public Builder addStreams(String ... streams) {
            return this.addStreams(Arrays.asList(streams));
        }

        public Builder addStreams(Collection<String> streams) {
            this.streams.addAll(Objects.requireNonNull(streams));
            return this;
        }

        public Builder addHeaders(Map<String, String> headers) {
            this.headers.putAll(Objects.requireNonNull(headers));
            return this;
        }

        public Builder addHeader(String key, String value) {
            if (StringUtils.isBlank((CharSequence)key)) {
                throw new IllegalArgumentException("Property key cannot be blank");
            }
            this.headers.put(key, value);
            return this;
        }

        public AudioConnectorProperties build() {
            return new AudioConnectorProperties(this);
        }
    }
}

