/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import com.opentok.Archive;
import com.opentok.ArchiveLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ArchiveProperties {
    private String name;
    private String resolution;
    private String multiArchiveTag;
    private boolean hasAudio;
    private boolean hasVideo;
    private Integer maxBitrate;
    private Integer quantizationParameter;
    private Archive.OutputMode outputMode;
    private Archive.StreamMode streamMode;
    private ArchiveLayout layout;

    private ArchiveProperties(Builder builder) {
        this.name = builder.name;
        this.resolution = builder.resolution;
        this.hasAudio = builder.hasAudio;
        this.hasVideo = builder.hasVideo;
        this.maxBitrate = builder.maxBitrate;
        this.quantizationParameter = builder.quantizationParameter;
        this.outputMode = builder.outputMode;
        this.streamMode = builder.streamMode;
        this.layout = builder.layout;
        this.multiArchiveTag = builder.multiArchiveTag;
    }

    public String name() {
        return this.name;
    }

    public String resolution() {
        return this.resolution;
    }

    public String getMultiArchiveTag() {
        return this.multiArchiveTag;
    }

    public boolean hasVideo() {
        return this.hasVideo;
    }

    public boolean hasAudio() {
        return this.hasAudio;
    }

    public Integer maxBitrate() {
        return this.maxBitrate;
    }

    public Integer quantizationParameter() {
        return this.quantizationParameter;
    }

    public Archive.OutputMode outputMode() {
        return this.outputMode;
    }

    public Archive.StreamMode streamMode() {
        return this.streamMode;
    }

    public ArchiveLayout layout() {
        return this.layout;
    }

    public Map<String, Collection<String>> toMap() {
        ArrayList<String> valueList;
        HashMap<String, Collection<String>> params = new HashMap<String, Collection<String>>();
        if (this.name != null) {
            valueList = new ArrayList<String>(1);
            valueList.add(this.name);
            params.put("name", valueList);
        }
        if (this.resolution != null) {
            valueList = new ArrayList(1);
            valueList.add(this.resolution);
            params.put("resolution", valueList);
        }
        valueList = new ArrayList(1);
        valueList.add(Boolean.toString(this.hasAudio));
        params.put("hasAudio", valueList);
        valueList = new ArrayList(1);
        valueList.add(Boolean.toString(this.hasVideo));
        params.put("hasVideo", valueList);
        valueList = new ArrayList(1);
        valueList.add(this.outputMode.toString());
        params.put("outputMode", valueList);
        valueList = new ArrayList(1);
        valueList.add(this.streamMode.toString());
        params.put("streamMode", valueList);
        if (this.layout != null) {
            valueList = new ArrayList(1);
            valueList.add(this.layout.toString());
            params.put("layout", valueList);
        }
        if (this.multiArchiveTag != null) {
            valueList = new ArrayList(1);
            valueList.add(this.multiArchiveTag);
            params.put("multiArchiveTag", valueList);
        }
        if (this.maxBitrate != null) {
            valueList = new ArrayList(1);
            valueList.add(this.maxBitrate.toString());
            params.put("maxBitrate", valueList);
        }
        if (this.quantizationParameter != null) {
            valueList = new ArrayList(1);
            valueList.add(this.quantizationParameter.toString());
            params.put("quantizationParameter", valueList);
        }
        return params;
    }

    public static class Builder {
        private String name = null;
        private String resolution = null;
        private String multiArchiveTag = null;
        private boolean hasAudio = true;
        private boolean hasVideo = true;
        private Integer maxBitrate;
        private Integer quantizationParameter;
        private Archive.OutputMode outputMode = Archive.OutputMode.COMPOSED;
        private Archive.StreamMode streamMode = Archive.StreamMode.AUTO;
        private ArchiveLayout layout = null;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public Builder hasAudio(boolean hasAudio) {
            this.hasAudio = hasAudio;
            return this;
        }

        public Builder hasVideo(boolean hasVideo) {
            this.hasVideo = hasVideo;
            return this;
        }

        public Builder maxBitrate(int maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public Builder quantizationParameter(int quantizationParameter) {
            this.quantizationParameter = quantizationParameter;
            return this;
        }

        public Builder outputMode(Archive.OutputMode outputMode) {
            this.outputMode = outputMode;
            return this;
        }

        public Builder streamMode(Archive.StreamMode streamMode) {
            this.streamMode = streamMode;
            return this;
        }

        public Builder layout(ArchiveLayout layout) {
            this.layout = layout;
            return this;
        }

        public Builder multiArchiveTag(String multiArchiveTag) {
            this.multiArchiveTag = multiArchiveTag;
            return this;
        }

        public ArchiveProperties build() {
            return new ArchiveProperties(this);
        }
    }
}

