/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.util.FileUtils;
import com.sap.db.util.PlatformUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.UnknownHostException;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.Locale;

@NotThreadSafe
class ObjectStoreFile {
    private RandomAccessFile _file;
    private FileLock _lock = null;

    ObjectStoreFile() {
    }

    boolean open(String filename, boolean create, boolean recreate) {
        File file = new File(filename);
        if (!create && !file.exists()) {
            return false;
        }
        try {
            boolean newFile;
            boolean bl = newFile = !file.exists();
            if (!newFile && recreate) {
                file.delete();
                newFile = true;
            }
            this._file = new RandomAccessFile(file, "rw");
            if (newFile) {
                FileUtils.limitAccessToReadWriteByOwner(file);
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    void close() {
        if (this._file != null) {
            try {
                this._file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._file = null;
        }
    }

    boolean position(long offset) {
        try {
            this._file.seek(offset);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    boolean write(byte[] buf) {
        try {
            this._file.write(buf);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    boolean read(byte[] buf) {
        try {
            this._file.readFully(buf);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    long getFileSize() {
        try {
            return this._file.length();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    boolean flush() {
        try {
            this._file.getFD().sync();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    boolean isOpen() {
        return this._file != null;
    }

    void lock() {
        try {
            this._lock = this._file.getChannel().lock();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void unlock() {
        try {
            this._lock.release();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._lock = null;
    }

    static String getUserProfilePath(boolean create) throws SQLException {
        String localMachine;
        StringBuilder profilePath = new StringBuilder();
        try {
            localMachine = PlatformUtils.getMachineName();
        }
        catch (UnknownHostException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.connection.securestoreunknownhost", new String[0]);
        }
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).trim();
        if (os.contains("windows")) {
            String allUsersDirectory = System.getenv("ALLUSERSPROFILE");
            if (allUsersDirectory == null || allUsersDirectory.trim().isEmpty()) {
                throw SQLExceptionSapDB.newInstance("error.connection.securestoreallusersprofile", new String[0]);
            }
            profilePath.append(allUsersDirectory);
            profilePath.append(File.separatorChar);
            profilePath.append(".hdb");
            profilePath.append(File.separatorChar);
            profilePath.append(localMachine);
            profilePath.append(File.separatorChar);
            String sid = PlatformUtils.getWindowsSID();
            if (sid == null) {
                throw SQLExceptionSapDB.newInstance("error.connection.securestoreunknownsid", new String[0]);
            }
            profilePath.append(sid);
        } else {
            String homeDirectory = System.getenv("HOME");
            if (homeDirectory == null || homeDirectory.trim().isEmpty()) {
                throw SQLExceptionSapDB.newInstance("error.connection.securestorehomedirectory", new String[0]);
            }
            profilePath.append(homeDirectory);
            profilePath.append(File.separatorChar);
            profilePath.append(".hdb");
            profilePath.append(File.separatorChar);
            profilePath.append(localMachine);
        }
        if (create) {
            try {
                Files.createDirectories(Paths.get(profilePath.toString(), new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw SQLExceptionSapDB.newInstance("error.create.directory.failed", profilePath.toString(), e.getMessage());
            }
        }
        profilePath.append(File.separatorChar);
        return profilePath.toString();
    }
}

