/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.NotThreadSafe;

@NotThreadSafe
public class BackOffTimer {
    public static final int DEFAULT_ACTIVE_ACTIVE_ROUTING_BACKOFF_MIN = 5;
    public static final int DEFAULT_ACTIVE_ACTIVE_ROUTING_BACKOFF_MAX = 300;
    public static final int MINIMUM_STATEMENT_ROUTING_BACKOFF_MIN = 5;
    public static final int DEFAULT_STATEMENT_ROUTING_BACKOFF_MIN = 60;
    public static final int DEFAULT_STATEMENT_ROUTING_BACKOFF_MAX = 3600;
    private long _start;
    private long _min;
    private long _max;
    private long _current;

    public BackOffTimer(long routingBackoffMin, long routingBackoffMax) {
        this(routingBackoffMin, routingBackoffMax, RoutingType.ACTIVE_ACTIVE);
    }

    public BackOffTimer(long routingBackoffMin, long routingBackoffMax, RoutingType routingType) {
        this._min = routingBackoffMin;
        this._max = routingBackoffMax;
        switch (routingType.ordinal()) {
            case 0: {
                if (this._min <= this._max && this._min >= 5L) break;
                this._min = 60L;
                this._max = 3600L;
                break;
            }
            case 1: {
                if (this._min <= this._max) break;
                this._min = 5L;
                this._max = 300L;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected routing type: " + (Object)((Object)routingType)));
            }
        }
        this._start = 0L;
        this._current = 0L;
    }

    public long getElapsedSeconds() {
        return (System.currentTimeMillis() - this._start) / 1000L;
    }

    public void backOff() {
        this._start = System.currentTimeMillis();
        if (this._current == 0L) {
            this._current = this._min;
        } else {
            this._current *= 2L;
            if (this._current > this._max) {
                this._current = this._max;
            }
        }
    }

    public void reset() {
        this._current = 0L;
        this._start = 0L;
    }

    public boolean isRetryOk() {
        if (this._start == 0L) {
            return true;
        }
        long elapsedMillis = System.currentTimeMillis() - this._start;
        return elapsedMillis > this._current * 1000L;
    }

    public BackOffTimer(RoutingType routingType) {
        this(0L, -1L, routingType);
    }

    public long getMin() {
        return this._min;
    }

    public long getMax() {
        return this._max;
    }

    public static enum RoutingType {
        STATEMENT,
        ACTIVE_ACTIVE;

    }
}

