/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;

@Immutable
public enum TopologyInformationOption {
    HostName(1),
    HostPortNumber(2),
    TenantName(3),
    LoadFactor(4),
    VolumeID(5),
    IsMaster(6),
    IsCurrentSession(7),
    ServiceType(8),
    NetworkDomain_Deprecated(9),
    IsStandby(10),
    AllIpAdresses_Deprecated(11),
    AllHostNames_Deprecated(12),
    SiteType(13),
    SMVRRole(14),
    Unknown(-1);

    private static final TopologyInformationOption[] VALUES;

    public static TopologyInformationOption decode(int value) {
        return value >= 1 && value < VALUES.length ? VALUES[value - 1] : Unknown;
    }

    public static String getDisplayName(int value) {
        return TopologyInformationOption.decode(value).name() + '(' + value + ')';
    }

    private TopologyInformationOption(int value) {
        if (value != this.ordinal() + 1 && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    static {
        VALUES = TopologyInformationOption.values();
    }
}

