/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.HashPartitionInfo;
import com.sap.db.jdbc.ParseInfo;
import com.sap.db.jdbc.RangePartitionInfo;
import com.sap.db.jdbc.SiteTypeReplicaRoleVolumeID;
import com.sap.db.jdbc.SystemInfo;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.HMultiLineOptionsPart;
import com.sap.db.jdbc.packet.HOptionsPart;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.PartKind;
import com.sap.db.jdbc.packet.PartitionMethod;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

@ThreadSafe
public class HPartInfo {
    private final HReplyPacket _replyPacket;
    private final int _segmentIndex;
    private final int _partIndex;

    protected HPartInfo(HReplyPacket replyPacket, int segmentIndex, int partIndex) {
        this._replyPacket = replyPacket;
        this._segmentIndex = segmentIndex;
        this._partIndex = partIndex;
    }

    public PartKind getPartKind() {
        return this._replyPacket.getPartKind(this._segmentIndex, this._partIndex);
    }

    public SQLException getSQLExceptionChain(ConnectionSapDB conn) {
        return this._replyPacket.getSQLExceptionChain(conn, this._segmentIndex, this._partIndex);
    }

    public byte[] getStatementID() {
        return this._replyPacket.getStatementID(this._segmentIndex, this._partIndex);
    }

    public byte[] getCursorID() {
        return this._replyPacket.getCursorID(this._segmentIndex, this._partIndex);
    }

    public int getRowsAffected() {
        return this._replyPacket.getRowsAffected(this._segmentIndex, this._partIndex);
    }

    public List<SiteTypeReplicaRoleVolumeID> getTableLocations(ConnectionSapDB connection, SystemInfo systemInfo) {
        return this._replyPacket.getTableLocations(this._segmentIndex, this._partIndex, connection, systemInfo);
    }

    public PartitionMethod getPartitionMethod() {
        return this._replyPacket.getPartitionMethod(this._segmentIndex, this._partIndex);
    }

    public HashPartitionInfo getHashPartitionInfo(ConnectionSapDB connection, SystemInfo systemInfo) {
        return this._replyPacket.getHashPartitionInfo(this._segmentIndex, this._partIndex, connection, systemInfo);
    }

    public RangePartitionInfo getRangePartitionInfo(ConnectionSapDB connection, SystemInfo systemInfo) {
        return this._replyPacket.getRangePartitionInfo(this._segmentIndex, this._partIndex, connection, systemInfo);
    }

    public void getResultSetMetaData(ConnectionSapDB connection, List<AbstractConverter> converters) throws SQLException {
        this._replyPacket.getResultSetMetaData(this._segmentIndex, this._partIndex, connection, converters);
    }

    public void getParameterMetaData(ConnectionSapDB connection, ParseInfo parseInfo) throws SQLException {
        this._replyPacket.getParameterMetaData(this._segmentIndex, this._partIndex, connection, parseInfo);
    }

    public Map<String, String> getSessionVariables() {
        return this._replyPacket.getSessionVariables(this._segmentIndex, this._partIndex);
    }

    public HOptionsPart getOptionsPart() {
        return this._replyPacket.getOptionsPart(this._segmentIndex, this._partIndex);
    }

    public HMultiLineOptionsPart getMultiLineOptionsPart() {
        return this._replyPacket.getMultiLineOptionsPart(this._segmentIndex, this._partIndex);
    }

    public HDataPart getResultSetPart() {
        return this._replyPacket.getResultSetPart(this._segmentIndex, this._partIndex);
    }
}

