/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.converters.ArrayConverter;
import com.sap.db.jdbc.converters.InputStreamFilter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.SQLException;
import java.util.Set;

@ThreadSafe
abstract class AbstractVectorConverter
extends ArrayConverter {
    protected AbstractVectorConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, DataType elementType, AbstractConverter elementConverter) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, elementType, elementConverter);
    }

    protected abstract byte[] _setValue(float[] var1) throws SQLException;

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        int valueLength;
        if (!(data instanceof byte[])) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        byte[] value = (byte[])data;
        int dataLen = valueLength = value.length;
        int dataLengthIndicatorLen = HDataPart.getDataLengthIndicatorLength(dataLen);
        return dataLen + dataLengthIndicatorLen + 1;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof byte[])) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        byte[] value = (byte[])data;
        return dataPart.putBytesAsBinary(value);
    }

    public float[] getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsFloatPrimitiveArray(controller, dataPart);
    }

    @Override
    public <T> T getObject(SQLParamController controller, HDataPart dataPart, Class<T> type) throws SQLException {
        if (type == float[].class) {
            return type.cast(this.getObject(controller, dataPart));
        }
        return super.getObject(controller, dataPart, type);
    }

    @Override
    public Object setObject(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof float[]) {
            return this._setValue((float[])value);
        }
        if (value instanceof Array) {
            return this.setArray((Array)value);
        }
        if (value instanceof String) {
            return this.setString((String)value);
        }
        if (value instanceof byte[]) {
            return this.setBytes((byte[])value);
        }
        return this._defaultSetObject(value);
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsString(controller, dataPart);
    }

    public byte[] setString(String value) throws SQLException {
        if (value == null) {
            return null;
        }
        return this._setValue(this._convertStringToFloatArray(value));
    }

    public byte[] setBytes(byte[] value) throws SQLException {
        if (value == null) {
            return null;
        }
        return (byte[])value.clone();
    }

    @Override
    public Reader getCharacterStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart);
        return value != null ? new StringReader(value) : null;
    }

    public byte[] setCharacterStream(Reader value, long length) throws SQLException {
        if (value == null) {
            return null;
        }
        return this._setValue(this._convertStringToFloatArray(AbstractVectorConverter._convertReaderToString(value, length)));
    }

    @Override
    public InputStream getAsciiStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart);
        return value != null ? new ByteArrayInputStream(value.getBytes(StandardCharsets.ISO_8859_1)) : null;
    }

    public byte[] setAsciiStream(InputStream value, long length) throws SQLException {
        if (value == null) {
            return null;
        }
        return this._setValue(this._convertStringToFloatArray(AbstractVectorConverter._convertReaderToString(new InputStreamReader(length >= 0L ? new InputStreamFilter(value, length) : value, StandardCharsets.ISO_8859_1), -1L)));
    }

    public byte[] setBinaryStream(InputStream value, long length) throws SQLException {
        if (value == null) {
            return null;
        }
        return AbstractVectorConverter._convertInputStreamToBytes(value, length);
    }

    @Override
    public Array getArray(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsArray(controller, dataPart, true);
    }

    public byte[] setArray(Array value) throws SQLException {
        if (value == null) {
            return null;
        }
        return this._setValue(this._convertArrayToFloatArray(value));
    }

    @Override
    protected int _putNullInputArg(HDataPart dataPart) throws SQLException {
        return dataPart.putNull(DataType.VARBINARY);
    }

    @Override
    protected void _setArrayElement(SQLParamController controller, HDataPart data, Object[] elements, int idx) throws SQLException {
        elements[idx] = Float.valueOf(this._elementConverter.getFloat(controller, data, null));
    }

    protected float[] _getValueAsFloatPrimitiveArray(SQLParamController controller, HDataPart dataPart) throws SQLException {
        if (dataPart.isNull(this, controller)) {
            return null;
        }
        int elementCount = dataPart.getIntAsInt();
        float[] elements = new float[elementCount];
        HDataPart data = HDataPart.createArrayPart(dataPart, this._outputFieldPos, this._elementConverter);
        int n = elementCount;
        for (int i = 0; i < n; ++i) {
            data.moveToField(i + 1);
            elements[i] = this._elementConverter.getFloat(controller, data, null);
        }
        return elements;
    }

    protected String _getValueAsString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        if (dataPart.isNull(this, controller)) {
            return null;
        }
        int elementCount = dataPart.getIntAsInt();
        StringBuilder builder = new StringBuilder();
        HDataPart data = HDataPart.createArrayPart(dataPart, this._outputFieldPos, this._elementConverter);
        builder.append('[');
        int n = elementCount;
        for (int i = 0; i < n; ++i) {
            data.moveToField(i + 1);
            if (i > 0) {
                builder.append(',');
            }
            builder.append(this._elementConverter.getString(controller, data));
        }
        builder.append(']');
        return builder.toString();
    }

    protected float[] _convertStringToFloatArray(String text) throws SQLException {
        String trimmed = text.trim();
        int len = trimmed.length();
        if (len >= 2 && trimmed.charAt(0) == '[' && trimmed.charAt(len - 1) == ']') {
            trimmed = trimmed.substring(1, len - 1);
        }
        String[] strs = trimmed.split(",");
        int count = strs.length;
        float[] values = new float[count];
        for (int i = 0; i < count; ++i) {
            float value;
            String str = strs[i].trim();
            try {
                value = Float.parseFloat(str);
            }
            catch (NumberFormatException e) {
                throw AbstractVectorConverter._newSetConversionException(str, "float");
            }
            values[i] = value;
        }
        return values;
    }

    protected float[] _convertArrayToFloatArray(Array sqlArray) throws SQLException {
        int baseType = sqlArray.getBaseType();
        if (baseType != 7) {
            throw this._newSetException("java.sql.Array of " + sqlArray.getBaseTypeName());
        }
        Float[] array = (Float[])sqlArray.getArray();
        int count = array.length;
        float[] values = new float[count];
        for (int i = 0; i < count; ++i) {
            values[i] = array[i].floatValue();
        }
        return values;
    }
}

