/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.Address;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.PublicAddress;
import com.sap.db.jdbc.SavepointSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionPool;
import com.sap.db.jdbc.packet.EngineFeatures;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.TransactionState;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.HexUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

@NotThreadSafe
public class Transaction {
    private final ConnectionSapDB _connection;
    private final Tracer _tracer;
    private final SessionPool _sessionPool;
    private final String _primaryConnectionPreference;
    private final Map<String, SavepointSapDB> _savepointMap;
    private final Map<Session, SessionFlags> _sessionFlagsMap;
    private boolean _autoCommit;
    private boolean _ddlAutoCommit;
    private TransactionState _transactionState;
    private int _numberOfSessionsInvolved;
    private byte[] _transactionID;
    private int _implicitXAStartCount;
    private int _implicitXAJoinCount;
    private int _explicitXAStartCount;
    private int _explicitXAJoinCount;
    private boolean _hasBackup;
    private Map<Session, SessionFlags> _sessionFlagsMapBackup;
    private TransactionState _transactionStateBackup;
    private int _numberOfSessionsInvolvedBackup;
    private int _implicitXAStartCountBackup;
    private int _implicitXAJoinCountBackup;
    private int _restoreCount;

    Transaction(ConnectionSapDB connection) {
        this._connection = connection;
        this._tracer = connection.getTracer();
        this._sessionPool = connection.getSessionPool();
        this._primaryConnectionPreference = connection.getConnectionProperty(ConnectionProperty.PRIMARY_CONNECTION);
        this._savepointMap = new HashMap<String, SavepointSapDB>();
        this._sessionFlagsMap = new WeakHashMap<Session, SessionFlags>();
        this._autoCommit = true;
        this._ddlAutoCommit = true;
        this._transactionState = TransactionState.None;
        this._sessionFlagsMapBackup = new WeakHashMap<Session, SessionFlags>();
    }

    boolean getAutoCommit() {
        return this._autoCommit;
    }

    void setAutoCommit(boolean autoCommit) {
        if (!this._autoCommit && autoCommit && !this._ddlAutoCommit) {
            this._ddlAutoCommit = true;
        }
        this._autoCommit = autoCommit;
    }

    boolean getDDLAutoCommit() {
        return this._ddlAutoCommit;
    }

    void setDDLAutoCommit(boolean ddlAutoCommit) {
        this._ddlAutoCommit = ddlAutoCommit;
    }

    TransactionState getTransactionState() {
        return this._transactionState;
    }

    boolean isWriteTransaction() {
        return this._transactionState == TransactionState.WriteTransaction || this._transactionState == TransactionState.DistributedTransaction;
    }

    void setTransactionState(Session session, TransactionState newState) {
        if (this._transactionState == newState) {
            return;
        }
        if (this._transactionState == TransactionState.DistributedTransaction && newState == TransactionState.WriteTransaction) {
            return;
        }
        if (!this._checkSession(session)) {
            return;
        }
        if (this._transactionState == TransactionState.None && (newState == TransactionState.ReadTransaction || newState == TransactionState.WriteTransaction) || this._transactionState == TransactionState.ReadTransaction && newState == TransactionState.WriteTransaction) {
            this._sessionPool.setPrimarySession(session);
        }
        this._transactionState = newState;
        if (this._tracer.on()) {
            this._tracer.printDistribution(this._connection, "Change Tx " + this.getDisplayTransactionID() + " state to " + this._transactionState.name() + " on session " + session.getTraceString(true, false));
        }
    }

    TransactionState getNewTransactionState(Session session, FunctionCode functionCode) {
        TransactionState newState;
        if (!this._checkSession(session)) {
            return null;
        }
        switch (functionCode) {
            case Commit: 
            case Rollback: 
            case Connect: 
            case Disconnect: {
                newState = TransactionState.None;
                break;
            }
            case XAStart: 
            case XAJoin: 
            case Nil: 
            case CloseCursor: 
            case DDL: {
                newState = null;
                break;
            }
            default: {
                newState = TransactionState.ReadTransaction;
            }
        }
        return newState;
    }

    byte[] handleTransaction(Session session, boolean allowChangePrimaryAndXAJoin, boolean allowImplicitXAJoin) throws SQLException {
        if (session.isSiteRouted() || session.isReplicaRouted()) {
            return null;
        }
        this.addSessionToTransaction(session);
        if (!allowChangePrimaryAndXAJoin) {
            return null;
        }
        switch (this._transactionState) {
            case None: {
                this._sessionPool.setPrimarySession(session);
                break;
            }
            case ReadTransaction: {
                break;
            }
            case WriteTransaction: {
                if (this._numberOfSessionsInvolved <= 1) break;
                this._startDistributedTransaction();
                return this._joinDistributedTransaction(session, allowImplicitXAJoin);
            }
            case DistributedTransaction: {
                if (this.isPartOfDistributedTransaction(session)) break;
                return this._joinDistributedTransaction(session, allowImplicitXAJoin);
            }
        }
        return null;
    }

    void addSessionToTransaction(Session session) {
        if (this.isPartOfTransaction(session)) {
            return;
        }
        this.joinTransaction(session);
        ++this._numberOfSessionsInvolved;
    }

    SavepointSapDB getSavepoint(String name) {
        return this._savepointMap.get(name);
    }

    void setSavepoint(SavepointSapDB savepoint) {
        this._savepointMap.put(savepoint._getName(), savepoint);
    }

    void clearTransaction(boolean forCloseOrReconnect) {
        this._savepointMap.clear();
        if (this._transactionState == TransactionState.None && this._numberOfSessionsInvolved == 0 && this._transactionID == null) {
            return;
        }
        this._transactionState = TransactionState.None;
        for (Session session : this._sessionPool.getSessions().values()) {
            this.leaveTransaction(session);
        }
        if (this._tracer.on() && this._transactionState != TransactionState.Unknown) {
            this._tracer.printDistributionState(this._connection, "Close Tx " + this.getDisplayTransactionID());
        }
        this._numberOfSessionsInvolved = 0;
        this._transactionID = null;
        if (!forCloseOrReconnect && !this._primaryConnectionPreference.equalsIgnoreCase("LASTPRIMARY")) {
            Session lastExecutedSession;
            if (this._primaryConnectionPreference.equalsIgnoreCase("LASTEXECUTE") && (lastExecutedSession = this._sessionPool.getLastPreparedExecuteSessionForNoneOrPrimarySite()) != null) {
                this._sessionPool.setPrimarySession(lastExecutedSession);
            } else {
                Session anchorSession = this._sessionPool.getAnchorSession();
                if (anchorSession != null) {
                    this._sessionPool.setPrimarySession(anchorSession);
                }
            }
        }
    }

    String getDisplayTransactionID() {
        return "[" + HexUtils.toHexString(this._transactionID) + "]";
    }

    byte[] getTransactionID() {
        return this._transactionID;
    }

    void setTransactionID(byte[] transactionID) throws SQLException {
        this._transactionID = transactionID;
    }

    boolean isPartOfTransaction(Session session) {
        SessionFlags sessionFlags = this._sessionFlagsMap.get(session);
        return sessionFlags != null && sessionFlags._isPartOfTransaction;
    }

    boolean isPartOfDistributedTransaction(Session session) {
        SessionFlags sessionFlags = this._sessionFlagsMap.get(session);
        return sessionFlags != null && sessionFlags._isPartOfDistributedTransaction;
    }

    boolean hasSentAsPartOfTransaction(Session session) {
        SessionFlags sessionFlags = this._sessionFlagsMap.get(session);
        return sessionFlags != null && sessionFlags._hasSentAsPartOfTransaction;
    }

    void joinTransaction(Session session) {
        SessionFlags sessionFlags = this._sessionFlagsMap.get(session);
        if (sessionFlags == null) {
            sessionFlags = new SessionFlags();
            this._sessionFlagsMap.put(session, sessionFlags);
        }
        sessionFlags._isPartOfTransaction = true;
    }

    void joinDistributedTransaction(Session session) {
        SessionFlags sessionFlags = this._sessionFlagsMap.get(session);
        if (sessionFlags == null) {
            sessionFlags = new SessionFlags();
            this._sessionFlagsMap.put(session, sessionFlags);
        }
        sessionFlags._isPartOfTransaction = true;
        sessionFlags._isPartOfDistributedTransaction = true;
    }

    void setSentAsPartOfTransaction(Session session) {
        SessionFlags sessionFlags = this._sessionFlagsMap.get(session);
        if (sessionFlags != null && sessionFlags._isPartOfTransaction) {
            sessionFlags._hasSentAsPartOfTransaction = true;
        }
    }

    void leaveTransaction(Session session) {
        this._sessionFlagsMap.remove(session);
    }

    int getImplicitXAStartCount() {
        return this._implicitXAStartCount;
    }

    int getImplicitXAJoinCount() {
        return this._implicitXAJoinCount;
    }

    int getExplicitXAStartCount() {
        return this._explicitXAStartCount;
    }

    int getExplicitXAJoinCount() {
        return this._explicitXAJoinCount;
    }

    void save() {
        this._hasBackup = true;
        this._sessionFlagsMapBackup.clear();
        for (Map.Entry<Session, SessionFlags> entry : this._sessionFlagsMap.entrySet()) {
            this._sessionFlagsMapBackup.put(entry.getKey(), new SessionFlags(entry.getValue()));
        }
        this._transactionStateBackup = this._transactionState;
        this._numberOfSessionsInvolvedBackup = this._numberOfSessionsInvolved;
        this._implicitXAStartCountBackup = this._implicitXAStartCount;
        this._implicitXAJoinCountBackup = this._implicitXAJoinCount;
    }

    void restore(Session session) {
        if (!this._hasBackup) {
            throw new AssertionError((Object)"Transaction.restore(): No backup available");
        }
        ++this._restoreCount;
        this._sessionFlagsMap.clear();
        this._sessionFlagsMap.putAll(this._sessionFlagsMapBackup);
        this._numberOfSessionsInvolved = this._numberOfSessionsInvolvedBackup;
        if (this._transactionState != this._transactionStateBackup) {
            if (this._tracer.on()) {
                this._tracer.printDistribution(this._connection, "Undo Tx " + this.getDisplayTransactionID() + " state from " + this._transactionState.name() + " to " + this._transactionStateBackup.name() + " on session " + session.getTraceString(true, false));
            }
            this._transactionState = this._transactionStateBackup;
        }
        if (this._implicitXAStartCount > this._implicitXAStartCountBackup) {
            if (this._tracer.on()) {
                this._tracer.printDistribution(this._connection, "Undo Implicit Start Distributed Tx " + this.getDisplayTransactionID() + " on session " + this._sessionPool.getPrimarySession().getTraceString(true, false));
            }
            this._implicitXAStartCount = this._implicitXAStartCountBackup;
        }
        if (this._implicitXAJoinCount > this._implicitXAJoinCountBackup) {
            if (this._tracer.on()) {
                this._tracer.printDistribution(this._connection, "Undo Implicit Join Distributed Tx " + this.getDisplayTransactionID() + " on session " + session.getTraceString(true, false));
            }
            this._implicitXAJoinCount = this._implicitXAJoinCountBackup;
        }
    }

    void purge() {
        this._hasBackup = false;
        this._sessionFlagsMapBackup.clear();
        this._transactionStateBackup = TransactionState.Unknown;
        this._numberOfSessionsInvolvedBackup = -1;
        this._implicitXAStartCountBackup = -1;
        this._implicitXAJoinCountBackup = -1;
    }

    private boolean _checkSession(Session session) {
        Session anchorSession = this._sessionPool.getAnchorSession();
        if (anchorSession != null && anchorSession.isNoneOrPrimarySite() && session.isSecondarySite()) {
            return false;
        }
        Address address = session.getAddress();
        return !(address instanceof PublicAddress) || !((PublicAddress)address).isReplicaRole();
    }

    private void _startDistributedTransaction() throws SQLException {
        boolean isImplicit;
        if (this._transactionState == TransactionState.DistributedTransaction) {
            return;
        }
        Session session = this._sessionPool.getPrimarySession();
        boolean bl = isImplicit = this._transactionID != null && this._connection.getEngineFeatures().isImplicitXASessionSupported();
        if (isImplicit) {
            ++this._implicitXAStartCount;
        } else {
            ++this._explicitXAStartCount;
            HRequestPacket requestPacket = this._connection.initStartDistributedTransaction(session);
            this._connection.exchange(session, requestPacket, null, new ConnectionSapDB.ExchangeFlag[0]);
        }
        this._transactionState = TransactionState.DistributedTransaction;
        this.joinDistributedTransaction(session);
        if (!isImplicit && this._hasBackup) {
            this.save();
        }
        if (this._tracer.on()) {
            this._tracer.printDistribution(this._connection, (isImplicit ? "Implicit " : "") + "Start Distributed Tx " + this.getDisplayTransactionID() + " on session " + session.getTraceString(true, false));
        }
    }

    private byte[] _joinDistributedTransaction(Session session, boolean allowImplicitXAJoin) throws SQLException {
        byte[] ret;
        EngineFeatures engineFeatures;
        boolean isImplicit;
        if (this.isPartOfDistributedTransaction(session)) {
            return null;
        }
        boolean bl = isImplicit = allowImplicitXAJoin && (engineFeatures = this._connection.getEngineFeatures()).isImplicitXASessionSupported() && (this._ddlAutoCommit || engineFeatures.supportImplicitXAJoinOnPrepare());
        if (isImplicit) {
            ++this._implicitXAJoinCount;
            ret = this._transactionID;
        } else {
            ++this._explicitXAJoinCount;
            HRequestPacket requestPacket = this._connection.initJoinDistributedTransaction(session, this._transactionID);
            this._connection.exchange(session, requestPacket, null, new ConnectionSapDB.ExchangeFlag[0]);
            ret = null;
        }
        this.joinDistributedTransaction(session);
        if (this._tracer.on()) {
            this._tracer.printDistribution(this._connection, (isImplicit ? "Implicit " : "") + "Join Distributed Tx " + this.getDisplayTransactionID() + " on session " + session.getTraceString(true, false));
        }
        return ret;
    }

    void resetCounts() {
        this._implicitXAStartCount = 0;
        this._implicitXAJoinCount = 0;
        this._explicitXAStartCount = 0;
        this._explicitXAJoinCount = 0;
        this._restoreCount = 0;
    }

    int getRestoreCount() {
        return this._restoreCount;
    }

    int getSavepointCount() {
        return this._savepointMap.size();
    }

    int getNumberOfSessionsInvolved() {
        return this._numberOfSessionsInvolved;
    }

    private static class SessionFlags {
        boolean _isPartOfTransaction;
        boolean _isPartOfDistributedTransaction;
        boolean _hasSentAsPartOfTransaction;

        private SessionFlags() {
        }

        private SessionFlags(SessionFlags other) {
            this._isPartOfTransaction = other._isPartOfTransaction;
            this._isPartOfDistributedTransaction = other._isPartOfDistributedTransaction;
            this._hasSentAsPartOfTransaction = other._hasSentAsPartOfTransaction;
        }
    }
}

