/*
 * Decompiled with CFR 0.152.
 */
package com.reachauto.vspcloud.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.reachauto.vspcloud.model.Headers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureUtils {
    private static final Logger log = LoggerFactory.getLogger(SignatureUtils.class);
    private static final String DELIMITER = "&";
    private static final String COMMA = ",";

    public static String signature(Headers headers, String rawPath, Map<String, Object> requestParams, Object body, String appSecret) {
        ArrayList<String> spliceList = new ArrayList<String>();
        spliceList.add(headers.spliceToString());
        spliceList.add(rawPath);
        if (Objects.nonNull(requestParams) && !requestParams.isEmpty()) {
            spliceList.add(SignatureUtils.spliceJson(JSON.toJSONString(requestParams)));
        }
        if (Objects.nonNull(body)) {
            if (body instanceof String) {
                spliceList.add(SignatureUtils.spliceJson(body.toString()));
            } else {
                spliceList.add(SignatureUtils.spliceJson(JSON.toJSONString((Object)body)));
            }
        }
        return SignatureUtils.signature(spliceList.toArray(new String[0]), appSecret);
    }

    private static String signature(String[] args, String appSecret) {
        String splice = Joiner.on((String)DELIMITER).join((Object[])args);
        log.info("splice string: {}", (Object)splice);
        return new HmacUtils(HmacAlgorithms.HMAC_SHA_256, appSecret).hmacHex(splice);
    }

    public static String spliceJson(String json) {
        List<String> list = SignatureUtils.splitJson(json);
        Collections.sort(list);
        return Joiner.on((String)DELIMITER).join(list);
    }

    private static List<String> splitJson(String json) {
        ArrayList<String> list = new ArrayList<String>();
        Object jsonObject = JSON.parse((String)json);
        if (jsonObject instanceof JSONArray) {
            SignatureUtils.splitJsonArray(list, (JSONArray)jsonObject);
        } else if (jsonObject instanceof JSONObject) {
            SignatureUtils.splitJsonObject(list, (JSONObject)jsonObject);
        } else {
            list.add(jsonObject.toString());
        }
        return list;
    }

    private static void splitJsonArray(List<String> list, JSONArray jsonArray) {
        for (Object object : jsonArray) {
            if (object instanceof JSONArray) {
                SignatureUtils.splitJsonArray(list, (JSONArray)object);
                continue;
            }
            if (object instanceof JSONObject) {
                SignatureUtils.splitJsonObject(list, (JSONObject)object);
                continue;
            }
            list.add(object.toString());
        }
    }

    private static void splitJsonObject(List<String> list, JSONObject object) {
        for (Map.Entry entry : object.entrySet()) {
            ArrayList<String> valueLst;
            Object value = entry.getValue();
            if (value instanceof JSONArray) {
                valueLst = new ArrayList<String>(16);
                SignatureUtils.splitJsonArray(valueLst, (JSONArray)value);
                Collections.sort(valueLst);
                list.add((String)entry.getKey() + "=" + Joiner.on((String)COMMA).join(valueLst));
                continue;
            }
            if (value instanceof JSONObject) {
                valueLst = new ArrayList(16);
                SignatureUtils.splitJsonObject(valueLst, (JSONObject)value);
                Collections.sort(valueLst);
                list.add((String)entry.getKey() + "=" + Joiner.on((String)COMMA).join(valueLst));
                continue;
            }
            list.add((String)entry.getKey() + "=" + entry.getValue().toString());
        }
    }
}

