/*
 * Decompiled with CFR 0.152.
 */
package com.reachauto.vspcloud;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.reachauto.vspcloud.model.Headers;
import com.reachauto.vspcloud.utils.SignatureUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;

public class VspCloudOpenApi {
    public Request buildGetRequest(String endPoint, String appId, String appSecret, String apiPath, Map<String, Object> requestHeaders, Map<String, Object> requestParams) {
        Request.Builder builder = this.openApiGetMethodBuilder(endPoint, appId, appSecret, apiPath, requestHeaders, requestParams);
        return builder.get().build();
    }

    public Request buildPostRequest(String endPoint, String appId, String appSecret, String apiPath, Map<String, Object> requestHeaders, Object body) {
        Request.Builder builder = this.openApiBuilder(endPoint, appId, appSecret, apiPath, requestHeaders, body);
        RequestBody requestBody = RequestBody.create((byte[])JSON.toJSONString((Object)body).getBytes());
        return builder.post(requestBody).build();
    }

    public Request buildDeleteRequest(String endPoint, String appId, String appSecret, String apiPath, Map<String, Object> requestHeaders, Object body) {
        Request.Builder builder = this.openApiBuilder(endPoint, appId, appSecret, apiPath, requestHeaders, body);
        if (Objects.isNull(body)) {
            return builder.delete().build();
        }
        RequestBody requestBody = RequestBody.create((byte[])JSON.toJSONString((Object)body).getBytes());
        return builder.delete(requestBody).build();
    }

    public Request buildPutRequest(String endPoint, String appId, String appSecret, String apiPath, Map<String, Object> requestHeaders, Object body) {
        Request.Builder builder = this.openApiBuilder(endPoint, appId, appSecret, apiPath, requestHeaders, body);
        RequestBody requestBody = RequestBody.create((byte[])JSON.toJSONString((Object)body).getBytes());
        return builder.put(requestBody).build();
    }

    private Request.Builder openApiGetMethodBuilder(String endPoint, String appId, String appSecret, String apiPath, Map<String, Object> requestHeaders, Map<String, Object> requestParams) {
        Headers headers = new Headers();
        headers.setAppId(appId);
        headers.setVersion("1.0");
        headers.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        if (Objects.isNull(requestParams) || requestParams.isEmpty()) {
            String signature = SignatureUtils.signature((Headers)headers, (String)apiPath, null, null, (String)appSecret);
            return this.build(endPoint, appId, apiPath, requestHeaders, headers, signature);
        }
        ArrayList<String> requestLst = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : requestParams.entrySet()) {
            requestLst.add(entry.getKey() + "=" + entry.getValue().toString());
        }
        String getApiPath = apiPath + "?" + Joiner.on((String)"&").join(requestLst);
        String signature = SignatureUtils.signature((Headers)headers, (String)apiPath, requestParams, null, (String)appSecret);
        return this.build(endPoint, appId, getApiPath, requestHeaders, headers, signature);
    }

    private Request.Builder openApiBuilder(String endPoint, String appId, String appSecret, String apiPath, Map<String, Object> requestHeaders, Object body) {
        Headers headers = new Headers();
        headers.setAppId(appId);
        headers.setVersion("1.0");
        headers.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        String signature = SignatureUtils.signature((Headers)headers, (String)apiPath, null, (Object)body, (String)appSecret);
        return this.build(endPoint, appId, apiPath, requestHeaders, headers, signature);
    }

    @NotNull
    private Request.Builder build(String endPoint, String appId, String apiPath, Map<String, Object> requestHeaders, Headers headers, String signature) {
        String url = endPoint + apiPath;
        Request.Builder builder = new Request.Builder().url(url).addHeader("appId", appId).addHeader("version", headers.getVersion()).addHeader("timestamp", String.valueOf(headers.getTimestamp())).addHeader("signature", signature);
        if (Objects.nonNull(requestHeaders)) {
            for (Map.Entry<String, Object> entry : requestHeaders.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue().toString());
            }
        }
        return builder;
    }
}

