/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import com.qcloud.cos.model.UploadResult;
import com.qcloud.cos.model.ciModel.common.ImageProcessRequest;
import com.qcloud.cos.model.ciModel.persistence.CIObject;
import com.qcloud.cos.model.ciModel.persistence.CIUploadResult;
import com.qcloud.cos.model.ciModel.persistence.PicOperations;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.Upload;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.LinkedList;

public class ImagePersistenceDemo {
    public static void persistenceImage(COSClient cosClient) {
        String bucketName = "examplebucket-1250000000";
        String key = "test.jpg";
        File localFile = new File("E://test.jpg");
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
        PicOperations picOperations = new PicOperations();
        picOperations.setIsPicInfo(1);
        LinkedList<PicOperations.Rule> ruleList = new LinkedList<PicOperations.Rule>();
        PicOperations.Rule rule1 = new PicOperations.Rule();
        rule1.setBucket(bucketName);
        rule1.setFileId("test-1.jpg");
        rule1.setRule("imageMogr2/rotate/90");
        ruleList.add(rule1);
        PicOperations.Rule rule2 = new PicOperations.Rule();
        rule2.setBucket(bucketName);
        rule2.setFileId("test-2.jpg");
        rule2.setRule("imageMogr2/rotate/180");
        ruleList.add(rule2);
        picOperations.setRules(ruleList);
        putObjectRequest.setPicOperations(picOperations);
        try {
            PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
            CIUploadResult ciUploadResult = putObjectResult.getCiUploadResult();
            System.out.println(putObjectResult.getRequestId());
            for (CIObject ciObject : ciUploadResult.getProcessResults().getObjectList()) {
                System.out.println(ciObject.getLocation());
                System.out.println(ciObject.getEtag());
            }
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
    }

    public static void persistenceImageWithAigcMetadata(COSClient cosClient) {
        String bucketName = "examplebucket-1250000000";
        String key = "test.jpg";
        File localFile = new File("E://test.jpg");
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
        PicOperations picOperations = new PicOperations();
        picOperations.setIsPicInfo(1);
        LinkedList<PicOperations.Rule> ruleList = new LinkedList<PicOperations.Rule>();
        PicOperations.Rule rule1 = new PicOperations.Rule();
        rule1.setBucket(bucketName);
        rule1.setFileId("test-1.jpg");
        String label = Base64.getUrlEncoder().withoutPadding().encodeToString("label".getBytes(StandardCharsets.UTF_8));
        String contentProducer = Base64.getUrlEncoder().withoutPadding().encodeToString("content_producer".getBytes(StandardCharsets.UTF_8));
        String produceId = Base64.getUrlEncoder().withoutPadding().encodeToString("produce_id".getBytes(StandardCharsets.UTF_8));
        String reservedCode1 = Base64.getUrlEncoder().withoutPadding().encodeToString("reserved_code1".getBytes(StandardCharsets.UTF_8));
        String reservedCode2 = Base64.getUrlEncoder().withoutPadding().encodeToString("reserved_code2".getBytes(StandardCharsets.UTF_8));
        String propagateId = Base64.getUrlEncoder().withoutPadding().encodeToString("propagate_id".getBytes(StandardCharsets.UTF_8));
        String contentPropagator = Base64.getUrlEncoder().withoutPadding().encodeToString("content_propagator".getBytes(StandardCharsets.UTF_8));
        String rule = "imageMogr2/AIGCMetadata/Label/" + label + "/ContentProducer/" + contentProducer + "/ProduceID/" + produceId + "/ReservedCode1/" + reservedCode1 + "/ReservedCode2/" + reservedCode2 + "/PropagateID/" + propagateId + "/ContentPropagator/" + contentPropagator;
        rule1.setRule(rule);
        ruleList.add(rule1);
        PicOperations.Rule rule2 = new PicOperations.Rule();
        rule2.setBucket(bucketName);
        rule2.setFileId("test-2.jpg");
        rule2.setRule("imageMogr2/rotate/180");
        ruleList.add(rule2);
        picOperations.setRules(ruleList);
        putObjectRequest.setPicOperations(picOperations);
        try {
            PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
            CIUploadResult ciUploadResult = putObjectResult.getCiUploadResult();
            System.out.println(putObjectResult.getRequestId());
            for (CIObject ciObject : ciUploadResult.getProcessResults().getObjectList()) {
                System.out.println(ciObject.getLocation());
                System.out.println(ciObject.getEtag());
                System.out.println(ciObject.getAigcMetadata());
            }
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
    }

    public static void persistenceImageWithMultipart(COSClient cosClient) throws FileNotFoundException {
        String bucketName = "examplebucket-1250000000";
        String key = "test.jpg";
        File localFile = new File("E://test.jpg");
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(bucketName, key);
        InitiateMultipartUploadResult initResult = cosClient.initiateMultipartUpload(request);
        String uploadId = initResult.getUploadId();
        LinkedList<PartETag> partETags = new LinkedList<PartETag>();
        UploadPartRequest uploadPartRequest = new UploadPartRequest();
        uploadPartRequest.setBucketName(bucketName);
        uploadPartRequest.setKey(key);
        uploadPartRequest.setUploadId(uploadId);
        uploadPartRequest.setInputStream(new FileInputStream(localFile));
        uploadPartRequest.setPartSize(localFile.length());
        uploadPartRequest.setPartNumber(1);
        UploadPartResult uploadPartResult = cosClient.uploadPart(uploadPartRequest);
        PartETag partETag = uploadPartResult.getPartETag();
        partETags.add(partETag);
        PicOperations picOperations = new PicOperations();
        picOperations.setIsPicInfo(1);
        LinkedList<PicOperations.Rule> ruleList = new LinkedList<PicOperations.Rule>();
        PicOperations.Rule rule1 = new PicOperations.Rule();
        rule1.setBucket(bucketName);
        rule1.setFileId("test-1.jpg");
        rule1.setRule("imageMogr2/rotate/90");
        ruleList.add(rule1);
        PicOperations.Rule rule2 = new PicOperations.Rule();
        rule2.setBucket(bucketName);
        rule2.setFileId("test-2.jpg");
        rule2.setRule("imageMogr2/rotate/180");
        ruleList.add(rule2);
        picOperations.setRules(ruleList);
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, key, uploadId, partETags);
        completeMultipartUploadRequest.setPicOperations(picOperations);
        CompleteMultipartUploadResult completeMultipartUploadResult = cosClient.completeMultipartUpload(completeMultipartUploadRequest);
        CIUploadResult ciUploadResult = completeMultipartUploadResult.getCiUploadResult();
        System.out.println(completeMultipartUploadResult.getRequestId());
        System.out.println(ciUploadResult.getOriginalInfo().getEtag());
        for (CIObject ciObject : ciUploadResult.getProcessResults().getObjectList()) {
            System.out.println(ciObject.getLocation());
            System.out.println(ciObject.getEtag());
        }
    }

    public static void persistenceImageWithTransferManager(TransferManager transferManager) throws InterruptedException {
        String bucketName = "examplebucket-1250000000";
        String key = "test.jpg";
        File localFile = new File("E://test.jpg");
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
        PicOperations picOperations = new PicOperations();
        picOperations.setIsPicInfo(1);
        LinkedList<PicOperations.Rule> ruleList = new LinkedList<PicOperations.Rule>();
        PicOperations.Rule rule1 = new PicOperations.Rule();
        rule1.setBucket(bucketName);
        rule1.setFileId("test-1.jpg");
        rule1.setRule("imageMogr2/rotate/90");
        ruleList.add(rule1);
        PicOperations.Rule rule2 = new PicOperations.Rule();
        rule2.setBucket(bucketName);
        rule2.setFileId("test-2.jpg");
        rule2.setRule("imageMogr2/rotate/180");
        ruleList.add(rule2);
        picOperations.setRules(ruleList);
        putObjectRequest.setPicOperations(picOperations);
        Upload upload = transferManager.upload(putObjectRequest);
        UploadResult uploadResult = upload.waitForUploadResult();
        CIUploadResult ciUploadResult = uploadResult.getCiUploadResult();
        System.out.println(uploadResult.getRequestId());
        System.out.println(ciUploadResult.getOriginalInfo().getEtag());
        for (CIObject ciObject : ciUploadResult.getProcessResults().getObjectList()) {
            System.out.println(ciObject.getLocation());
            System.out.println(ciObject.getEtag());
        }
    }

    public static void persistenceImagePost(COSClient cosClient) {
        String bucketName = "examplebucket-1250000000";
        String key = "test.jpg";
        ImageProcessRequest imageReq = new ImageProcessRequest(bucketName, key);
        PicOperations picOperations = new PicOperations();
        picOperations.setIsPicInfo(1);
        LinkedList<PicOperations.Rule> ruleList = new LinkedList<PicOperations.Rule>();
        PicOperations.Rule rule1 = new PicOperations.Rule();
        rule1.setBucket(bucketName);
        rule1.setFileId("test-1.jpg");
        rule1.setRule("imageMogr2/rotate/90");
        ruleList.add(rule1);
        PicOperations.Rule rule2 = new PicOperations.Rule();
        rule2.setBucket(bucketName);
        rule2.setFileId("test-2.jpg");
        rule2.setRule("imageMogr2/rotate/180");
        ruleList.add(rule2);
        picOperations.setRules(ruleList);
        imageReq.setPicOperations(picOperations);
        try {
            CIUploadResult ciUploadResult = cosClient.processImage(imageReq);
            System.out.println(ciUploadResult.getOriginalInfo().getEtag());
            for (CIObject ciObject : ciUploadResult.getProcessResults().getObjectList()) {
                System.out.println(ciObject.getLocation());
                System.out.println(ciObject.getEtag());
            }
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
    }

    public static void persistenceImagePostWithAigcMetadata(COSClient cosClient) {
        String bucketName = "examplebucket-1250000000";
        String key = "test.jpg";
        ImageProcessRequest imageReq = new ImageProcessRequest(bucketName, key);
        PicOperations picOperations = new PicOperations();
        picOperations.setIsPicInfo(1);
        LinkedList<PicOperations.Rule> ruleList = new LinkedList<PicOperations.Rule>();
        PicOperations.Rule rule1 = new PicOperations.Rule();
        rule1.setBucket(bucketName);
        rule1.setFileId("test-1.jpg");
        String label = Base64.getUrlEncoder().withoutPadding().encodeToString("label".getBytes(StandardCharsets.UTF_8));
        String contentProducer = Base64.getUrlEncoder().withoutPadding().encodeToString("content_producer".getBytes(StandardCharsets.UTF_8));
        String produceId = Base64.getUrlEncoder().withoutPadding().encodeToString("produce_id".getBytes(StandardCharsets.UTF_8));
        String reservedCode1 = Base64.getUrlEncoder().withoutPadding().encodeToString("reserved_code1".getBytes(StandardCharsets.UTF_8));
        String reservedCode2 = Base64.getUrlEncoder().withoutPadding().encodeToString("reserved_code2".getBytes(StandardCharsets.UTF_8));
        String propagateId = Base64.getUrlEncoder().withoutPadding().encodeToString("propagate_id".getBytes(StandardCharsets.UTF_8));
        String contentPropagator = Base64.getUrlEncoder().withoutPadding().encodeToString("content_propagator".getBytes(StandardCharsets.UTF_8));
        String rule = "imageMogr2/AIGCMetadata/Label/" + label + "/ContentProducer/" + contentProducer + "/ProduceID/" + produceId + "/ReservedCode1/" + reservedCode1 + "/ReservedCode2/" + reservedCode2 + "/PropagateID/" + propagateId + "/ContentPropagator/" + contentPropagator;
        rule1.setRule(rule);
        ruleList.add(rule1);
        PicOperations.Rule rule2 = new PicOperations.Rule();
        rule2.setBucket(bucketName);
        rule2.setFileId("test-2.jpg");
        rule2.setRule("imageMogr2/rotate/180");
        ruleList.add(rule2);
        picOperations.setRules(ruleList);
        imageReq.setPicOperations(picOperations);
        try {
            CIUploadResult ciUploadResult = cosClient.processImage(imageReq);
            System.out.println(ciUploadResult.getOriginalInfo().getEtag());
            for (CIObject ciObject : ciUploadResult.getProcessResults().getObjectList()) {
                System.out.println(ciObject.getLocation());
                System.out.println(ciObject.getEtag());
                System.out.println(ciObject.getAigcMetadata());
            }
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        COSClient cosClient = ClientUtils.getTestClient();
        ImagePersistenceDemo.persistenceImage(cosClient);
        cosClient.shutdown();
    }
}

