/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.ns.NetException;
import oracle.net.nt.ExtendedSSLContext;
import oracle.net.nt.SSLConfig;
import oracle.net.nt.SSLContextCache;
import oracle.net.nt.TcpsConfigure;
import oracle.security.jps.service.keystore.KeyStoreServiceLoadStoreParameter;

public class CustomSSLSocketFactory {
    private static final String CLASS_NAME = CustomSSLSocketFactory.class.getName();
    DMSFactory.DMSNoun dmsParent = null;

    private CustomSSLSocketFactory() {
    }

    public static SSLEngine getSSLSocketEngine(String host, int port, @Blind(value=PropertiesBlinder.class) Properties sslSocketProperties, Diagnosable diagnosable) throws IOException {
        diagnosable.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "getSSLSocketEngine", "Creating SSLSocketEngine..", null, null);
        SSLConfig config = SSLConfig.newInstance(sslSocketProperties);
        SSLEngine sslEngine = SSLContextCache.instance().get(config, diagnosable).context().createSSLEngine(host, port);
        TcpsConfigure.configure(sslEngine, sslSocketProperties, diagnosable);
        return sslEngine;
    }

    public static SSLSocketFactory getSSLSocketFactory(Properties sslSocketProperties, DMSFactory.DMSNoun dmsParent, Diagnosable diagnosable) throws IOException {
        diagnosable.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "getSSLSocketFactory", "Creating SSLSocketFactory..", null, null);
        SSLConfig config = SSLConfig.newInstance(sslSocketProperties);
        return SSLContextCache.instance().get(config, diagnosable).context().getSocketFactory();
    }

    static ExtendedSSLContext getSSLContext(SSLConfig config, Diagnosable diagnosable) throws IOException {
        if (config.useSystemKeystore()) {
            diagnosable.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "getSSLContext", "Keystore and Truststore is set to 'NONE'. Using the default SSLContext.", null, null);
            try {
                return ExtendedSSLContext.wrap(SSLContext.getDefault());
            }
            catch (NoSuchAlgorithmException nae) {
                NetException netException = new NetException(17959);
                netException.initCause(nae);
                throw netException;
            }
        }
        return CustomSSLSocketFactory.newSSLContext(config, diagnosable);
    }

    private static ExtendedSSLContext newSSLContext(SSLConfig config, Diagnosable diagnosable) throws NetException {
        diagnosable.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "newSSLContext", "Creating SSLContext for the config = {0}", (String)null, null, (Object)config);
        try {
            return ExtendedSSLContext.newInstance(config);
        }
        catch (Exception ex) {
            diagnosable.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "newSSLContext", "Error in initializing ssl context {0}", (String)null, null, (Object)ex.toString());
            if (ex instanceof NetException) {
                throw (NetException)ex;
            }
            throw (NetException)new NetException(17959).initCause(ex);
        }
    }

    static KeyStore mergeCaCerts(KeyStore trustStore) throws IOException, GeneralSecurityException {
        TrustManagerFactory caCertsTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        try {
            caCertsTrustManagerFactory.init((KeyStore)null);
        }
        catch (NullPointerException | KeyStoreException exception) {
            caCertsTrustManagerFactory.init(CustomSSLSocketFactory.loadCaCerts());
        }
        for (TrustManager trustManager : caCertsTrustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            for (X509Certificate certificate : ((X509TrustManager)trustManager).getAcceptedIssuers()) {
                String alias = certificate.getIssuerX500Principal().getName();
                if (trustStore.containsAlias(alias)) continue;
                trustStore.setCertificateEntry(alias, certificate);
            }
        }
        return trustStore;
    }

    private static KeyStore loadCaCerts() throws IOException, GeneralSecurityException {
        try {
            return CustomSSLSocketFactory.loadCaCerts("PKCS12", "SUN");
        }
        catch (IOException | GeneralSecurityException exception0) {
            try {
                return CustomSSLSocketFactory.loadCaCerts("JKS", "SUN");
            }
            catch (IOException | GeneralSecurityException exception1) {
                exception1.addSuppressed(exception0);
                throw exception1;
            }
        }
    }

    private static KeyStore loadCaCerts(String type, String provider) throws IOException, GeneralSecurityException {
        try (InputStream inputStream = Files.newInputStream(Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts"), new OpenOption[0]);){
            KeyStore cacerts = KeyStore.getInstance(type, provider);
            cacerts.load(inputStream, null);
            KeyStore keyStore = cacerts;
            return keyStore;
        }
    }

    static KeyStore getKeyStoreInstance(String type, Diagnosable diagnosable) throws KeyStoreException {
        if ("PEM".equals(type)) {
            type = "PKCS12";
        }
        try {
            return KeyStore.getInstance(type);
        }
        catch (KeyStoreException err) {
            try {
                Provider provider = CustomSSLSocketFactory.loadKnownProvider(type);
                if (provider == null) {
                    throw err;
                }
                return KeyStore.getInstance(type, provider);
            }
            catch (Exception loadProviderError) {
                diagnosable.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "getKeyStoreInstance", "Failed to load a known provider for keystore type {0}, exception {1}", (String)null, null, (Object)type, (Object)loadProviderError);
                throw err;
            }
        }
    }

    private static Provider loadKnownProvider(String type) throws Exception {
        Class<?> clazz;
        Provider providerObject = null;
        String providerClass = switch (type.toUpperCase()) {
            case "SSO" -> "oracle.security.pki.OraclePKIProvider";
            case "KSS" -> "oracle.security.jps.internal.keystore.provider.FarmKeyStoreProvider";
            default -> null;
        };
        if (providerClass != null && (clazz = Class.forName(providerClass)) != null && Provider.class.isAssignableFrom(clazz)) {
            providerObject = AccessController.doPrivileged(() -> (Provider)clazz.newInstance());
        }
        return providerObject;
    }

    static void loadFileBasedKeyStore(KeyStore keyStore, String path, OpaqueString password) throws IOException, NoSuchAlgorithmException, CertificateException {
        try (InputStream fileStream = Channels.newInputStream(FileChannel.open(Paths.get(path, new String[0]), StandardOpenOption.READ));){
            CustomSSLSocketFactory.loadKeyStore(keyStore, fileStream, password);
        }
    }

    static void loadKSSKeyStore(KeyStore keyStore, String uri, OpaqueString password) throws IOException, NoSuchAlgorithmException, CertificateException {
        final class KSSLoader {
            KSSLoader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void load(KeyStore ks, String uri, OpaqueString password) throws IOException, NoSuchAlgorithmException, CertificateException {
                KeyStoreServiceLoadStoreParameter param = new KeyStoreServiceLoadStoreParameter();
                if (!OpaqueString.isNull(password)) {
                    char[] pw = password.getChars();
                    try {
                        param.setProtectionParameter((KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(pw));
                    }
                    catch (Throwable throwable) {
                        for (int i = 0; i < pw.length; ++i) {
                            pw[i] = '\u0000';
                        }
                        throw throwable;
                    }
                    for (int i = 0; i < pw.length; ++i) {
                        pw[i] = '\u0000';
                    }
                }
                param.setKssUri(uri);
                ks.load((KeyStore.LoadStoreParameter)param);
            }
        }
        new KSSLoader().load(keyStore, uri, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadKeyStore(KeyStore keyStore, InputStream inputStream, OpaqueString password) throws NoSuchAlgorithmException, CertificateException, IOException {
        char[] pw = password.getChars();
        try {
            keyStore.load(inputStream, pw);
        }
        finally {
            CustomSSLSocketFactory.clearPwd(pw);
        }
    }

    static void clearPwd(char[] pwd) {
        if (pwd != null) {
            Arrays.fill(pwd, '\u0000');
        }
    }
}

