/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.mock.jdbc.MockDriver;
import com.mockrunner.mock.jdbc.PolyResultSet;
import com.mockrunner.util.common.StringUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class MockDatabaseMetaData
implements DatabaseMetaData {
    private boolean caseSensitive = false;
    private int databaseMajorVersion = 1;
    private int databaseMinorVersion = 0;
    private int defaultTransactionLevel = 2;
    private int driverMajorVersion = 1;
    private int driverMinorVersion = 0;
    private int jdbcMajorVersion = 3;
    private int jdbcMinorVersion = 0;
    private int maxBinaryLiteralLength = 0;
    private int maxCatalogNameLength = 0;
    private int maxCharLiteralLength = 0;
    private int maxColumnNameLength = 0;
    private int maxColumnsInGroupBy = 0;
    private int maxColumnsInIndex = 0;
    private int maxColumnsInOrderBy = 0;
    private int maxColumnsInSelect = 0;
    private int maxColumnsInTable = 0;
    private int maxConnections = 0;
    private int maxCursorNameLength = 0;
    private int maxIndexLength = 0;
    private int maxProcedureNameLength = 0;
    private int maxRowSize = 0;
    private int maxSchemaNameLength = 0;
    private int maxStatementLength = 0;
    private int maxStatements = 0;
    private int maxTableNameLength = 0;
    private int maxTablesInSelect = 0;
    private int maxUserNameLength = 0;
    private int resultSetHoldability = 1;
    private int sqlStateType = 2;
    private RowIdLifetime rowIdLifetime = RowIdLifetime.ROWID_VALID_TRANSACTION;
    private boolean autoCommitFailureClosesAllResultSets = false;
    private boolean allProceduresAreCallable = true;
    private boolean allTablesAreSelectable = true;
    private boolean dataDefinitionCausesTransactionCommit = false;
    private boolean dataDefinitionIgnoredInTransactions = false;
    private boolean doesMaxRowSizeIncludeBlobs = false;
    private boolean isCatalogAtStart = false;
    private boolean isReadOnly = false;
    private boolean locatorsUpdateCopy = false;
    private boolean nullPlusNonNullIsNull = false;
    private boolean nullsAreSortedAtEnd = false;
    private boolean nullsAreSortedAtStart = false;
    private boolean nullsAreSortedHigh = false;
    private boolean nullsAreSortedLow = false;
    private boolean storesLowerCaseIdentifiers = true;
    private boolean storesLowerCaseQuotedIdentifiers = true;
    private boolean storesMixedCaseIdentifiers = true;
    private boolean storesMixedCaseQuotedIdentifiers = true;
    private boolean storesUpperCaseIdentifiers = true;
    private boolean storesUpperCaseQuotedIdentifiers = true;
    private boolean supportsANSI92EntryLevelSQL = true;
    private boolean supportsANSI92FullSQL = true;
    private boolean supportsANSI92IntermediateSQL = true;
    private boolean supportsAlterTableWithAddColumn = true;
    private boolean supportsAlterTableWithDropColumn = true;
    private boolean supportsBatchUpdates = true;
    private boolean supportsCatalogsInDataManipulation = true;
    private boolean supportsCatalogsInIndexDefinitions = true;
    private boolean supportsCatalogsInPrivilegeDefinitions = true;
    private boolean supportsCatalogsInProcedureCalls = true;
    private boolean supportsCatalogsInTableDefinitions = true;
    private boolean supportsColumnAliasing = true;
    private boolean supportsConvert = true;
    private boolean supportsCoreSQLGrammar = true;
    private boolean supportsCorrelatedSubqueries = true;
    private boolean supportsDataDefinitionAndDataManipulationTransactions = true;
    private boolean supportsDataManipulationTransactionsOnly = false;
    private boolean supportsDifferentTableCorrelationNames;
    private boolean supportsExpressionsInOrderBy = true;
    private boolean supportsExtendedSQLGrammar = true;
    private boolean supportsFullOuterJoins = true;
    private boolean supportsGetGeneratedKeys = true;
    private boolean supportsGroupBy = true;
    private boolean supportsGroupByBeyondSelect = true;
    private boolean supportsGroupByUnrelated = true;
    private boolean supportsIntegrityEnhancementFacility = true;
    private boolean supportsLikeEscapeClause = true;
    private boolean supportsLimitedOuterJoins = true;
    private boolean supportsMinimumSQLGrammar = true;
    private boolean supportsMixedCaseIdentifiers = true;
    private boolean supportsMixedCaseQuotedIdentifiers = true;
    private boolean supportsMultipleOpenResults = true;
    private boolean supportsMultipleResultSets = true;
    private boolean supportsMultipleTransactions = true;
    private boolean supportsNamedParameters = true;
    private boolean supportsNonNullableColumns = true;
    private boolean supportsOpenCursorsAcrossCommit = true;
    private boolean supportsOpenCursorsAcrossRollback = true;
    private boolean supportsOpenStatementsAcrossCommit = true;
    private boolean supportsOpenStatementsAcrossRollback = true;
    private boolean supportsOrderByUnrelated = true;
    private boolean supportsOuterJoins = true;
    private boolean supportsPositionedDelete = true;
    private boolean supportsPositionedUpdate = true;
    private boolean supportsSavepoints = true;
    private boolean supportsSchemasInDataManipulation = true;
    private boolean supportsSchemasInIndexDefinitions = true;
    private boolean supportsSchemasInPrivilegeDefinitions = true;
    private boolean supportsSchemasInProcedureCalls = true;
    private boolean supportsSchemasInTableDefinitions = true;
    private boolean supportsSelectForUpdate = true;
    private boolean supportsStatementPooling = true;
    private boolean supportsStoredProcedures = true;
    private boolean supportsSubqueriesInComparisons = true;
    private boolean supportsSubqueriesInExists = true;
    private boolean supportsSubqueriesInIns = true;
    private boolean supportsSubqueriesInQuantifieds = true;
    private boolean supportsTableCorrelationNames = true;
    private boolean supportsTransactions = true;
    private boolean supportsUnion = true;
    private boolean supportsUnionAll = true;
    private boolean usesLocalFilePerTable = false;
    private boolean usesLocalFiles = true;
    private boolean deletesAreDetected = true;
    private boolean insertsAreDetected = true;
    private boolean othersDeletesAreVisible = true;
    private boolean othersInsertsAreVisible = true;
    private boolean othersUpdatesAreVisible = true;
    private boolean ownDeletesAreVisible = true;
    private boolean ownInsertsAreVisible = true;
    private boolean ownUpdatesAreVisible = true;
    private boolean supportsResultSetHoldability = true;
    private boolean supportsResultSetType = true;
    private boolean supportsTransactionIsolationLevel = true;
    private boolean updatesAreDetected = true;
    private boolean supportsResultSetConcurrency = true;
    private boolean supportsStoredFunctionsUsingCallSyntax = true;
    private boolean generatedKeysAlwaysReturned = false;
    private String catalogSeparator = ".";
    private String catalogTerm = "database";
    private String databaseProductName = "MockDatabase";
    private String databaseProductVersion = "1.0";
    private String driverName = MockDriver.class.getName();
    private String driverVersion = "1.0";
    private String extraNameCharacters = "";
    private String identifierQuoteString = " ";
    private String numericFunctions = "";
    private String procedureTerm = "";
    private String sqlKeywords = "";
    private String schemaTerm = "";
    private String searchStringEscape = "\\";
    private String stringFunctions = "";
    private String systemFunctions = "";
    private String timeDateFunctions = "";
    private String url;
    private String userName;
    private Connection connection;
    private ResultSet catalogs;
    private ResultSet tableTypes;
    private ResultSet typeInfo;
    private ResultSet clientInfoProperties;
    private Map<DatabaseIdentifier, ResultSet> schemasMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> exportedKeysMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> importedKeysMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> primaryKeysMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> proceduresMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> functionsMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> superTablesMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> superTypesMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> tablePrivilegesMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> versionColumnsMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> bestRowIdentifierMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> indexInfoMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> udtsMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> attributesMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> columnPrivilegesMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> columnsMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> procedureColumnsMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> functionColumnsMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> tablesMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> crossReferenceMap = new HashMap<DatabaseIdentifier, ResultSet>();
    private Map<DatabaseIdentifier, ResultSet> pseudoColumnsMap = new HashMap<DatabaseIdentifier, ResultSet>();

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.databaseMajorVersion;
    }

    public void setDatabaseMajorVersion(int version) {
        this.databaseMajorVersion = version;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.databaseMinorVersion;
    }

    public void setDatabaseMinorVersion(int version) {
        this.databaseMinorVersion = version;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return this.defaultTransactionLevel;
    }

    public void setDefaultTransactionIsolation(int defaultTransactionLevel) {
        this.defaultTransactionLevel = defaultTransactionLevel;
    }

    @Override
    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    public void setDriverMajorVersion(int driverMajorVersion) {
        this.driverMajorVersion = driverMajorVersion;
    }

    @Override
    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    public void setDriverMinorVersion(int driverMinorVersion) {
        this.driverMinorVersion = driverMinorVersion;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return this.jdbcMajorVersion;
    }

    public void setJDBCMajorVersion(int jdbcMajorVersion) {
        this.jdbcMajorVersion = jdbcMajorVersion;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return this.jdbcMinorVersion;
    }

    public void setJDBCMinorVersion(int jdbcMinorVersion) {
        this.jdbcMinorVersion = jdbcMinorVersion;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.maxBinaryLiteralLength;
    }

    public void setMaxBinaryLiteralLength(int maxBinaryLiteralLength) {
        this.maxBinaryLiteralLength = maxBinaryLiteralLength;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return this.maxCatalogNameLength;
    }

    public void setetMaxCatalogNameLength(int maxCatalogNameLength) {
        this.maxCatalogNameLength = maxCatalogNameLength;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return this.maxCharLiteralLength;
    }

    public void setMaxCharLiteralLength(int maxCharLiteralLength) {
        this.maxCharLiteralLength = maxCharLiteralLength;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.maxColumnNameLength;
    }

    public void setMaxColumnNameLength(int maxColumnNameLength) {
        this.maxColumnNameLength = maxColumnNameLength;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.maxColumnsInGroupBy;
    }

    public void setMaxColumnsInGroupBy(int maxColumnsInGroupBy) {
        this.maxColumnsInGroupBy = maxColumnsInGroupBy;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return this.maxColumnsInIndex;
    }

    public void setMaxColumnsInIndex(int maxColumnsInIndex) {
        this.maxColumnsInIndex = maxColumnsInIndex;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.maxColumnsInOrderBy;
    }

    public void setMaxColumnsInOrderBy(int maxColumnsInOrderBy) {
        this.maxColumnsInOrderBy = maxColumnsInOrderBy;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return this.maxColumnsInSelect;
    }

    public void setMaxColumnsInSelect(int maxColumnsInSelect) {
        this.maxColumnsInSelect = maxColumnsInSelect;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return this.maxColumnsInTable;
    }

    public void setMaxColumnsInTable(int maxColumnsInTable) {
        this.maxColumnsInTable = maxColumnsInTable;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return this.maxCursorNameLength;
    }

    public void setMaxCursorNameLength(int maxCursorNameLength) {
        this.maxCursorNameLength = maxCursorNameLength;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return this.maxIndexLength;
    }

    public void setMaxIndexLength(int maxIndexLength) {
        this.maxIndexLength = maxIndexLength;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.maxProcedureNameLength;
    }

    public void setMaxProcedureNameLength(int maxProcedureNameLength) {
        this.maxProcedureNameLength = maxProcedureNameLength;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return this.maxRowSize;
    }

    public void setMaxRowSize(int maxRowSize) {
        this.maxRowSize = maxRowSize;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return this.maxSchemaNameLength;
    }

    public void setMaxSchemaNameLength(int maxSchemaNameLength) {
        this.maxSchemaNameLength = maxSchemaNameLength;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return this.maxStatementLength;
    }

    public void setMaxStatementLength(int maxStatementLength) {
        this.maxStatementLength = maxStatementLength;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return this.maxStatements;
    }

    public void setMaxStatements(int maxStatements) {
        this.maxStatements = maxStatements;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.maxTableNameLength;
    }

    public void setMaxTableNameLength(int maxTableNameLength) {
        this.maxTableNameLength = maxTableNameLength;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return this.maxTablesInSelect;
    }

    public void setMaxTablesInSelect(int maxTablesInSelect) {
        this.maxTablesInSelect = maxTablesInSelect;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.maxUserNameLength;
    }

    public void setMaxUserNameLength(int maxUserNameLength) {
        this.maxUserNameLength = maxUserNameLength;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    public void setResultSetHoldability(int resultSetHoldability) {
        this.resultSetHoldability = resultSetHoldability;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return this.sqlStateType;
    }

    public void setSQLStateType(int sqlStateType) {
        this.sqlStateType = sqlStateType;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return this.rowIdLifetime;
    }

    public void setRowIdLifetime(RowIdLifetime rowIdLifetime) {
        this.rowIdLifetime = rowIdLifetime;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return this.autoCommitFailureClosesAllResultSets;
    }

    public void setAutoCommitFailureClosesAllResultSets(boolean closesAllResultSets) {
        this.autoCommitFailureClosesAllResultSets = closesAllResultSets;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return this.allProceduresAreCallable;
    }

    public void setAllProceduresAreCallable(boolean callable) {
        this.allProceduresAreCallable = callable;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return this.allTablesAreSelectable;
    }

    public void setAllTablesAreSelectable(boolean selectable) {
        this.allTablesAreSelectable = selectable;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.dataDefinitionCausesTransactionCommit;
    }

    public void setDataDefinitionCausesTransactionCommit(boolean causesCommit) {
        this.dataDefinitionCausesTransactionCommit = causesCommit;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return this.dataDefinitionIgnoredInTransactions;
    }

    public void setDataDefinitionIgnoredInTransactions(boolean ignored) {
        this.dataDefinitionIgnoredInTransactions = ignored;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return this.doesMaxRowSizeIncludeBlobs;
    }

    public void setDoesMaxRowSizeIncludeBlobs(boolean includeBlobs) {
        this.doesMaxRowSizeIncludeBlobs = includeBlobs;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return this.isCatalogAtStart;
    }

    public void setIsCatalogAtStart(boolean isCatalogAtStart) {
        this.isCatalogAtStart = isCatalogAtStart;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.isReadOnly;
    }

    public void setIsReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return this.locatorsUpdateCopy;
    }

    public void setLocatorsUpdateCopy(boolean locatorsUpdateCopy) {
        this.locatorsUpdateCopy = locatorsUpdateCopy;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return this.nullPlusNonNullIsNull;
    }

    public void setNullPlusNonNullIsNull(boolean nullPlusNonNullIsNull) {
        this.nullPlusNonNullIsNull = nullPlusNonNullIsNull;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.nullsAreSortedAtEnd;
    }

    public void setNullsAreSortedAtEnd(boolean nullsAreSortedAtEnd) {
        this.nullsAreSortedAtEnd = nullsAreSortedAtEnd;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return this.nullsAreSortedAtStart;
    }

    public void setNullsAreSortedAtStart(boolean nullsAreSortedAtStart) {
        this.nullsAreSortedAtStart = nullsAreSortedAtStart;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return this.nullsAreSortedHigh;
    }

    public void setNullsAreSortedHigh(boolean nullsAreSortedHigh) {
        this.nullsAreSortedHigh = nullsAreSortedHigh;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return this.nullsAreSortedLow;
    }

    public void setNullsAreSortedLow(boolean nullsAreSortedLow) {
        this.nullsAreSortedLow = nullsAreSortedLow;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.storesLowerCaseIdentifiers;
    }

    public void setStoresLowerCaseIdentifiers(boolean storesLowerCaseIdentifiers) {
        this.storesLowerCaseIdentifiers = storesLowerCaseIdentifiers;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.storesLowerCaseQuotedIdentifiers;
    }

    public void setStoresLowerCaseQuotedIdentifiers(boolean storesLowerCaseQuotedIdentifiers) {
        this.storesLowerCaseQuotedIdentifiers = storesLowerCaseQuotedIdentifiers;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.storesMixedCaseIdentifiers;
    }

    public void setStoresMixedCaseIdentifiers(boolean storesMixedCaseIdentifiers) {
        this.storesMixedCaseIdentifiers = storesMixedCaseIdentifiers;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.storesMixedCaseQuotedIdentifiers;
    }

    public void setStoresMixedCaseQuotedIdentifiers(boolean storesMixedCaseQuotedIdentifiers) {
        this.storesMixedCaseQuotedIdentifiers = storesMixedCaseQuotedIdentifiers;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.storesUpperCaseIdentifiers;
    }

    public void setStoresUpperCaseIdentifiers(boolean storesUpperCaseIdentifiers) {
        this.storesUpperCaseIdentifiers = storesUpperCaseIdentifiers;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.storesUpperCaseQuotedIdentifiers;
    }

    public void setStoresUpperCaseQuotedIdentifiers(boolean storesUpperCaseQuotedIdentifiers) {
        this.storesUpperCaseQuotedIdentifiers = storesUpperCaseQuotedIdentifiers;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return this.supportsANSI92EntryLevelSQL;
    }

    public void setSupportsANSI92EntryLevelSQL(boolean supportsANSI92EntryLevelSQL) {
        this.supportsANSI92EntryLevelSQL = supportsANSI92EntryLevelSQL;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return this.supportsANSI92FullSQL;
    }

    public void setSupportsANSI92FullSQL(boolean supportsANSI92FullSQL) {
        this.supportsANSI92FullSQL = supportsANSI92FullSQL;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return this.supportsANSI92IntermediateSQL;
    }

    public void setSupportsANSI92IntermediateSQL(boolean supportsANSI92IntermediateSQL) {
        this.supportsANSI92IntermediateSQL = supportsANSI92IntermediateSQL;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return this.supportsAlterTableWithAddColumn;
    }

    public void setSupportsAlterTableWithAddColumn(boolean supportsAlterTableWithAddColumn) {
        this.supportsAlterTableWithAddColumn = supportsAlterTableWithAddColumn;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return this.supportsAlterTableWithDropColumn;
    }

    public void setSupportsAlterTableWithDropColumn(boolean supportsAlterTableWithDropColumn) {
        this.supportsAlterTableWithDropColumn = supportsAlterTableWithDropColumn;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return this.supportsBatchUpdates;
    }

    public void setSupportsBatchUpdates(boolean supportsBatchUpdates) {
        this.supportsBatchUpdates = supportsBatchUpdates;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return this.supportsCatalogsInDataManipulation;
    }

    public void setSupportsCatalogsInDataManipulation(boolean supportsCatalogsInDataManipulation) {
        this.supportsCatalogsInDataManipulation = supportsCatalogsInDataManipulation;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return this.supportsCatalogsInIndexDefinitions;
    }

    public void setSupportsCatalogsInIndexDefinitions(boolean supportsCatalogsInIndexDefinitions) {
        this.supportsCatalogsInIndexDefinitions = supportsCatalogsInIndexDefinitions;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return this.supportsCatalogsInPrivilegeDefinitions;
    }

    public void setSupportsCatalogsInPrivilegeDefinitions(boolean supportsCatalogsInPrivilegeDefinitions) {
        this.supportsCatalogsInPrivilegeDefinitions = supportsCatalogsInPrivilegeDefinitions;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return this.supportsCatalogsInProcedureCalls;
    }

    public void setSupportsCatalogsInProcedureCalls(boolean supportsCatalogsInProcedureCalls) {
        this.supportsCatalogsInProcedureCalls = supportsCatalogsInProcedureCalls;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return this.supportsCatalogsInTableDefinitions;
    }

    public void setSupportsCatalogsInTableDefinitions(boolean supportsCatalogsInTableDefinitions) {
        this.supportsCatalogsInTableDefinitions = supportsCatalogsInTableDefinitions;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return this.supportsColumnAliasing;
    }

    public void setSupportsColumnAliasing(boolean supportsColumnAliasing) {
        this.supportsColumnAliasing = supportsColumnAliasing;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return this.supportsConvert;
    }

    public void setSupportsConvert(boolean supportsConvert) {
        this.supportsConvert = supportsConvert;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return this.supportsCoreSQLGrammar;
    }

    public void setSupportsCoreSQLGrammar(boolean supportsCoreSQLGrammar) {
        this.supportsCoreSQLGrammar = supportsCoreSQLGrammar;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return this.supportsCorrelatedSubqueries;
    }

    public void setSupportsCorrelatedSubqueries(boolean supportsCorrelatedSubqueries) {
        this.supportsCorrelatedSubqueries = supportsCorrelatedSubqueries;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return this.supportsDataDefinitionAndDataManipulationTransactions;
    }

    public void setSupportsDataDefinitionAndDataManipulationTransactions(boolean supportsDataDefinitionAndDataManipulationTransactions) {
        this.supportsDataDefinitionAndDataManipulationTransactions = supportsDataDefinitionAndDataManipulationTransactions;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.supportsDataManipulationTransactionsOnly;
    }

    public void setSupportsDataManipulationTransactionsOnly(boolean supportsDataManipulationTransactionsOnly) {
        this.supportsDataManipulationTransactionsOnly = supportsDataManipulationTransactionsOnly;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return this.supportsDifferentTableCorrelationNames;
    }

    public void setSupportsDifferentTableCorrelationNames(boolean supportsDifferentTableCorrelationNames) {
        this.supportsDifferentTableCorrelationNames = supportsDifferentTableCorrelationNames;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return this.supportsExpressionsInOrderBy;
    }

    public void setSupportsExpressionsInOrderBy(boolean supportsExpressionsInOrderBy) {
        this.supportsExpressionsInOrderBy = supportsExpressionsInOrderBy;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return this.supportsExtendedSQLGrammar;
    }

    public void setSupportsExtendedSQLGrammar(boolean supportsExtendedSQLGrammar) {
        this.supportsExtendedSQLGrammar = supportsExtendedSQLGrammar;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return this.supportsFullOuterJoins;
    }

    public void setSupportsFullOuterJoins(boolean supportsFullOuterJoins) {
        this.supportsFullOuterJoins = supportsFullOuterJoins;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return this.supportsGetGeneratedKeys;
    }

    public void setSupportsGetGeneratedKeys(boolean supportsGetGeneratedKeys) {
        this.supportsGetGeneratedKeys = supportsGetGeneratedKeys;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return this.supportsGroupBy;
    }

    public void setSupportsGroupBy(boolean supportsGroupBy) {
        this.supportsGroupBy = supportsGroupBy;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return this.supportsGroupByBeyondSelect;
    }

    public void setSupportsGroupByBeyondSelect(boolean supportsGroupByBeyondSelect) {
        this.supportsGroupByBeyondSelect = supportsGroupByBeyondSelect;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return this.supportsGroupByUnrelated;
    }

    public void setSupportsGroupByUnrelated(boolean supportsGroupByUnrelated) {
        this.supportsGroupByUnrelated = supportsGroupByUnrelated;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return this.supportsIntegrityEnhancementFacility;
    }

    public void setSupportsIntegrityEnhancementFacility(boolean supportsIntegrityEnhancementFacility) {
        this.supportsIntegrityEnhancementFacility = supportsIntegrityEnhancementFacility;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return this.supportsLikeEscapeClause;
    }

    public void setSupportsLikeEscapeClause(boolean supportsLikeEscapeClause) {
        this.supportsLikeEscapeClause = supportsLikeEscapeClause;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return this.supportsLimitedOuterJoins;
    }

    public void setSupportsLimitedOuterJoins(boolean supportsLimitedOuterJoins) {
        this.supportsLimitedOuterJoins = supportsLimitedOuterJoins;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return this.supportsMinimumSQLGrammar;
    }

    public void setSupportsMinimumSQLGrammar(boolean supportsMinimumSQLGrammar) {
        this.supportsMinimumSQLGrammar = supportsMinimumSQLGrammar;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return this.supportsMixedCaseIdentifiers;
    }

    public void setSupportsMixedCaseIdentifiers(boolean supportsMixedCaseIdentifiers) {
        this.supportsMixedCaseIdentifiers = supportsMixedCaseIdentifiers;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.supportsMixedCaseQuotedIdentifiers;
    }

    public void setSupportsMixedCaseQuotedIdentifiers(boolean supportsMixedCaseQuotedIdentifiers) {
        this.supportsMixedCaseQuotedIdentifiers = supportsMixedCaseQuotedIdentifiers;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return this.supportsMultipleOpenResults;
    }

    public void setSupportsMultipleOpenResults(boolean supportsMultipleOpenResults) {
        this.supportsMultipleOpenResults = supportsMultipleOpenResults;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return this.supportsMultipleResultSets;
    }

    public void setSupportsMultipleResultSets(boolean supportsMultipleResultSets) {
        this.supportsMultipleResultSets = supportsMultipleResultSets;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return this.supportsMultipleTransactions;
    }

    public void setSupportsMultipleTransactions(boolean supportsMultipleTransactions) {
        this.supportsMultipleTransactions = supportsMultipleTransactions;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return this.supportsNamedParameters;
    }

    public void setSupportsNamedParameters(boolean supportsNamedParameters) {
        this.supportsNamedParameters = supportsNamedParameters;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return this.supportsNonNullableColumns;
    }

    public void setSupportsNonNullableColumns(boolean supportsNonNullableColumns) {
        this.supportsNonNullableColumns = supportsNonNullableColumns;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return this.supportsOpenCursorsAcrossCommit;
    }

    public void setSupportsOpenCursorsAcrossCommit(boolean supportsOpenCursorsAcrossCommit) {
        this.supportsOpenCursorsAcrossCommit = supportsOpenCursorsAcrossCommit;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return this.supportsOpenCursorsAcrossRollback;
    }

    public void setSupportsOpenCursorsAcrossRollback(boolean supportsOpenCursorsAcrossRollback) {
        this.supportsOpenCursorsAcrossRollback = supportsOpenCursorsAcrossRollback;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return this.supportsOpenStatementsAcrossCommit;
    }

    public void setSupportsOpenStatementsAcrossCommit(boolean supportsOpenStatementsAcrossCommit) {
        this.supportsOpenStatementsAcrossCommit = supportsOpenStatementsAcrossCommit;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return this.supportsOpenStatementsAcrossRollback;
    }

    public void setSupportsOpenStatementsAcrossRollback(boolean supportsOpenStatementsAcrossRollback) {
        this.supportsOpenStatementsAcrossRollback = supportsOpenStatementsAcrossRollback;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return this.supportsOrderByUnrelated;
    }

    public void setSupportsOrderByUnrelated(boolean supportsOrderByUnrelated) {
        this.supportsOrderByUnrelated = supportsOrderByUnrelated;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return this.supportsOuterJoins;
    }

    public void setSupportsOuterJoins(boolean supportsOuterJoins) {
        this.supportsOuterJoins = supportsOuterJoins;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return this.supportsPositionedDelete;
    }

    public void setSupportsPositionedDelete(boolean supportsPositionedDelete) {
        this.supportsPositionedDelete = supportsPositionedDelete;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return this.supportsPositionedUpdate;
    }

    public void setSupportsPositionedUpdate(boolean supportsPositionedUpdate) {
        this.supportsPositionedUpdate = supportsPositionedUpdate;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return this.supportsSavepoints;
    }

    public void setSupportsSavepoints(boolean supportsSavepoints) {
        this.supportsSavepoints = supportsSavepoints;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return this.supportsSchemasInDataManipulation;
    }

    public void setSupportsSchemasInDataManipulation(boolean supportsSchemasInDataManipulation) {
        this.supportsSchemasInDataManipulation = supportsSchemasInDataManipulation;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return this.supportsSchemasInIndexDefinitions;
    }

    public void setSupportsSchemasInIndexDefinitions(boolean supportsSchemasInIndexDefinitions) {
        this.supportsSchemasInIndexDefinitions = supportsSchemasInIndexDefinitions;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return this.supportsSchemasInPrivilegeDefinitions;
    }

    public void setSupportsSchemasInPrivilegeDefinitions(boolean supportsSchemasInPrivilegeDefinitions) {
        this.supportsSchemasInPrivilegeDefinitions = supportsSchemasInPrivilegeDefinitions;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return this.supportsSchemasInProcedureCalls;
    }

    public void setSupportsSchemasInProcedureCalls(boolean supportsSchemasInProcedureCalls) {
        this.supportsSchemasInProcedureCalls = supportsSchemasInProcedureCalls;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return this.supportsSchemasInTableDefinitions;
    }

    public void setSupportsSchemasInTableDefinitions(boolean supportsSchemasInTableDefinitions) {
        this.supportsSchemasInTableDefinitions = supportsSchemasInTableDefinitions;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return this.supportsSelectForUpdate;
    }

    public void setSupportsSelectForUpdate(boolean supportsSelectForUpdate) {
        this.supportsSelectForUpdate = supportsSelectForUpdate;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return this.supportsStatementPooling;
    }

    public void setSupportsStatementPooling(boolean supportsStatementPooling) {
        this.supportsStatementPooling = supportsStatementPooling;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return this.supportsStoredProcedures;
    }

    public void setSupportsStoredProcedures(boolean supportsStoredProcedures) {
        this.supportsStoredProcedures = supportsStoredProcedures;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return this.supportsSubqueriesInComparisons;
    }

    public void setSupportsSubqueriesInComparisons(boolean supportsSubqueriesInComparisons) {
        this.supportsSubqueriesInComparisons = supportsSubqueriesInComparisons;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return this.supportsSubqueriesInExists;
    }

    public void setSupportsSubqueriesInExists(boolean supportsSubqueriesInExists) {
        this.supportsSubqueriesInExists = supportsSubqueriesInExists;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return this.supportsSubqueriesInIns;
    }

    public void setSupportsSubqueriesInIns(boolean supportsSubqueriesInIns) {
        this.supportsSubqueriesInIns = supportsSubqueriesInIns;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return this.supportsSubqueriesInQuantifieds;
    }

    public void setSupportsSubqueriesInQuantifieds(boolean supportsSubqueriesInQuantifieds) {
        this.supportsSubqueriesInQuantifieds = supportsSubqueriesInQuantifieds;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return this.supportsTableCorrelationNames;
    }

    public void setSupportsTableCorrelationNames(boolean supportsTableCorrelationNames) {
        this.supportsTableCorrelationNames = supportsTableCorrelationNames;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return this.supportsTransactions;
    }

    public void setSupportsTransactions(boolean supportsTransactions) {
        this.supportsTransactions = supportsTransactions;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return this.supportsUnion;
    }

    public void setSupportsUnion(boolean supportsUnion) {
        this.supportsUnion = supportsUnion;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return this.supportsUnionAll;
    }

    public void setSupportsUnionAll(boolean supportsUnionAll) {
        this.supportsUnionAll = supportsUnionAll;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return this.usesLocalFilePerTable;
    }

    public void setUsesLocalFilePerTable(boolean usesLocalFilePerTable) {
        this.usesLocalFilePerTable = usesLocalFilePerTable;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return this.usesLocalFiles;
    }

    public void setUsesLocalFiles(boolean usesLocalFiles) {
        this.usesLocalFiles = usesLocalFiles;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return this.generatedKeysAlwaysReturned;
    }

    public void setGeneratedKeysAlwaysReturned(boolean generatedKeysAlwaysReturned) {
        this.generatedKeysAlwaysReturned = generatedKeysAlwaysReturned;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return this.deletesAreDetected;
    }

    public void setDeletesAreDetected(boolean deletesAreDetected) {
        this.deletesAreDetected = deletesAreDetected;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return this.insertsAreDetected;
    }

    public void setInsertsAreDetected(boolean insertsAreDetected) {
        this.insertsAreDetected = insertsAreDetected;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return this.othersDeletesAreVisible;
    }

    public void setOthersDeletesAreVisible(boolean othersDeletesAreVisible) {
        this.othersDeletesAreVisible = othersDeletesAreVisible;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return this.othersInsertsAreVisible;
    }

    public void setOthersInsertsAreVisible(boolean othersInsertsAreVisible) {
        this.othersInsertsAreVisible = othersInsertsAreVisible;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return this.othersUpdatesAreVisible;
    }

    public void setOthersUpdatesAreVisible(boolean othersUpdatesAreVisible) {
        this.othersUpdatesAreVisible = othersUpdatesAreVisible;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return this.ownDeletesAreVisible;
    }

    public void setOwnDeletesAreVisible(boolean ownDeletesAreVisible) {
        this.ownDeletesAreVisible = ownDeletesAreVisible;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return this.ownInsertsAreVisible;
    }

    public void setOwnInsertsAreVisible(boolean ownInsertsAreVisible) {
        this.ownInsertsAreVisible = ownInsertsAreVisible;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return this.ownUpdatesAreVisible;
    }

    public void setOwnUpdatesAreVisible(boolean ownUpdatesAreVisible) {
        this.ownUpdatesAreVisible = ownUpdatesAreVisible;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return this.supportsResultSetHoldability;
    }

    public void setSupportsResultSetHoldability(boolean supportsResultSetHoldability) {
        this.supportsResultSetHoldability = supportsResultSetHoldability;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return this.supportsResultSetType;
    }

    public void setSupportsResultSetType(boolean supportsResultSetType) {
        this.supportsResultSetType = supportsResultSetType;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return this.supportsTransactionIsolationLevel;
    }

    public void setSupportsTransactionIsolationLevel(boolean supportsTransactionIsolationLevel) {
        this.supportsTransactionIsolationLevel = supportsTransactionIsolationLevel;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return this.updatesAreDetected;
    }

    public void setUpdatesAreDetected(boolean updatesAreDetected) {
        this.updatesAreDetected = updatesAreDetected;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return this.supportsConvert;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return this.supportsResultSetConcurrency;
    }

    public void setSupportsResultSetConcurrency(boolean supportsResultSetConcurrency) {
        this.supportsResultSetConcurrency = supportsResultSetConcurrency;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return this.supportsStoredFunctionsUsingCallSyntax;
    }

    public void setSupportsStoredFunctionsUsingCallSyntax(boolean supportsStoredFunctions) {
        this.supportsStoredFunctionsUsingCallSyntax = supportsStoredFunctions;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return this.catalogSeparator;
    }

    public void setCatalogSeparator(String catalogSeparator) {
        this.catalogSeparator = catalogSeparator;
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return this.catalogTerm;
    }

    public void setCatalogTerm(String catalogTerm) {
        this.catalogTerm = catalogTerm;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return this.databaseProductName;
    }

    public void setDatabaseProductName(String databaseProductName) {
        this.databaseProductName = databaseProductName;
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.databaseProductVersion;
    }

    public void setDatabaseProductVersion(String databaseProductVersion) {
        this.databaseProductVersion = databaseProductVersion;
    }

    @Override
    public String getDriverName() throws SQLException {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return this.driverVersion;
    }

    public void setDriverVersion(String driverVersion) {
        this.driverVersion = driverVersion;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return this.extraNameCharacters;
    }

    public void setExtraNameCharacters(String extraNameCharacters) {
        this.extraNameCharacters = extraNameCharacters;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return this.identifierQuoteString;
    }

    public void setIdentifierQuoteString(String identifierQuoteString) {
        this.identifierQuoteString = identifierQuoteString;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return this.numericFunctions;
    }

    public void setNumericFunctions(String numericFunctions) {
        this.numericFunctions = numericFunctions;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return this.procedureTerm;
    }

    public void setProcedureTerm(String procedureTerm) {
        this.procedureTerm = procedureTerm;
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return this.sqlKeywords;
    }

    public void setSQLKeywords(String sqlKeywords) {
        this.sqlKeywords = sqlKeywords;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return this.schemaTerm;
    }

    public void setSchemaTerm(String schemaTerm) {
        this.schemaTerm = schemaTerm;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return this.searchStringEscape;
    }

    public void setSearchStringEscape(String searchStringEscape) {
        this.searchStringEscape = searchStringEscape;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return this.stringFunctions;
    }

    public void setStringFunctions(String stringFunctions) {
        this.stringFunctions = stringFunctions;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return this.systemFunctions;
    }

    public void setSystemFunctions(String systemFunctions) {
        this.systemFunctions = systemFunctions;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return this.timeDateFunctions;
    }

    public void setTimeDateFunctions(String timeDateFunctions) {
        this.timeDateFunctions = timeDateFunctions;
    }

    @Override
    public String getURL() throws SQLException {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    @Override
    public String getUserName() throws SQLException {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return this.catalogs;
    }

    public void setCatalogs(ResultSet catalogs) {
        this.catalogs = catalogs;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getAll(this.schemasMap);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        DatabaseIdentifierImpl expected = new DatabaseIdentifierImpl(catalog, schemaPattern, "", true, false);
        return this.findMatchingDatabaseIdentifier(expected, this.schemasMap);
    }

    public void setSchemas(ResultSet schemas) {
        this.schemasMap.put(new DatabaseIdentifierImpl(), schemas);
    }

    public void setSchemas(String catalog, String schemaPattern, ResultSet schemas) {
        this.schemasMap.put(new DatabaseIdentifierImpl(catalog, schemaPattern, ""), schemas);
    }

    public void clearSchemas() {
        this.schemasMap.clear();
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return this.tableTypes;
    }

    public void setTableTypes(ResultSet tableTypes) {
        this.tableTypes = tableTypes;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return this.typeInfo;
    }

    public void setTypeInfo(ResultSet typeInfo) {
        this.typeInfo = typeInfo;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return this.clientInfoProperties;
    }

    public void setClientInfoProperties(ResultSet clientInfoProperties) {
        this.clientInfoProperties = clientInfoProperties;
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        DatabaseIdentifierImpl expected = new DatabaseIdentifierImpl(catalog, schema, table);
        return this.findMatchingDatabaseIdentifier(expected, this.exportedKeysMap);
    }

    public void setExportedKeys(ResultSet exportedKeys) {
        this.exportedKeysMap.put(new DatabaseIdentifierImpl(), exportedKeys);
    }

    public void setExportedKeys(String catalog, String schema, String table, ResultSet exportedKeys) {
        this.exportedKeysMap.put(new DatabaseIdentifierImpl(catalog, schema, table), exportedKeys);
    }

    public void clearExportedKeys() {
        this.exportedKeysMap.clear();
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        DatabaseIdentifierImpl expected = new DatabaseIdentifierImpl(catalog, schema, table);
        return this.findMatchingDatabaseIdentifier(expected, this.importedKeysMap);
    }

    public void setImportedKeys(ResultSet importedKeys) {
        this.importedKeysMap.put(new DatabaseIdentifierImpl(), importedKeys);
    }

    public void setImportedKeys(String catalog, String schema, String table, ResultSet importedKeys) {
        this.importedKeysMap.put(new DatabaseIdentifierImpl(catalog, schema, table), importedKeys);
    }

    public void clearImportedKeys() {
        this.importedKeysMap.clear();
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        DatabaseIdentifierImpl expected = new DatabaseIdentifierImpl(catalog, schema, table);
        return this.findMatchingDatabaseIdentifier(expected, this.primaryKeysMap);
    }

    public void setPrimaryKeys(ResultSet primaryKeys) {
        this.primaryKeysMap.put(new DatabaseIdentifierImpl(), primaryKeys);
    }

    public void setPrimaryKeys(String catalog, String schema, String table, ResultSet primaryKeys) {
        this.primaryKeysMap.put(new DatabaseIdentifierImpl(catalog, schema, table), primaryKeys);
    }

    public void clearPrimaryKeys() {
        this.primaryKeysMap.clear();
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        DatabaseIdentifierImpl expected = new DatabaseIdentifierImpl(catalog, schemaPattern, procedureNamePattern, true, true);
        return this.findMatchingDatabaseIdentifier(expected, this.proceduresMap);
    }

    public void setProcedures(ResultSet procedures) {
        this.proceduresMap.put(new DatabaseIdentifierImpl(), procedures);
    }

    public void setProcedures(String catalog, String schemaPattern, String procedureNamePattern, ResultSet procedures) {
        this.proceduresMap.put(new DatabaseIdentifierImpl(catalog, schemaPattern, procedureNamePattern), procedures);
    }

    public void clearProcedures() {
        this.proceduresMap.clear();
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        DatabaseIdentifierImpl expected = new DatabaseIdentifierImpl(catalog, schemaPattern, functionNamePattern, true, true);
        return this.findMatchingDatabaseIdentifier(expected, this.functionsMap);
    }

    public void setFunctions(ResultSet functions) {
        this.functionsMap.put(new DatabaseIdentifierImpl(), functions);
    }

    public void setFunctions(String catalog, String schemaPattern, String functionNamePattern, ResultSet functions) {
        this.functionsMap.put(new DatabaseIdentifierImpl(catalog, schemaPattern, functionNamePattern), functions);
    }

    public void clearFunctions() {
        this.functionsMap.clear();
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        DatabaseIdentifierImpl expected = new DatabaseIdentifierImpl(catalog, schemaPattern, tableNamePattern, true, true);
        return this.findMatchingDatabaseIdentifier(expected, this.superTablesMap);
    }

    public void setSuperTables(ResultSet superTables) {
        this.superTablesMap.put(new DatabaseIdentifierImpl(), superTables);
    }

    public void setSuperTables(String catalog, String schemaPattern, String tableName, ResultSet superTables) {
        this.superTablesMap.put(new DatabaseIdentifierImpl(catalog, schemaPattern, tableName), superTables);
    }

    public void clearSuperTables() {
        this.superTablesMap.clear();
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        DatabaseIdentifierImpl expected = new DatabaseIdentifierImpl(catalog, schemaPattern, typeNamePattern, true, true);
        return this.findMatchingDatabaseIdentifier(expected, this.superTypesMap);
    }

    public void setSuperTypes(ResultSet superTypes) {
        this.superTypesMap.put(new DatabaseIdentifierImpl(), superTypes);
    }

    public void setSuperTypes(String catalog, String schemaPattern, String typeNamePattern, ResultSet superTypes) {
        this.superTypesMap.put(new DatabaseIdentifierImpl(catalog, schemaPattern, typeNamePattern), superTypes);
    }

    public void clearSuperTypes() {
        this.superTypesMap.clear();
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        DatabaseIdentifierImpl expected = new DatabaseIdentifierImpl(catalog, schemaPattern, tableNamePattern, true, true);
        return this.findMatchingDatabaseIdentifier(expected, this.tablePrivilegesMap);
    }

    public void setTablePrivileges(ResultSet tablePrivileges) {
        this.tablePrivilegesMap.put(new DatabaseIdentifierImpl(), tablePrivileges);
    }

    public void setTablePrivileges(String catalog, String schemaPattern, String tableNamePattern, ResultSet tablePrivileges) {
        this.tablePrivilegesMap.put(new DatabaseIdentifierImpl(catalog, schemaPattern, tableNamePattern), tablePrivileges);
    }

    public void clearTablePrivileges() {
        this.tablePrivilegesMap.clear();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        DatabaseIdentifierImpl expected = new DatabaseIdentifierImpl(catalog, schema, table);
        return this.findMatchingDatabaseIdentifier(expected, this.versionColumnsMap);
    }

    public void setVersionColumns(ResultSet versionColumns) {
        this.versionColumnsMap.put(new DatabaseIdentifierImpl(), versionColumns);
    }

    public void setVersionColumns(String catalog, String schema, String table, ResultSet versionColumns) {
        this.versionColumnsMap.put(new DatabaseIdentifierImpl(catalog, schema, table), versionColumns);
    }

    public void clearVersionColumns() {
        this.versionColumnsMap.clear();
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        RowIdentifierDatabaseIdentifierImpl expected = new RowIdentifierDatabaseIdentifierImpl(catalog, schema, table, scope, nullable);
        return this.findMatchingDatabaseIdentifier(expected, this.bestRowIdentifierMap);
    }

    public void setBestRowIdentifier(ResultSet bestRowIdentifier) {
        this.bestRowIdentifierMap.put(new RowIdentifierDatabaseIdentifierImpl(), bestRowIdentifier);
    }

    public void setBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable, ResultSet bestRowIdentifier) {
        this.bestRowIdentifierMap.put(new RowIdentifierDatabaseIdentifierImpl(catalog, schema, table, scope, nullable), bestRowIdentifier);
    }

    public void clearBestRowIdentifier() {
        this.bestRowIdentifierMap.clear();
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        IndexInfoDatabaseIdentifierImpl expected = new IndexInfoDatabaseIdentifierImpl(catalog, schema, table, unique, approximate);
        return this.findMatchingDatabaseIdentifier(expected, this.indexInfoMap);
    }

    public void setIndexInfo(ResultSet indexInfo) {
        this.indexInfoMap.put(new IndexInfoDatabaseIdentifierImpl(), indexInfo);
    }

    public void setIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate, ResultSet indexInfo) {
        this.indexInfoMap.put(new IndexInfoDatabaseIdentifierImpl(catalog, schema, table, unique, approximate), indexInfo);
    }

    public void clearIndexInfo() {
        this.indexInfoMap.clear();
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        UDTDatabaseIdentifierImpl expected = new UDTDatabaseIdentifierImpl(catalog, schemaPattern, typeNamePattern, true, true, types);
        return this.findMatchingDatabaseIdentifier(expected, this.udtsMap);
    }

    public void setUDTs(ResultSet udts) {
        this.udtsMap.put(new UDTDatabaseIdentifierImpl(), udts);
    }

    public void setUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types, ResultSet udts) {
        this.udtsMap.put(new UDTDatabaseIdentifierImpl(catalog, schemaPattern, typeNamePattern, types), udts);
    }

    public void clearUDTs() {
        this.udtsMap.clear();
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        AttributesDatabaseIdentifierImpl expected = new AttributesDatabaseIdentifierImpl(catalog, schemaPattern, typeNamePattern, true, true, attributeNamePattern);
        return this.findMatchingDatabaseIdentifier(expected, this.attributesMap);
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ColumnDatabaseIdentifierImpl expected = new ColumnDatabaseIdentifierImpl(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        return this.findMatchingDatabaseIdentifier(expected, this.pseudoColumnsMap);
    }

    public void setPseudoColumns(ResultSet pseudoColumns) {
        this.pseudoColumnsMap.put(new ColumnDatabaseIdentifierImpl(), pseudoColumns);
    }

    public void setPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern, ResultSet pseudoColumns) {
        this.pseudoColumnsMap.put(new ColumnDatabaseIdentifierImpl(catalog, schemaPattern, tableNamePattern, columnNamePattern), pseudoColumns);
    }

    public void setAttributes(ResultSet attributes) {
        this.attributesMap.put(new AttributesDatabaseIdentifierImpl(), attributes);
    }

    public void setAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern, ResultSet attributes) {
        this.attributesMap.put(new AttributesDatabaseIdentifierImpl(catalog, schemaPattern, typeNamePattern, attributeNamePattern), attributes);
    }

    public void clearAttributes() {
        this.attributesMap.clear();
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        ColumnDatabaseIdentifierImpl expected = new ColumnDatabaseIdentifierImpl(catalog, schema, table, columnNamePattern);
        return this.findMatchingDatabaseIdentifier(expected, this.columnPrivilegesMap);
    }

    public void setColumnPrivileges(ResultSet columnPrivileges) {
        this.columnPrivilegesMap.put(new ColumnDatabaseIdentifierImpl(), columnPrivileges);
    }

    public void setColumnPrivileges(String catalog, String schema, String table, String columnNamePattern, ResultSet columnPrivileges) {
        this.columnPrivilegesMap.put(new ColumnDatabaseIdentifierImpl(catalog, schema, table, columnNamePattern), columnPrivileges);
    }

    public void clearColumnPrivileges() {
        this.columnPrivilegesMap.clear();
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ColumnDatabaseIdentifierImpl expected = new ColumnDatabaseIdentifierImpl(catalog, schemaPattern, tableNamePattern, true, true, columnNamePattern);
        return this.findMatchingDatabaseIdentifier(expected, this.columnsMap);
    }

    public void setColumns(ResultSet columns) {
        this.columnsMap.put(new ColumnDatabaseIdentifierImpl(), columns);
    }

    public void setColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern, ResultSet columns) {
        this.columnsMap.put(new ColumnDatabaseIdentifierImpl(catalog, schemaPattern, tableNamePattern, columnNamePattern), columns);
    }

    public void clearColumns() {
        this.columnsMap.clear();
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        ColumnDatabaseIdentifierImpl expected = new ColumnDatabaseIdentifierImpl(catalog, schemaPattern, procedureNamePattern, true, true, columnNamePattern);
        return this.findMatchingDatabaseIdentifier(expected, this.procedureColumnsMap);
    }

    public void setProcedureColumns(ResultSet procedureColumns) {
        this.procedureColumnsMap.put(new ColumnDatabaseIdentifierImpl(), procedureColumns);
    }

    public void setProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern, ResultSet procedureColumns) {
        this.procedureColumnsMap.put(new ColumnDatabaseIdentifierImpl(catalog, schemaPattern, procedureNamePattern, columnNamePattern), procedureColumns);
    }

    public void clearProcedureColumns() {
        this.procedureColumnsMap.clear();
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        ColumnDatabaseIdentifierImpl expected = new ColumnDatabaseIdentifierImpl(catalog, schemaPattern, functionNamePattern, true, true, columnNamePattern);
        return this.findMatchingDatabaseIdentifier(expected, this.functionColumnsMap);
    }

    public void setFunctionColumns(ResultSet functionColumns) {
        this.functionColumnsMap.put(new ColumnDatabaseIdentifierImpl(), functionColumns);
    }

    public void setFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern, ResultSet functionColumns) {
        this.functionColumnsMap.put(new ColumnDatabaseIdentifierImpl(catalog, schemaPattern, functionNamePattern, columnNamePattern), functionColumns);
    }

    public void clearFunctionColumns() {
        this.functionColumnsMap.clear();
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        TableDatabaseIdentifierImpl expected = new TableDatabaseIdentifierImpl(catalog, schemaPattern, true, true, tableNamePattern, types);
        return this.findMatchingDatabaseIdentifier(expected, this.tablesMap);
    }

    public void setTables(ResultSet tables) {
        this.tablesMap.put(new TableDatabaseIdentifierImpl(), tables);
    }

    public void setTables(String catalog, String schemaPattern, String tableNamePattern, String[] types, ResultSet tables) {
        this.tablesMap.put(new TableDatabaseIdentifierImpl(catalog, schemaPattern, tableNamePattern, types), tables);
    }

    public void clearTables() {
        this.tablesMap.clear();
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        DatabaseIdentifierImpl identifier1 = new DatabaseIdentifierImpl(primaryCatalog, primarySchema, primaryTable);
        DatabaseIdentifierImpl identifier2 = new DatabaseIdentifierImpl(foreignCatalog, foreignSchema, foreignTable);
        DatabaseIdentifierImplWrapper expected = new DatabaseIdentifierImplWrapper(identifier1, identifier2);
        return this.findMatchingDatabaseIdentifier(expected, this.crossReferenceMap);
    }

    public void setCrossReference(ResultSet crossReference) {
        DatabaseIdentifierImpl identifier1 = new DatabaseIdentifierImpl();
        DatabaseIdentifierImpl identifier2 = new DatabaseIdentifierImpl();
        this.crossReferenceMap.put(new DatabaseIdentifierImplWrapper(identifier1, identifier2), crossReference);
    }

    public void setCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable, ResultSet crossReference) {
        DatabaseIdentifierImpl identifier1 = new DatabaseIdentifierImpl(primaryCatalog, primarySchema, primaryTable);
        DatabaseIdentifierImpl identifier2 = new DatabaseIdentifierImpl(foreignCatalog, foreignSchema, foreignTable);
        this.crossReferenceMap.put(new DatabaseIdentifierImplWrapper(identifier1, identifier2), crossReference);
    }

    public void clearCrossReference() {
        this.crossReferenceMap.clear();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("No object found for " + iface);
    }

    private ResultSet findMatchingDatabaseIdentifier(DatabaseIdentifier expected, Map<DatabaseIdentifier, ResultSet> theMap) {
        ArrayList<ResultSet> list = new ArrayList<ResultSet>();
        for (Map.Entry<DatabaseIdentifier, ResultSet> entry : theMap.entrySet()) {
            DatabaseIdentifier next = entry.getKey();
            if (!next.isGlobal() && !expected.matches(next)) continue;
            list.add(entry.getValue());
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return (ResultSet)list.get(0);
        }
        return new PolyResultSet(list);
    }

    private ResultSet getAll(Map<DatabaseIdentifier, ResultSet> theMap) {
        ArrayList<ResultSet> list = new ArrayList<ResultSet>();
        list.addAll(theMap.values());
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return (ResultSet)list.get(0);
        }
        return new PolyResultSet(list);
    }

    private class DatabaseIdentifierImplWrapper
    implements DatabaseIdentifier {
        private final DatabaseIdentifier identifier1;
        private final DatabaseIdentifier identifier2;

        public DatabaseIdentifierImplWrapper(DatabaseIdentifier identifier1, DatabaseIdentifier identifier2) {
            this.identifier1 = identifier1;
            this.identifier2 = identifier2;
        }

        public DatabaseIdentifier getIdentifier1() {
            return this.identifier1;
        }

        public DatabaseIdentifier getIdentifier2() {
            return this.identifier2;
        }

        @Override
        public boolean isGlobal() {
            if (null == this.identifier1) {
                return false;
            }
            if (null == this.identifier2) {
                return false;
            }
            return this.identifier1.isGlobal() && this.identifier1.isGlobal();
        }

        @Override
        public boolean matches(DatabaseIdentifier object) {
            if (null == object) {
                return false;
            }
            if (!object.getClass().equals(this.getClass())) {
                return false;
            }
            DatabaseIdentifierImplWrapper other = (DatabaseIdentifierImplWrapper)object;
            if (null != this.identifier1 && !this.identifier1.matches(other.getIdentifier1())) {
                return false;
            }
            return null == this.identifier2 || this.identifier2.matches(other.getIdentifier2());
        }

        public boolean equals(Object object) {
            if (null == object) {
                return false;
            }
            if (!object.getClass().equals(this.getClass())) {
                return false;
            }
            DatabaseIdentifierImplWrapper other = (DatabaseIdentifierImplWrapper)object;
            if (null != this.identifier1 && !this.identifier1.equals(other.getIdentifier1())) {
                return false;
            }
            if (null != other.getIdentifier1() && !other.getIdentifier1().equals(this.identifier1)) {
                return false;
            }
            if (null != this.identifier2 && !this.identifier2.equals(other.getIdentifier2())) {
                return false;
            }
            return null == other.getIdentifier2() || other.getIdentifier2().equals(this.identifier2);
        }

        public int hashCode() {
            int hashCode = 0;
            if (null != this.identifier1) {
                hashCode = 31 * hashCode + this.identifier1.hashCode();
            }
            if (null != this.identifier2) {
                hashCode = 31 * hashCode + this.identifier2.hashCode();
            }
            return hashCode;
        }
    }

    private class UDTDatabaseIdentifierImpl
    extends DatabaseIdentifierImpl {
        private int[] types;

        public UDTDatabaseIdentifierImpl() {
        }

        public UDTDatabaseIdentifierImpl(String catalog, String schema, String table, int[] types) {
            super(catalog, schema, table);
            this.types = types;
        }

        public UDTDatabaseIdentifierImpl(String catalog, String schema, String table, boolean useSchemaPattern, boolean useTablePattern, int[] types) {
            super(catalog, schema, table, useSchemaPattern, useTablePattern);
            this.types = types;
        }

        public int[] getTypes() {
            return this.types;
        }

        @Override
        public boolean matches(DatabaseIdentifier object) {
            if (!super.matches(object)) {
                return false;
            }
            UDTDatabaseIdentifierImpl other = (UDTDatabaseIdentifierImpl)object;
            if (null == this.types) {
                return true;
            }
            if (null == other.getTypes()) {
                return false;
            }
            return this.matchesTypes(other);
        }

        private boolean matchesTypes(UDTDatabaseIdentifierImpl other) {
            int[] otherTypes = other.getTypes();
            for (int type : this.types) {
                for (int otherType : otherTypes) {
                    if (type != otherType) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            UDTDatabaseIdentifierImpl other = (UDTDatabaseIdentifierImpl)object;
            if (null == this.types && null == other.getTypes()) {
                return true;
            }
            if (null == this.types) {
                return false;
            }
            if (null == other.getTypes()) {
                return false;
            }
            return Arrays.equals(this.types, other.getTypes());
        }

        @Override
        public int hashCode() {
            int hashCode = super.hashCode();
            if (null != this.types) {
                for (int type : this.types) {
                    hashCode = 31 * hashCode + type;
                }
            }
            return hashCode;
        }
    }

    private class TableDatabaseIdentifierImpl
    extends DatabaseIdentifierImpl {
        private String[] types;

        public TableDatabaseIdentifierImpl() {
        }

        public TableDatabaseIdentifierImpl(String catalog, String schema, String table, String[] types) {
            super(catalog, schema, table);
            this.types = types;
        }

        public TableDatabaseIdentifierImpl(String catalog, String schema, boolean useSchemaPattern, boolean useTablePattern, String table, String[] types) {
            super(catalog, schema, table, useSchemaPattern, useTablePattern);
            this.types = types;
        }

        public String[] getTypes() {
            return this.types;
        }

        @Override
        public boolean matches(DatabaseIdentifier object) {
            if (!super.matches(object)) {
                return false;
            }
            TableDatabaseIdentifierImpl other = (TableDatabaseIdentifierImpl)object;
            if (null == this.types) {
                return true;
            }
            if (null == other.getTypes()) {
                return false;
            }
            return this.matchesTypes(other);
        }

        private boolean matchesTypes(TableDatabaseIdentifierImpl other) {
            String[] otherTypes = other.getTypes();
            for (String type : this.types) {
                for (String otherType : otherTypes) {
                    if (!type.equals(otherType)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            TableDatabaseIdentifierImpl other = (TableDatabaseIdentifierImpl)object;
            if (null == this.types && null == other.getTypes()) {
                return true;
            }
            if (null == this.types) {
                return false;
            }
            if (null == other.getTypes()) {
                return false;
            }
            return Arrays.equals(this.types, other.getTypes());
        }

        @Override
        public int hashCode() {
            int hashCode = super.hashCode();
            if (null != this.types) {
                for (String type : this.types) {
                    if (null == type) continue;
                    hashCode = 31 * hashCode + type.hashCode();
                }
            }
            return hashCode;
        }
    }

    private class IndexInfoDatabaseIdentifierImpl
    extends DatabaseIdentifierImpl {
        private boolean unique;
        private boolean approximate;

        public IndexInfoDatabaseIdentifierImpl() {
        }

        public IndexInfoDatabaseIdentifierImpl(String catalog, String schema, String table, boolean unique, boolean approximate) {
            super(catalog, schema, table);
            this.unique = unique;
            this.approximate = approximate;
        }

        public boolean isApproximate() {
            return this.approximate;
        }

        public boolean isUnique() {
            return this.unique;
        }

        @Override
        public boolean matches(DatabaseIdentifier object) {
            if (!super.matches(object)) {
                return false;
            }
            return this.isEqual(object);
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            return this.isEqual(object);
        }

        private boolean isEqual(Object object) {
            IndexInfoDatabaseIdentifierImpl other = (IndexInfoDatabaseIdentifierImpl)object;
            if (this.unique != other.isUnique()) {
                return false;
            }
            return this.approximate == other.isApproximate();
        }

        @Override
        public int hashCode() {
            int hashCode = super.hashCode();
            hashCode = 31 * hashCode + (this.unique ? 31 : 62);
            hashCode = 31 * hashCode + (this.approximate ? 93 : 124);
            return hashCode;
        }
    }

    private class RowIdentifierDatabaseIdentifierImpl
    extends DatabaseIdentifierImpl {
        private int scope;
        private boolean nullable;

        public RowIdentifierDatabaseIdentifierImpl() {
        }

        public RowIdentifierDatabaseIdentifierImpl(String catalog, String schema, String table, int scope, boolean nullable) {
            super(catalog, schema, table);
            this.scope = scope;
            this.nullable = nullable;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public int getScope() {
            return this.scope;
        }

        @Override
        public boolean matches(DatabaseIdentifier object) {
            if (!super.matches(object)) {
                return false;
            }
            return this.isEqual(object);
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            return this.isEqual(object);
        }

        private boolean isEqual(Object object) {
            RowIdentifierDatabaseIdentifierImpl other = (RowIdentifierDatabaseIdentifierImpl)object;
            if (this.scope != other.getScope()) {
                return false;
            }
            return this.nullable == other.isNullable();
        }

        @Override
        public int hashCode() {
            int hashCode = super.hashCode() * 31 + this.scope;
            hashCode = 31 * hashCode + (this.nullable ? 31 : 62);
            return hashCode;
        }
    }

    private class ColumnDatabaseIdentifierImpl
    extends DatabaseIdentifierImpl {
        private String columnNamePattern;

        public ColumnDatabaseIdentifierImpl() {
        }

        public ColumnDatabaseIdentifierImpl(String catalog, String schema, String table, String columnNamePattern) {
            super(catalog, schema, table);
            this.columnNamePattern = columnNamePattern;
        }

        public ColumnDatabaseIdentifierImpl(String catalog, String schema, String table, boolean useSchemaPattern, boolean useTablePattern, String columnNamePattern) {
            super(catalog, schema, table, useSchemaPattern, useTablePattern);
            this.columnNamePattern = columnNamePattern;
        }

        public String getColumnNamePattern() {
            return this.columnNamePattern;
        }

        @Override
        public boolean matches(DatabaseIdentifier object) {
            if (!super.matches(object)) {
                return false;
            }
            ColumnDatabaseIdentifierImpl other = (ColumnDatabaseIdentifierImpl)object;
            if (null == this.columnNamePattern && null == other.getColumnNamePattern()) {
                return true;
            }
            if (null == this.columnNamePattern) {
                return false;
            }
            if (null == other.getColumnNamePattern()) {
                return false;
            }
            return StringUtil.matchesPerl5((String)other.getColumnNamePattern(), (String)this.convert(this.columnNamePattern), (boolean)MockDatabaseMetaData.this.caseSensitive);
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            ColumnDatabaseIdentifierImpl other = (ColumnDatabaseIdentifierImpl)object;
            if (null != this.columnNamePattern && !this.columnNamePattern.equals(other.getColumnNamePattern())) {
                return false;
            }
            return null == other.getColumnNamePattern() || other.getColumnNamePattern().equals(this.columnNamePattern);
        }

        @Override
        public int hashCode() {
            int hashCode = super.hashCode();
            if (null != this.columnNamePattern) {
                hashCode = 31 * hashCode + this.columnNamePattern.hashCode();
            }
            return hashCode;
        }
    }

    private class AttributesDatabaseIdentifierImpl
    extends DatabaseIdentifierImpl {
        private String attributeNamePattern;

        public AttributesDatabaseIdentifierImpl() {
        }

        public AttributesDatabaseIdentifierImpl(String catalog, String schema, String table, String attributeNamePattern) {
            super(catalog, schema, table);
            this.attributeNamePattern = attributeNamePattern;
        }

        public AttributesDatabaseIdentifierImpl(String catalog, String schema, String table, boolean useSchemaPattern, boolean useTablePattern, String attributeNamePattern) {
            super(catalog, schema, table, useSchemaPattern, useTablePattern);
            this.attributeNamePattern = attributeNamePattern;
        }

        public String getAttributeNamePattern() {
            return this.attributeNamePattern;
        }

        @Override
        public boolean matches(DatabaseIdentifier object) {
            if (!super.matches(object)) {
                return false;
            }
            AttributesDatabaseIdentifierImpl other = (AttributesDatabaseIdentifierImpl)object;
            if (null == this.attributeNamePattern) {
                return false;
            }
            if (null == other.getAttributeNamePattern()) {
                return false;
            }
            return StringUtil.matchesPerl5((String)other.getAttributeNamePattern(), (String)this.convert(this.attributeNamePattern), (boolean)MockDatabaseMetaData.this.caseSensitive);
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            AttributesDatabaseIdentifierImpl other = (AttributesDatabaseIdentifierImpl)object;
            if (null != this.attributeNamePattern && !this.attributeNamePattern.equals(other.getAttributeNamePattern())) {
                return false;
            }
            return null == other.getAttributeNamePattern() || other.getAttributeNamePattern().equals(this.attributeNamePattern);
        }

        @Override
        public int hashCode() {
            int hashCode = super.hashCode();
            if (null != this.attributeNamePattern) {
                hashCode = 31 * hashCode + this.attributeNamePattern.hashCode();
            }
            return hashCode;
        }
    }

    private class DatabaseIdentifierImpl
    implements DatabaseIdentifier {
        private boolean isGlobal;
        private String catalog;
        private String schema;
        private String table;
        private boolean useSchemaPattern;
        private boolean useTablePattern;

        public DatabaseIdentifierImpl() {
            this.isGlobal = true;
        }

        public DatabaseIdentifierImpl(String catalog, String schema, String table) {
            this(catalog, schema, table, false, false);
        }

        public DatabaseIdentifierImpl(String catalog, String schema, String table, boolean useSchemaPattern, boolean useTablePattern) {
            this.isGlobal = false;
            this.catalog = catalog;
            this.schema = schema;
            this.table = table;
            this.useSchemaPattern = useSchemaPattern;
            this.useTablePattern = useTablePattern;
        }

        public String getCatalog() {
            return this.catalog;
        }

        @Override
        public boolean isGlobal() {
            return this.isGlobal;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getTable() {
            return this.table;
        }

        protected String convert(String name) {
            if (name.indexOf(37) != -1) {
                name = StringUtil.replaceAll((String)name, (String)"%", (String)".*");
            }
            if (name.indexOf(95) != -1) {
                name = StringUtil.replaceAll((String)name, (String)"_", (String)".");
            }
            return name;
        }

        @Override
        public boolean matches(DatabaseIdentifier object) {
            if (null == object) {
                return false;
            }
            if (!object.getClass().equals(this.getClass())) {
                return false;
            }
            DatabaseIdentifierImpl other = (DatabaseIdentifierImpl)object;
            if (this.isGlobal != other.isGlobal()) {
                return false;
            }
            if (!this.matchesCatalog(other)) {
                return false;
            }
            if (!this.matchesSchema(other)) {
                return false;
            }
            return this.matchesTable(other);
        }

        private boolean matchesCatalog(DatabaseIdentifierImpl other) {
            if (null == this.getCatalog()) {
                return true;
            }
            if (this.catalog.length() == 0) {
                return other.getCatalog() == null || other.getCatalog().length() == 0;
            }
            if (other.getCatalog() == null) {
                return false;
            }
            return StringUtil.matchesExact((String)other.getCatalog(), (String)this.catalog, (boolean)MockDatabaseMetaData.this.caseSensitive);
        }

        private boolean matchesSchema(DatabaseIdentifierImpl other) {
            if (null == this.getSchema()) {
                return true;
            }
            if (this.schema.length() == 0) {
                return other.getSchema() == null || other.getSchema().length() == 0;
            }
            if (other.getSchema() == null) {
                return false;
            }
            if (!this.useSchemaPattern) {
                return StringUtil.matchesExact((String)other.getSchema(), (String)this.schema, (boolean)MockDatabaseMetaData.this.caseSensitive);
            }
            return StringUtil.matchesPerl5((String)other.getSchema(), (String)this.convert(this.schema), (boolean)MockDatabaseMetaData.this.caseSensitive);
        }

        private boolean matchesTable(DatabaseIdentifierImpl other) {
            if (null == this.table) {
                return false;
            }
            if (null == other.getTable()) {
                return false;
            }
            if (!this.useTablePattern) {
                return StringUtil.matchesExact((String)other.getTable(), (String)this.table, (boolean)MockDatabaseMetaData.this.caseSensitive);
            }
            return StringUtil.matchesPerl5((String)other.getTable(), (String)this.convert(this.table), (boolean)MockDatabaseMetaData.this.caseSensitive);
        }

        public boolean equals(Object object) {
            if (null == object) {
                return false;
            }
            if (!object.getClass().equals(this.getClass())) {
                return false;
            }
            DatabaseIdentifierImpl other = (DatabaseIdentifierImpl)object;
            if (this.isGlobal != other.isGlobal()) {
                return false;
            }
            if (null != this.catalog && !this.catalog.equals(other.getCatalog())) {
                return false;
            }
            if (null != other.getCatalog() && !other.getCatalog().equals(this.catalog)) {
                return false;
            }
            if (null != this.schema && !this.schema.equals(other.getSchema())) {
                return false;
            }
            if (null != other.getSchema() && !other.getSchema().equals(this.schema)) {
                return false;
            }
            if (null != this.table && !this.table.equals(other.getTable())) {
                return false;
            }
            return null == other.getTable() || other.getTable().equals(this.table);
        }

        public int hashCode() {
            int hashCode = 17;
            if (null != this.catalog) {
                hashCode = 31 * hashCode + this.catalog.hashCode();
            }
            if (null != this.schema) {
                hashCode = 31 * hashCode + this.schema.hashCode();
            }
            if (null != this.table) {
                hashCode = 31 * hashCode + this.table.hashCode();
            }
            return hashCode;
        }
    }

    private static interface DatabaseIdentifier {
        public boolean isGlobal();

        public boolean matches(DatabaseIdentifier var1);
    }
}

