/*
 * Decompiled with CFR 0.152.
 */
package com.jthinking.common.util.ip.parser;

import com.jthinking.common.util.ip.IPv4Info;
import com.jthinking.common.util.ip.IPv6Info;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.List;

public class IpParser {
    public static byte[] hexStringToByte(String hex) {
        byte[] b = new byte[hex.length() / 2];
        int j = 0;
        for (int i = 0; i < b.length; ++i) {
            char c0 = hex.charAt(j++);
            char c1 = hex.charAt(j++);
            b[i] = (byte)(IpParser.parse(c0) << 4 | IpParser.parse(c1));
        }
        return b;
    }

    public static int parse(char c) {
        if (c >= 'a') {
            return c - 97 + 10 & 0xF;
        }
        if (c >= 'A') {
            return c - 65 + 10 & 0xF;
        }
        return c - 48 & 0xF;
    }

    public static IPv4Info getIPv4Info(byte[] ipv4Bytes) {
        if (ipv4Bytes.length != 4) {
            throw new IllegalArgumentException("ipv4 must be 4 bytes length");
        }
        return null;
    }

    public static String ipv4BytesToString(byte[] ipv4Bytes) {
        return IpParser.ipv4BytesToString(ipv4Bytes, 0, ipv4Bytes.length);
    }

    public static String ipv4BytesToString(byte[] ipv4Bytes, int offset, int length) {
        if (length != 4) {
            throw new IllegalArgumentException("ipv4 must be 4 bytes length");
        }
        StringBuilder builder = new StringBuilder();
        for (int i = offset; i < offset + length; ++i) {
            int ipSegment = Byte.toUnsignedInt(ipv4Bytes[i]);
            if (i != offset) {
                builder.append('.');
            }
            builder.append(ipSegment);
        }
        return builder.toString();
    }

    public static String ipBytesToString(byte[] ipBytes, int offset, int length) {
        if (length == 4) {
            return IpParser.ipv4BytesToString(ipBytes, offset, length);
        }
        if (length == 16) {
            return IpParser.getShortIPv6(ipBytes, offset, length);
        }
        throw new IllegalArgumentException("Illegal ip length");
    }

    public static IPv6Info getIPv6Info(byte[] ipv6Bytes) {
        if (ipv6Bytes.length != 16) {
            throw new IllegalArgumentException("ipv6 must be 16 bytes length");
        }
        BigInteger integer = new BigInteger(ipv6Bytes);
        return null;
    }

    public static String getShortIPv6(byte[] ipv6Bytes, int offset, int length) {
        StringBuilder builder = new StringBuilder();
        int endPosition = offset + length;
        int zeroCount = 0;
        for (int i = offset; i < endPosition; i += 2) {
            String s2;
            int i1 = ipv6Bytes[i] & 0xFF;
            int i2 = ipv6Bytes[i + 1] & 0xFF;
            if (i == 0 && i1 == 0 && i2 == 0) {
                builder.append(':');
            }
            if (i1 != 0) {
                String s1 = Integer.toHexString(i1);
                builder.append(s1);
            }
            if ((s2 = Integer.toHexString(i2)).length() < 2 && i1 != 0) {
                builder.append('0');
            }
            builder.append(s2);
            if (i != ipv6Bytes.length - 2) {
                builder.append(':');
            }
            zeroCount = i1 == 0 && i2 == 0 ? ++zeroCount : 0;
            if (zeroCount > 1) {
                if (zeroCount == 2) {
                    builder.delete(builder.length() - 4, builder.length());
                    builder.append(':');
                } else {
                    builder.delete(builder.length() - 2, builder.length());
                }
            }
            if (zeroCount != 8 && (i != 14 || zeroCount <= 1)) continue;
            builder.append(':');
        }
        String ip = builder.toString();
        if (ip.endsWith(":") && !ip.endsWith("::")) {
            ip = ip.substring(0, ip.lastIndexOf(58));
        }
        return ip;
    }

    public static String formatIPv6(String ipv6Hex) {
        char[] chars = ipv6Hex.toCharArray();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            builder.append(chars[i]);
            if ((i + 1) % 4 != 0 || i == chars.length - 1) continue;
            builder.append(':');
        }
        return builder.toString();
    }

    public static String longToIP(long longIp) {
        return (longIp >>> 24) + "." + ((longIp & 0xFFFFFFL) >>> 16) + "." + ((longIp & 0xFFFFL) >>> 8) + "." + (longIp & 0xFFL);
    }

    public static String parseIP(List<Integer> ip) {
        if (ip.size() == 1) {
            long l = Integer.toUnsignedLong(ip.get(0));
            return IpParser.longToIP(l);
        }
        return IpParser.leftPadZero(Integer.toUnsignedString(ip.get(0), 16), 8) + IpParser.leftPadZero(Integer.toUnsignedString(ip.get(1), 16), 8) + IpParser.leftPadZero(Integer.toUnsignedString(ip.get(2), 16), 8) + IpParser.leftPadZero(Integer.toUnsignedString(ip.get(3), 16), 8);
    }

    public static String parseIPBytes(byte[] ipBytes, int offset, int length) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(ipBytes, offset, length);
        if (length == 4) {
            long l = Integer.toUnsignedLong(byteBuffer.getInt());
            return IpParser.longToIP(l);
        }
        return IpParser.leftPadZero(Integer.toUnsignedString(byteBuffer.getInt(), 16), 8) + IpParser.leftPadZero(Integer.toUnsignedString(byteBuffer.getInt(), 16), 8) + IpParser.leftPadZero(Integer.toUnsignedString(byteBuffer.getInt(), 16), 8) + IpParser.leftPadZero(Integer.toUnsignedString(byteBuffer.getInt(), 16), 8);
    }

    public static String leftPadZero(String source, int size) {
        if (source.length() >= size) {
            return source;
        }
        StringBuilder builder = new StringBuilder(source);
        for (int i = 0; i < size - source.length(); ++i) {
            builder.insert(0, '0');
        }
        return builder.toString();
    }

    public static byte[] intToByte4(int i) {
        byte[] targets = new byte[4];
        targets[3] = (byte)(i & 0xFF);
        targets[2] = (byte)(i >> 8 & 0xFF);
        targets[1] = (byte)(i >> 16 & 0xFF);
        targets[0] = (byte)(i >> 24 & 0xFF);
        return targets;
    }

    public static void getIpInfo(List<Integer> ip) {
        int i = Integer.parseUnsignedInt("FFFF", 16);
        if (ip.size() == 1) {
            long l = Integer.toUnsignedLong(ip.get(0));
        } else {
            Integer.toUnsignedString(ip.get(0), 16);
        }
    }

    public static String getFullIPv6(String ipv6) {
        if (ipv6.equals("::")) {
            return "0000:0000:0000:0000:0000:0000:0000:0000";
        }
        if (ipv6.endsWith("::")) {
            ipv6 = ipv6 + "0";
        }
        String[] arrs = ipv6.split(":");
        StringBuilder symbol = new StringBuilder("::");
        for (int arrleng = arrs.length; arrleng < 8; ++arrleng) {
            symbol.append(":");
        }
        ipv6 = ipv6.replace("::", symbol.toString());
        StringBuilder fullip = new StringBuilder();
        for (String ip : ipv6.split(":")) {
            StringBuilder ipBuilder = new StringBuilder(ip);
            while (ipBuilder.length() < 4) {
                ipBuilder.insert(0, "0");
            }
            ip = ipBuilder.toString();
            fullip.append(ip).append(':');
        }
        return fullip.substring(0, fullip.length() - 1);
    }

    public static BigInteger getIPv6BigInteger(String ipv6) {
        return new BigInteger(IpParser.ipv6ToBytes(IpParser.getFullIPv6(ipv6)));
    }

    public static byte[] ipv6ToBytes(String ipv6) {
        byte[] ret = new byte[17];
        ret[0] = 0;
        int ib = 16;
        boolean comFlag = false;
        if (ipv6.startsWith(":")) {
            ipv6 = ipv6.substring(1);
        }
        String[] groups = ipv6.split(":");
        for (int ig = groups.length - 1; ig > -1; --ig) {
            if (groups[ig].contains(".")) {
                byte[] temp = IpParser.ipv4ToBytes(groups[ig]);
                ret[ib--] = temp[4];
                ret[ib--] = temp[3];
                ret[ib--] = temp[2];
                ret[ib--] = temp[1];
                comFlag = true;
                continue;
            }
            if ("".equals(groups[ig])) {
                int zlg = 9 - (groups.length + (comFlag ? 1 : 0));
                while (zlg-- > 0) {
                    ret[ib--] = 0;
                    ret[ib--] = 0;
                }
                continue;
            }
            int temp = Integer.parseInt(groups[ig], 16);
            ret[ib--] = (byte)temp;
            ret[ib--] = (byte)(temp >> 8);
        }
        return ret;
    }

    public static byte[] ipv4ToBytes(String ipv4) {
        byte[] ret = new byte[5];
        ret[0] = 0;
        int position1 = ipv4.indexOf(".");
        int position2 = ipv4.indexOf(".", position1 + 1);
        int position3 = ipv4.indexOf(".", position2 + 1);
        ret[1] = (byte)Integer.parseInt(ipv4.substring(0, position1));
        ret[2] = (byte)Integer.parseInt(ipv4.substring(position1 + 1, position2));
        ret[3] = (byte)Integer.parseInt(ipv4.substring(position2 + 1, position3));
        ret[4] = (byte)Integer.parseInt(ipv4.substring(position3 + 1));
        return ret;
    }
}

